/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.tk.ui.util;

import java.util.LinkedList;
import javax.swing.SpinnerModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DoubleSpinnerModel
implements SpinnerModel {
    private double value = 0.0;
    private LinkedList<ChangeListener> listeners = new LinkedList();
    private double step = 1.0;

    @Override
    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    @Override
    public Object getNextValue() {
        return this.value + this.step;
    }

    @Override
    public Object getPreviousValue() {
        return this.value - this.step;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    public double getDoubleValue() {
        return this.value;
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void setValue(Object value) {
        this.value = ((Number)value).doubleValue();
        this.notifyListeners();
    }

    public double getStep() {
        return this.step;
    }

    public void setStep(double step) {
        this.step = step;
    }

    private void notifyListeners() {
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener l : this.listeners) {
            l.stateChanged(e);
        }
    }
}

