/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.plugin.cutting;

import com.artenum.cassandra.pipeline.CassandraObject;
import com.artenum.cassandra.pipeline.Filter;
import com.artenum.cassandra.pipeline.FilterImpl;
import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.pipeline.RemoveListener;
import com.artenum.cassandra.pipeline.graph.VtkObjectCellAdapter;
import com.artenum.cassandra.plugin.CassandraPlugInProperty;
import com.artenum.cassandra.plugin.CassandraPlugin;
import com.artenum.cassandra.plugin.PlugInControlUI;
import com.artenum.cassandra.plugin.PluginManager;
import com.artenum.cassandra.plugin.SimplePlugInProperty;
import com.artenum.cassandra.plugin.cutting.CuttingPlaneControlUI;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import vtk.vtkActor;
import vtk.vtkCutter;
import vtk.vtkDataObject;
import vtk.vtkDataSet;
import vtk.vtkImplicitFunction;
import vtk.vtkImplicitPlaneWidget;
import vtk.vtkLookupTable;
import vtk.vtkMapper;
import vtk.vtkObject;
import vtk.vtkPlane;
import vtk.vtkPolyDataMapper;
import vtk.vtkRenderWindowInteractor;
import vtk.vtkScalarBarActor;
import vtk.vtkScalarsToColors;

public class CuttingPlanePlugin
implements CassandraPlugin,
RemoveListener {
    private String name;
    private PipeLineManager pipelineManager;
    private PluginManager pluginManager;
    private JPopupMenu contextualMenu;
    private int nbUpdate = 0;
    private CuttingPlaneControlUI controlUI;
    private vtkDataSet lastDataSet;
    private vtkLookupTable lookupTable;
    private vtkScalarBarActor scalarBar;
    private vtkPlane sourcePlane;
    private vtkCutter planeCut;
    private vtkPolyDataMapper cutMapper;
    private vtkActor cutActor;
    private vtkScalarBarActor scalBar;
    private Filter filterImpl;
    private CassandraObject outputCassActor;
    private CassandraObject outputCassMapper;
    private CassandraObject outputCassDataset;
    private CassandraObject outputCassLookupTable;
    private CassandraObject outputCassScalarBar;
    private CassandraObject cassFilter;
    private vtkImplicitPlaneWidget planWidget;
    private Point cellPosition;
    public static final String PERSISTENCE_KEY_INPUT_DATASET = "persistence.key.inputVtkDataSet";
    public static final String PERSISTENCE_KEY_CX = "persistence.key.cx";
    public static final String PERSISTENCE_KEY_CY = "persistence.key.cy";
    public static final String PERSISTENCE_KEY_CZ = "persistence.key.cz";
    public static final String PERSISTENCE_KEY_NX = "persistence.key.nx";
    public static final String PERSISTENCE_KEY_NY = "persistence.key.ny";
    public static final String PERSISTENCE_KEY_NZ = "persistence.key.nz";
    public static final String PERSISTENCE_KEY_OUPUT_DATASET = "persistence.key.outputDataSet";
    public static final String PERSISTENCE_KEY_OUPUT_MAPPER = "persistence.key.outputMapper";
    public static final String PERSISTENCE_KEY_OUPUT_LOOKUP_TABLE = "persistence.key.outputlookUpTable";
    public static final String PERSISTENCE_KEY_OUTPUT_ACTOR = "persistence.key.outputActor";
    public static final String PERSISTENCE_KEY_OUTPUT_SCALAR_BAR = "persistence.key.ouputScalarBar";
    public static final String PERSISTENCE_KEY_CELL_POS_X = "persistence.key.cell.PosX";
    public static final String PERSISTENCE_KEY_CELL_POS_Y = "persistence.key.cell.PosY";

    public CuttingPlanePlugin(PipeLineManager pipelineManager, PluginManager pluginManager, Frame owner) {
        this.initPlugIn(pipelineManager, pluginManager, owner);
        this.initPipeline();
    }

    public CuttingPlanePlugin(PipeLineManager pipelineManager, PluginManager pluginManager, Frame owner, boolean initPipeline) {
        this.initPlugIn(pipelineManager, pluginManager, owner);
        if (initPipeline) {
            this.initPipeline();
        }
    }

    public void initPlugIn(PipeLineManager pipelineManager, PluginManager pluginManager, Frame owner) {
        this.name = "Cutting plane";
        this.pipelineManager = pipelineManager;
        this.pluginManager = pluginManager;
        this.filterImpl = new FilterImpl();
        this.filterImpl.addRemoveListener((RemoveListener)this);
        this.filterImpl.setParentPlugin((CassandraPlugin)this);
        this.controlUI = new CuttingPlaneControlUI(pipelineManager, this, owner);
        this.contextualMenu = new JPopupMenu("Cutting plane menu");
        JMenuItem showControl = new JMenuItem("Show control");
        showControl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CuttingPlanePlugin.this.controlUI.setVisible(true);
                CuttingPlanePlugin.this.controlUI.update3DWidgetStatus();
            }
        });
        this.contextualMenu.add(showControl);
        this.contextualMenu.addSeparator();
        JMenuItem remove = new JMenuItem("Remove");
        remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CuttingPlanePlugin.this.remove();
            }
        });
        this.contextualMenu.add(remove);
    }

    public void initPipeline() {
        if (this.sourcePlane == null) {
            this.sourcePlane = new vtkPlane();
        }
        this.sourcePlane.SetOrigin(0.0, 0.0, 0.0);
        this.sourcePlane.SetNormal(0.0, 0.0, 1.0);
        if (this.planeCut == null) {
            this.planeCut = new vtkCutter();
            this.outputCassDataset = this.pipelineManager.addDataSet((Object)this.planeCut.GetOutput(), "Cutting plane");
        } else {
            this.outputCassDataset = this.pipelineManager.getCassandraVtkObjectByTrueVtkObject((vtkObject)this.planeCut);
        }
        this.planeCut.SetCutFunction((vtkImplicitFunction)this.sourcePlane);
        if (this.cutMapper == null) {
            this.cutMapper = new vtkPolyDataMapper();
            this.outputCassMapper = this.pipelineManager.addMapper((Object)this.cutMapper, "Cutting plane");
        } else {
            this.outputCassMapper = this.pipelineManager.getCassandraVtkObjectByTrueVtkObject((vtkObject)this.cutMapper);
        }
        this.cutMapper.SetInput(this.planeCut.GetOutput());
        if (this.cutActor == null) {
            this.cutActor = new vtkActor();
            this.outputCassActor = this.pipelineManager.addActor((Object)this.cutActor, "Cutting plane");
        } else {
            this.outputCassActor = this.pipelineManager.getCassandraVtkObjectByTrueVtkObject((vtkObject)this.cutActor);
        }
        this.cutActor.SetMapper((vtkMapper)this.cutMapper);
        if (this.lookupTable == null) {
            this.lookupTable = new vtkLookupTable();
            this.outputCassLookupTable = this.pipelineManager.addLookupTable(this.lookupTable, "Clipping plane");
        } else {
            this.outputCassLookupTable = this.pipelineManager.getCassandraVtkObjectByTrueVtkObject((vtkObject)this.lookupTable);
        }
        this.lookupTable.SetHueRange(0.66667, 0.0);
        this.lookupTable.Build();
        this.cutMapper.SetLookupTable((vtkScalarsToColors)this.lookupTable);
        if (this.scalBar == null) {
            this.scalBar = new vtkScalarBarActor();
            this.outputCassScalarBar = this.pipelineManager.addScalarBar(this.scalBar, "Clipping plane");
        } else {
            this.outputCassScalarBar = this.pipelineManager.getCassandraVtkObjectByTrueVtkObject((vtkObject)this.scalBar);
        }
        this.scalBar.SetLookupTable((vtkScalarsToColors)this.lookupTable);
        this.cassFilter = this.pipelineManager.addFilter(this.filterImpl, "Cutting plane");
        this.cassFilter.getMetaData().put("POPUP_MENU", this.getContextualMenu());
        this.outputCassActor.setValide(false);
        if (this.planWidget != null) {
            this.planWidget.SetNormal(this.sourcePlane.GetNormal());
            this.planWidget.SetOrigin(this.sourcePlane.GetOrigin());
        }
    }

    public void updateCuttingPlane(double cx, double cy, double cz, double nx, double ny, double nz, vtkDataSet vtkDataSetIn) {
        if (vtkDataSetIn == null) {
            return;
        }
        this.outputCassLookupTable = this.pipelineManager.getCassandraVtkObjectByTrueVtkObject((vtkObject)((vtkLookupTable)this.cutMapper.GetLookupTable()));
        this.lookupTable = (vtkLookupTable)this.outputCassLookupTable.getVtkObject();
        this.outputCassScalarBar = this.pipelineManager.getVtkObject((Integer)this.outputCassLookupTable.getOutputConnectivityList().get(0));
        this.scalarBar = (vtkScalarBarActor)this.outputCassScalarBar.getVtkObject();
        this.outputCassActor.setValide(true);
        this.sourcePlane.SetOrigin(cx, cy, cz);
        this.sourcePlane.SetNormal(nx, ny, nz);
        this.planeCut.SetInput((vtkDataObject)vtkDataSetIn);
        if (!(vtkDataSetIn.GetPointData().GetScalars() == null && vtkDataSetIn.GetCellData().GetScalars() == null || this.lastDataSet != null && this.lastDataSet.equals(vtkDataSetIn) || !this.cutMapper.GetLookupTable().equals(this.lookupTable))) {
            this.cutMapper.SetScalarRange(vtkDataSetIn.GetScalarRange());
            this.lookupTable.SetTableRange(vtkDataSetIn.GetScalarRange());
            this.lastDataSet = vtkDataSetIn;
        }
        if (this.nbUpdate++ == 0 && this.pipelineManager.getActorList().getData().contains(this.outputCassActor)) {
            this.pipelineManager.setActorVisible(this.outputCassActor, true);
        }
        this.pipelineManager.hideInputActor(this.outputCassActor, vtkDataSetIn);
        this.filterImpl.getInputDataSet().clear();
        this.filterImpl.getInputDataSet().add(vtkDataSetIn);
        this.filterImpl.getOutputDataSet().clear();
        this.filterImpl.getOutputDataSet().add(this.planeCut.GetOutput());
        this.filterImpl.getAlgorithm().add(this.sourcePlane);
        this.filterImpl.getVtkImplicitFunction().clear();
        this.filterImpl.getVtkImplicitFunction().add(this.sourcePlane);
        this.pipelineManager.notifyConnectivityChange(this.cassFilter);
        if (this.planWidget != null) {
            this.planWidget.SetNormal(this.sourcePlane.GetNormal());
            this.planWidget.SetOrigin(this.sourcePlane.GetOrigin());
        }
    }

    public String getName() {
        return this.name;
    }

    public JPopupMenu getContextualMenu() {
        return this.contextualMenu;
    }

    public void remove() {
        this.pluginManager.removePlugin((CassandraPlugin)this);
        this.pipelineManager.removeVtkObject(this.outputCassActor);
        this.pipelineManager.removeVtkObject(this.outputCassMapper);
        this.pipelineManager.removeVtkObject(this.outputCassDataset);
        this.pipelineManager.removeVtkObject(this.cassFilter);
        this.planWidget.Off();
    }

    public String toString() {
        return this.getName();
    }

    void show3DWidget(boolean widgetFlag) {
        if (widgetFlag) {
            if (this.planWidget == null) {
                this.init3DWidget();
            }
            this.planWidget.UpdatePlacement();
            this.planWidget.On();
        } else if (this.planWidget != null) {
            this.planWidget.Off();
        }
    }

    void init3DWidget() {
        this.planWidget = new vtkImplicitPlaneWidget();
        this.planWidget.SetInteractor((vtkRenderWindowInteractor)this.pipelineManager.getCassandraView().getIren());
        this.planWidget.EnabledOn();
        this.pipelineManager.getCassandraView().deepValidateView();
        this.planWidget.SetInput(this.lastDataSet);
        this.planWidget.SetPlaceFactor(1.2);
        this.planWidget.PlaceWidget();
        this.planWidget.SetNormal(this.sourcePlane.GetNormal());
        System.out.println(this.planWidget.GetNormal()[0] + " " + this.planWidget.GetNormal()[1] + " " + this.planWidget.GetNormal()[2]);
        this.planWidget.GetPlaneProperty().SetOpacity(0.3);
        this.planWidget.AddObserver("InteractionEvent", (Object)this, "interactionCallBack");
    }

    private void widgetCharEvent() {
        char code = Character.toLowerCase(this.pipelineManager.getCassandraView().getIren().GetKeyCode());
        System.out.println("touch typed:" + code);
        if (code == 'b') {
            this.planWidget.SetEnabled(1);
        }
    }

    private void startInteractionCallBack() {
        System.out.println("wiget interaction started");
    }

    private void interactionCallBack() {
        this.sourcePlane.SetNormal(this.planWidget.GetNormal());
        this.controlUI.setNormalFieldsValues(this.planWidget.GetNormal());
        this.controlUI.setOrigineFieldsValues(this.planWidget.GetOrigin());
        this.sourcePlane.SetOrigin(this.planWidget.GetOrigin()[0], this.planWidget.GetOrigin()[1], this.planWidget.GetOrigin()[2]);
    }

    public Filter getInternalFilter() {
        return this.filterImpl;
    }

    public CassandraPlugInProperty getPlugInProperty() {
        this.outputCassLookupTable = this.pipelineManager.getCassandraVtkObjectByTrueVtkObject((vtkObject)((vtkLookupTable)this.cutMapper.GetLookupTable()));
        this.lookupTable = (vtkLookupTable)this.outputCassLookupTable.getVtkObject();
        this.outputCassScalarBar = this.pipelineManager.getVtkObject((Integer)this.outputCassLookupTable.getOutputConnectivityList().get(0));
        this.scalarBar = (vtkScalarBarActor)this.outputCassScalarBar.getVtkObject();
        SimplePlugInProperty prop = new SimplePlugInProperty();
        prop.put((Object)PERSISTENCE_KEY_CX, (Object)new Double(this.sourcePlane.GetOrigin()[0]));
        prop.put((Object)PERSISTENCE_KEY_CY, (Object)new Double(this.sourcePlane.GetOrigin()[1]));
        prop.put((Object)PERSISTENCE_KEY_CZ, (Object)new Double(this.sourcePlane.GetOrigin()[2]));
        prop.put((Object)PERSISTENCE_KEY_NX, (Object)new Double(this.sourcePlane.GetNormal()[0]));
        prop.put((Object)PERSISTENCE_KEY_NY, (Object)new Double(this.sourcePlane.GetNormal()[1]));
        prop.put((Object)PERSISTENCE_KEY_NZ, (Object)new Double(this.sourcePlane.GetNormal()[2]));
        prop.put((Object)PERSISTENCE_KEY_INPUT_DATASET, (Object)this.planeCut.GetInput());
        prop.put((Object)PERSISTENCE_KEY_OUPUT_DATASET, (Object)this.planeCut.GetOutput());
        prop.put((Object)PERSISTENCE_KEY_OUPUT_MAPPER, (Object)this.cutMapper);
        prop.put((Object)PERSISTENCE_KEY_OUPUT_LOOKUP_TABLE, this.outputCassLookupTable.getVtkObject());
        prop.put((Object)PERSISTENCE_KEY_OUTPUT_ACTOR, this.outputCassActor.getVtkObject());
        prop.put((Object)PERSISTENCE_KEY_OUTPUT_SCALAR_BAR, this.outputCassScalarBar.getVtkObject());
        Point cellPosition = ((VtkObjectCellAdapter)this.cassFilter.getMetaData().get("CELL")).getPosition();
        prop.put((Object)PERSISTENCE_KEY_CELL_POS_X, (Object)cellPosition.x);
        prop.put((Object)PERSISTENCE_KEY_CELL_POS_Y, (Object)cellPosition.y);
        return prop;
    }

    public PlugInControlUI getControlUI() {
        return this.controlUI;
    }

    public void initAndUpdate(CassandraPlugInProperty prop) {
        double cx = 0.0;
        double cy = 0.0;
        double cz = 0.0;
        double nx = 0.0;
        double ny = 0.0;
        double nz = 0.0;
        cx = prop.getSafely((Object)PERSISTENCE_KEY_CX, 0.0);
        cy = prop.getSafely((Object)PERSISTENCE_KEY_CY, 0.0);
        cz = prop.getSafely((Object)PERSISTENCE_KEY_CZ, 0.0);
        nx = prop.getSafely((Object)PERSISTENCE_KEY_NX, 1.0);
        ny = prop.getSafely((Object)PERSISTENCE_KEY_NY, 0.0);
        nz = prop.getSafely((Object)PERSISTENCE_KEY_NZ, 0.0);
        this.planeCut = new vtkCutter();
        this.planeCut.SetOutput((vtkDataObject)prop.getSafely((Object)PERSISTENCE_KEY_OUPUT_DATASET, null));
        vtkDataSet tmpInputDataSet = (vtkDataSet)prop.getSafely((Object)PERSISTENCE_KEY_INPUT_DATASET, (Object)((vtkDataSet)this.planeCut.GetInput()));
        this.lookupTable = (vtkLookupTable)prop.getSafely((Object)PERSISTENCE_KEY_OUPUT_LOOKUP_TABLE, null);
        this.cutMapper = (vtkPolyDataMapper)prop.getSafely((Object)PERSISTENCE_KEY_OUPUT_MAPPER, null);
        this.cutActor = (vtkActor)prop.getSafely((Object)PERSISTENCE_KEY_OUTPUT_ACTOR, null);
        this.scalarBar = (vtkScalarBarActor)prop.getSafely((Object)PERSISTENCE_KEY_OUTPUT_SCALAR_BAR, null);
        this.initPipeline();
        this.controlUI.setNormalFieldsValues(nx, ny, nz);
        this.controlUI.setOrigineFieldsValues(cx, cy, cz);
        this.controlUI.setSelectedInput(this.pipelineManager.getCassandraVtkObjectByTrueVtkObject((vtkObject)tmpInputDataSet));
        this.updateCuttingPlane(cx, cy, cy, nx, ny, cy, tmpInputDataSet);
        int cellPosX = prop.getSafely((Object)PERSISTENCE_KEY_CELL_POS_X, -1);
        int cellPosY = prop.getSafely((Object)PERSISTENCE_KEY_CELL_POS_Y, -1);
        if (cellPosX > 0 && cellPosY > 0) {
            ((VtkObjectCellAdapter)this.cassFilter.getMetaData().get("CELL")).setPosition(new Point(cellPosX, cellPosY));
        }
    }
}

