/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.penelope.plugin.gmsh.mesh;

import com.artenum.penelope.field.DataFieldManager;
import com.artenum.penelope.mesh.CartesianPoint;
import com.artenum.penelope.mesh.UnstructuredMesh;
import com.artenum.penelope.mesh.element.Node;
import com.artenum.penelope.mesh.element.Segment;
import com.artenum.penelope.mesh.element.Tetrahedron;
import com.artenum.penelope.mesh.element.Triangle;
import com.artenum.penelope.mesh.interfaces.Edge;
import com.artenum.penelope.mesh.interfaces.Face;
import com.artenum.penelope.mesh.interfaces.Mesh;
import com.artenum.penelope.mesh.interfaces.MeshMask;
import com.artenum.penelope.mesh.interfaces.Point;
import com.artenum.penelope.mesh.interfaces.Polyhedron;
import com.artenum.penelope.mesh.interfaces.Vertex;
import com.artenum.penelope.mesh.io.FileFormatException;
import com.artenum.penelope.mesh.mask.EdgeMeshMask;
import com.artenum.penelope.mesh.mask.FaceMeshMask;
import com.artenum.penelope.mesh.mask.PolyhedronMeshMask;
import com.artenum.penelope.mesh.mask.VertexMeshMask;
import com.artenum.penelope.plugin.gmsh.mesh.GeometryIdMapper;
import com.artenum.penelope.plugin.gmsh.mesh.GmshMeshBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;

public class GmshMeshBuilder10
implements GmshMeshBuilder {
    private static final int HEADER = 0;
    private static final int NODE_DEF = 1;
    private static final int BETWEEN_NODE_ELEM = 2;
    private static final int ELEM_DEF = 3;
    private static final int END = 4;
    private final Mesh mesh;
    private final File inputFile;
    private LineNumberReader lineReader;
    private final boolean storeOriginalIds;
    private final GeometryIdMapper idMapper;
    private int currentId;
    private int nbGmshNodes;
    private int currentGmshNodeNumber;
    private Point currentNode;
    private int nbGmshElements;
    private int currentGmshElementNumber;
    private Edge currentEdge;
    private Face currentFace;
    private Polyhedron currentPolyhedron;
    private int[] tags;
    private final List<Vertex> point15List;
    private String currentLine = null;
    private int filePartNumber;
    private String[] splitedLine;
    private int currentMeshElementType;

    public GmshMeshBuilder10(File fileToRead) {
        this(fileToRead, (Mesh)new UnstructuredMesh(), true);
    }

    public GmshMeshBuilder10(File fileToRead, boolean storeIds) {
        this(fileToRead, (Mesh)new UnstructuredMesh(), storeIds);
    }

    public GmshMeshBuilder10(File fileToRead, Mesh aMesh, boolean storeIds) {
        this(fileToRead, aMesh, storeIds, new GeometryIdMapper());
    }

    public GmshMeshBuilder10(File fileToRead, Mesh aMesh, boolean storeIds, GeometryIdMapper idMapper) {
        this.mesh = aMesh == null ? new UnstructuredMesh() : aMesh;
        this.inputFile = fileToRead;
        this.storeOriginalIds = storeIds;
        this.idMapper = idMapper;
        this.currentGmshElementNumber = 0;
        this.currentGmshNodeNumber = 0;
        this.filePartNumber = 0;
        this.point15List = new ArrayList<Vertex>();
    }

    public Mesh buildMeshAndIdReset() throws IOException, FileFormatException {
        this.buildMeshNoIdReset();
        this.mesh.clearIdentifiers();
        return this.mesh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mesh buildMeshNoIdReset() throws IOException, FileFormatException {
        FileReader fileReader = new FileReader(this.inputFile);
        FileReader fileReaderTmp = new FileReader(this.inputFile);
        this.lineReader = new LineNumberReader(fileReader);
        try {
            this.readMetaData();
            this.lineReader = new LineNumberReader(fileReaderTmp);
            this.readMesh();
        }
        finally {
            this.lineReader.close();
            fileReader.close();
            fileReaderTmp.close();
        }
        this.mesh.finalizeMesh();
        return this.mesh;
    }

    private boolean hasMoreNodes() {
        return this.currentGmshNodeNumber < this.nbGmshNodes;
    }

    private Point nextNode() {
        try {
            this.readNextLine();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.currentNode;
    }

    private boolean hasMoreMeshElements() {
        return this.currentGmshElementNumber < this.nbGmshElements;
    }

    private void nexElement() {
        try {
            this.readNextLine();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Edge nextEdge() {
        return this.currentEdge;
    }

    private Face nextFace() {
        return this.currentFace;
    }

    private Polyhedron nextPolyhedron() {
        return this.currentPolyhedron;
    }

    private void readNextLine() throws IOException {
        block0 : switch (this.filePartNumber) {
            case 0: {
                while ((this.currentLine = this.lineReader.readLine()) != null) {
                    if (this.currentLine.indexOf("$NOD") == -1) continue;
                    this.lineReader.readLine();
                    this.filePartNumber = 1;
                    this.splitedLine = this.convert(this.lineReader.readLine().split(" "));
                    int id = Integer.parseInt(this.splitedLine[0]);
                    float firstCoordinate = Float.parseFloat(this.splitedLine[1]);
                    float secondCoordinate = Float.parseFloat(this.splitedLine[2]);
                    float thirdCoordinate = Float.parseFloat(this.splitedLine[3]);
                    this.currentId = id;
                    this.currentNode = new CartesianPoint(new double[]{firstCoordinate, secondCoordinate, thirdCoordinate});
                    ++this.currentGmshNodeNumber;
                    if (this.hasMoreNodes()) break block0;
                    this.filePartNumber = 2;
                    break block0;
                }
                break;
            }
            case 1: {
                this.splitedLine = this.convert(this.lineReader.readLine().split(" "));
                int id = Integer.parseInt(this.splitedLine[0]);
                float firstCoordinate = Float.parseFloat(this.splitedLine[1]);
                float secondCoordinate = Float.parseFloat(this.splitedLine[2]);
                float thirdCoordinate = Float.parseFloat(this.splitedLine[3]);
                this.currentId = id;
                this.currentNode = new CartesianPoint(new double[]{firstCoordinate, secondCoordinate, thirdCoordinate});
                ++this.currentGmshNodeNumber;
                if (this.hasMoreNodes()) break;
                this.filePartNumber = 3;
                this.lineReader.readLine();
                this.lineReader.readLine();
                this.lineReader.readLine();
                break;
            }
            case 3: {
                String line = this.lineReader.readLine();
                this.splitedLine = this.convert(line.split("\\s+"));
                this.tags = new int[]{Integer.parseInt(this.splitedLine[2])};
                int firstNodeIndex = 5;
                switch (Integer.parseInt(this.splitedLine[1])) {
                    case 1: {
                        this.currentMeshElementType = 1;
                        int nodeId1 = this.idMapper.getPenelopeVertexId(Integer.parseInt(this.splitedLine[5]));
                        int nodeId2 = this.idMapper.getPenelopeVertexId(Integer.parseInt(this.splitedLine[6]));
                        int id = Integer.parseInt(this.splitedLine[0]);
                        this.currentEdge = new Segment(id, this.mesh, this.mesh.getVertexById(nodeId1), this.mesh.getVertexById(nodeId2));
                        break;
                    }
                    case 2: {
                        this.currentMeshElementType = 2;
                        int nodeId1 = this.idMapper.getPenelopeVertexId(Integer.parseInt(this.splitedLine[5]));
                        int nodeId2 = this.idMapper.getPenelopeVertexId(Integer.parseInt(this.splitedLine[6]));
                        int nodeId3 = this.idMapper.getPenelopeVertexId(Integer.parseInt(this.splitedLine[7]));
                        int id = Integer.parseInt(this.splitedLine[0]);
                        this.currentFace = new Triangle(id, this.mesh, this.mesh.getVertexById(nodeId1), this.mesh.getVertexById(nodeId2), this.mesh.getVertexById(nodeId3));
                        break;
                    }
                    case 4: {
                        this.currentMeshElementType = 4;
                        int nodeId1 = this.idMapper.getPenelopeVertexId(Integer.parseInt(this.splitedLine[5]));
                        int nodeId2 = this.idMapper.getPenelopeVertexId(Integer.parseInt(this.splitedLine[6]));
                        int nodeId3 = this.idMapper.getPenelopeVertexId(Integer.parseInt(this.splitedLine[7]));
                        int nodeId4 = this.idMapper.getPenelopeVertexId(Integer.parseInt(this.splitedLine[8]));
                        int id = Integer.parseInt(this.splitedLine[0]);
                        this.currentPolyhedron = new Tetrahedron(id, this.mesh, this.mesh.getVertexById(nodeId1), this.mesh.getVertexById(nodeId2), this.mesh.getVertexById(nodeId3), this.mesh.getVertexById(nodeId4));
                        break;
                    }
                    case 15: {
                        this.currentMeshElementType = 15;
                        Integer gmshIdOfAssociatedGmshNode = Integer.parseInt(this.splitedLine[5]);
                        Integer penelopeIdOfAssociatedGmshNode = this.idMapper.getPenelopeVertexId(gmshIdOfAssociatedGmshNode);
                        Vertex vertex = this.mesh.getVertexById(penelopeIdOfAssociatedGmshNode.intValue());
                        DataFieldManager dataFieldManager = this.mesh.getDataFieldManager();
                        for (int tag : this.tags) {
                            MeshMask vertexMeshMask = this.mesh.getDataFieldManager().getVertexMeshMaskById(tag);
                            if (vertexMeshMask == null) {
                                vertexMeshMask = new VertexMeshMask(tag, this.mesh);
                                this.mesh.getDataFieldManager().addVertexMeshMask(vertexMeshMask);
                            }
                            vertexMeshMask.addMeshElementId(vertex.getId());
                            dataFieldManager.addMeshMaskToVertexId(vertexMeshMask, vertex.getId());
                        }
                        int id = Integer.parseInt(this.splitedLine[0]);
                        this.point15List.add(vertex);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Mesh element type " + this.splitedLine[1] + " not supported in line " + line);
                    }
                }
                ++this.currentGmshElementNumber;
                if (this.hasMoreMeshElements()) break;
                this.filePartNumber = 4;
                break;
            }
            case 4: {
                this.lineReader.close();
            }
        }
    }

    private String[] convert(String[] currentLineToSplited) {
        ArrayList<String> list = new ArrayList<String>(10);
        for (String element : currentLineToSplited) {
            if (element.length() <= 0) continue;
            list.add(element);
        }
        return list.toArray(new String[0]);
    }

    private void readMetaData() throws IOException {
        while ((this.currentLine = this.lineReader.readLine()) != null) {
            if (this.currentLine.indexOf("$NOD") != -1) {
                this.nbGmshNodes = Integer.parseInt(this.lineReader.readLine().trim());
            }
            if (this.currentLine.indexOf("$ELM") == -1) continue;
            this.nbGmshElements = Integer.parseInt(this.lineReader.readLine().trim());
            break;
        }
        this.lineReader.close();
    }

    private void readMesh() {
        while (this.hasMoreNodes()) {
            Point point = this.nextNode();
            Node vertexToAdd = new Node(this.mesh, point);
            int penelopeId = this.mesh.addMeshElementAndClearConnectivity((Vertex)vertexToAdd);
            if (!this.storeOriginalIds) continue;
            this.idMapper.addVertexIdMapping(this.currentId, penelopeId);
        }
        DataFieldManager dataFieldManager = this.mesh.getDataFieldManager();
        block6: while (this.hasMoreMeshElements()) {
            this.nexElement();
            switch (this.currentMeshElementType) {
                case 1: {
                    Edge edge = this.nextEdge();
                    int readId = edge.getId();
                    int penelopeId = this.mesh.addMeshElementAndClearConnectivity(edge);
                    if (this.storeOriginalIds) {
                        this.idMapper.addEdgeIdMapping(readId, penelopeId);
                    }
                    for (int i : this.tags) {
                        MeshMask edgeMeshMask = this.mesh.getDataFieldManager().getEdgeMeshMaskById(i);
                        if (edgeMeshMask == null) {
                            edgeMeshMask = new EdgeMeshMask(i, this.mesh);
                            this.mesh.getDataFieldManager().addEdgeMeshMask(edgeMeshMask);
                        }
                        edgeMeshMask.addMeshElementId(penelopeId);
                        dataFieldManager.addMeshMaskToEdgeId(edgeMeshMask, penelopeId);
                    }
                    continue block6;
                }
                case 2: {
                    Face face = this.nextFace();
                    int readId = face.getId();
                    int penelopeId = this.mesh.addMeshElementAndClearConnectivity(face);
                    if (this.storeOriginalIds) {
                        this.idMapper.addFaceIdMapping(readId, penelopeId);
                    }
                    for (int i : this.tags) {
                        MeshMask faceMeshMask = this.mesh.getDataFieldManager().getFaceMeshMaskById(i);
                        if (faceMeshMask == null) {
                            faceMeshMask = new FaceMeshMask(i, this.mesh);
                            this.mesh.getDataFieldManager().addFaceMeshMask(faceMeshMask);
                        }
                        faceMeshMask.addMeshElementId(penelopeId);
                        dataFieldManager.addMeshMaskToFaceId(faceMeshMask, penelopeId);
                    }
                    continue block6;
                }
                case 4: {
                    Polyhedron polyhedron = this.nextPolyhedron();
                    int readId = polyhedron.getId();
                    int penelopeId = this.mesh.addMeshElementAndClearConnectivity(polyhedron);
                    if (this.storeOriginalIds) {
                        this.idMapper.addPolyhedronIdMapping(readId, penelopeId);
                    }
                    for (int i : this.tags) {
                        MeshMask polyhedronMeshMask = this.mesh.getDataFieldManager().getPolyhedronMeshMaskById(i);
                        if (polyhedronMeshMask == null) {
                            polyhedronMeshMask = new PolyhedronMeshMask(i, this.mesh);
                            this.mesh.getDataFieldManager().addPolyhedronMeshMask(polyhedronMeshMask);
                        }
                        polyhedronMeshMask.addMeshElementId(penelopeId);
                        dataFieldManager.addMeshMaskToPolyhedronId(polyhedronMeshMask, penelopeId);
                    }
                    continue block6;
                }
            }
        }
    }

    @Override
    public List<Vertex> getPoint15List() {
        return this.point15List;
    }

    @Override
    public GeometryIdMapper getIdMapper() {
        return this.idMapper;
    }
}

