/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.jyconsole.action;

import com.artenum.jyconsole.JyConsole;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class DefaultValidationAction
extends AbstractAction {
    private JyConsole console;

    public DefaultValidationAction(JyConsole jyConsole) {
        this.console = jyConsole;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = this.console.getInputComponent().getText();
        if (string.trim().length() > 0) {
            if (string.trim().equals("clear")) {
                this.console.getOutputComponent().setText("");
                this.console.getInputComponent().setText("");
                this.console.getHistoryManager().addCommandInHistory(string);
                return;
            }
            if (string.split("\n")[0].trim().endsWith(":") && !string.endsWith("\n")) {
                this.console.getInputComponent().appendText("\n", "style.default");
            } else {
                this.console.getOutputComponent().appendText("\n>>> " + string.replaceAll("\n", "\n... "), "style.default");
                this.console.getHistoryManager().addCommandInHistory(string);
                try {
                    this.console.getInterpreter().runsource(string);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this.console.getHistoryManager().stopHistoryNavigation();
                this.console.getInputComponent().setText("");
            }
        } else {
            this.console.getOutputComponent().appendText("\n>>> ", "style.default");
        }
        this.console.updateScrollPosition();
    }
}

