/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PyTuple;
import org.python.core.__builtin__;

public class codecs {
    private static char Py_UNICODE_REPLACEMENT_CHARACTER = (char)65533;
    private static PyList searchPath = new PyList();
    private static PyStringMap searchCache = new PyStringMap();
    private static String default_encoding = "ascii";
    private static boolean import_encodings_called = false;
    private static byte[] utf8_code_length = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 6, 6, 0, 0};
    private static char[] hexdigit = "0123456789ABCDEF".toCharArray();

    public static String getDefaultEncoding() {
        return default_encoding;
    }

    public static void setDefaultEncoding(String encoding) {
        codecs.lookup(encoding);
        default_encoding = encoding;
    }

    public static void register(PyObject search_function) {
        if (!search_function.isCallable()) {
            throw Py.TypeError("argument must be callable");
        }
        searchPath.append(search_function);
    }

    public static PyTuple lookup(String encoding) {
        codecs.import_encodings();
        PyString v = new PyString(codecs.normalizestring(encoding));
        PyObject result = searchCache.__finditem__(v);
        if (result != null) {
            return (PyTuple)result;
        }
        if (searchPath.__len__() == 0) {
            throw new PyException(Py.LookupError, "no codec search functions registered: can't find encoding");
        }
        int i = 0;
        PyObject func = null;
        while ((func = searchPath.__finditem__(i)) != null) {
            result = func.__call__(v);
            if (result != Py.None) {
                if (result instanceof PyTuple && result.__len__() == 4) break;
                throw Py.TypeError("codec search functions must return 4-tuples");
            }
            ++i;
        }
        if (i == searchPath.__len__()) {
            throw new PyException(Py.LookupError, "unknown encoding " + encoding);
        }
        searchCache.__setitem__(v, result);
        return (PyTuple)result;
    }

    private static final String normalizestring(String string2) {
        return string2.toLowerCase().replace(' ', '-');
    }

    private static final void import_encodings() {
        block3: {
            if (!import_encodings_called) {
                import_encodings_called = true;
                try {
                    __builtin__.__import__("encodings");
                }
                catch (PyException exc) {
                    if (exc.type == Py.ImportError) break block3;
                    throw exc;
                }
            }
        }
    }

    public static PyString decode(PyString v, String encoding, String errors) {
        encoding = encoding == null ? codecs.getDefaultEncoding() : codecs.normalizestring(encoding);
        if (errors != null) {
            errors = errors.intern();
        }
        if (encoding.equals("ascii")) {
            return new PyString(codecs.PyUnicode_DecodeASCII(v.toString(), v.__len__(), errors));
        }
        PyObject decoder = codecs.getDecoder(encoding);
        PyObject result = null;
        result = errors != null ? decoder.__call__(v, new PyString(errors)) : decoder.__call__(v);
        if (!(result instanceof PyTuple) || result.__len__() != 2) {
            throw Py.TypeError("decoder must return a tuple (object,integer)");
        }
        return result.__getitem__(0).__str__();
    }

    private static final PyObject getDecoder(String encoding) {
        PyTuple codecs2 = codecs.lookup(encoding);
        return codecs2.__getitem__(1);
    }

    public static PyString encode(PyString v, String encoding, String errors) {
        encoding = encoding == null ? codecs.getDefaultEncoding() : codecs.normalizestring(encoding);
        if (errors != null) {
            errors = errors.intern();
        }
        if (encoding.equals("ascii")) {
            return new PyString(codecs.PyUnicode_EncodeASCII(v.toString(), v.__len__(), errors));
        }
        PyObject encoder = codecs.getEncoder(encoding);
        PyObject result = null;
        result = errors != null ? encoder.__call__(v, new PyString(errors)) : encoder.__call__(v);
        if (!(result instanceof PyTuple) || result.__len__() != 2) {
            throw Py.TypeError("encoder must return a tuple (object,integer)");
        }
        return result.__getitem__(0).__str__();
    }

    private static final PyObject getEncoder(String encoding) {
        PyTuple codecs2 = codecs.lookup(encoding);
        return codecs2.__getitem__(0);
    }

    public static String PyUnicode_DecodeUTF8(String str, String errors) {
        int size = str.length();
        StringBuffer unicode = new StringBuffer(size);
        int i = 0;
        block7: while (i < size) {
            int ch = str.charAt(i);
            if (ch > 255) {
                codecs.decoding_error("utf-8", unicode, errors, "ordinal not in range(255)");
                ++i;
                continue;
            }
            if (ch < 128) {
                unicode.append((char)ch);
                ++i;
                continue;
            }
            byte n = utf8_code_length[ch];
            if (i + n > size) {
                codecs.decoding_error("utf-8", unicode, errors, "unexpected end of data");
                ++i;
                continue;
            }
            switch (n) {
                case 0: {
                    codecs.decoding_error("utf-8", unicode, errors, "unexpected code byte");
                    ++i;
                    continue block7;
                }
                case 1: {
                    codecs.decoding_error("utf-8", unicode, errors, "internal error");
                    ++i;
                    continue block7;
                }
                case 2: {
                    char ch1 = str.charAt(i + 1);
                    if ((ch1 & 0xC0) != 128) {
                        codecs.decoding_error("utf-8", unicode, errors, "invalid data");
                        ++i;
                        continue block7;
                    }
                    if ((ch = ((ch & 0x1F) << 6) + (ch1 & 0x3F)) < 128) {
                        codecs.decoding_error("utf-8", unicode, errors, "illegal encoding");
                        ++i;
                        continue block7;
                    }
                    unicode.append((char)ch);
                    break;
                }
                case 3: {
                    char ch1 = str.charAt(i + 1);
                    char ch2 = str.charAt(i + 2);
                    if ((ch1 & 0xC0) != 128 || (ch2 & 0xC0) != 128) {
                        codecs.decoding_error("utf-8", unicode, errors, "invalid data");
                        ++i;
                        continue block7;
                    }
                    if ((ch = ((ch & 0xF) << 12) + ((ch1 & 0x3F) << 6) + (ch2 & 0x3F)) < 2048 || ch >= 55296 && ch < 57344) {
                        codecs.decoding_error("utf-8", unicode, errors, "illegal encoding");
                        ++i;
                        continue block7;
                    }
                    unicode.append((char)ch);
                    break;
                }
                case 4: {
                    char ch1 = str.charAt(i + 1);
                    char ch2 = str.charAt(i + 2);
                    char ch3 = str.charAt(i + 3);
                    if ((ch1 & 0xC0) != 128 || (ch2 & 0xC0) != 128 || (ch3 & 0xC0) != 128) {
                        codecs.decoding_error("utf-8", unicode, errors, "invalid data");
                        ++i;
                        continue block7;
                    }
                    if ((ch = ((ch & 7) << 18) + ((ch1 & 0x3F) << 12) + ((ch2 & 0x3F) << 6) + (ch3 & 0x3F)) < 65536 || ch > 0x10FFFF) {
                        codecs.decoding_error("utf-8", unicode, errors, "illegal encoding");
                        ++i;
                        continue block7;
                    }
                    unicode.append((char)(55296 + ((ch -= 65536) >> 10)));
                    unicode.append((char)(56320 + (ch & 0xFFFF03FF)));
                    break;
                }
                default: {
                    codecs.decoding_error("utf-8", unicode, errors, "unsupported Unicode code range");
                    ++i;
                }
            }
            i += n;
        }
        return unicode.toString();
    }

    public static String PyUnicode_EncodeUTF8(String str, String errors) {
        int size = str.length();
        StringBuffer v = new StringBuffer(size * 3);
        int i = 0;
        while (i < size) {
            int ch;
            if ((ch = str.charAt(i++)) < 128) {
                v.append((char)ch);
                continue;
            }
            if (ch < 2048) {
                v.append((char)(0xC0 | ch >> 6));
                v.append((char)(0x80 | ch & 0x3F));
                continue;
            }
            if (55296 <= ch && ch <= 57343) {
                char ch2;
                if (i != size && '\udc00' <= (ch2 = str.charAt(i)) && ch2 <= '\udfff') {
                    ch = (ch - 55296 << 10 | ch2 - 56320) + 65536;
                    v.append((char)(ch >> 18 | 0xF0));
                    v.append((char)(0x80 | ch >> 12 & 0x3F));
                    ++i;
                }
            } else {
                v.append((char)(0xE0 | ch >> 12));
            }
            v.append((char)(0x80 | ch >> 6 & 0x3F));
            v.append((char)(0x80 | ch & 0x3F));
        }
        return v.toString();
    }

    public static String PyUnicode_DecodeASCII(String str, int size, String errors) {
        StringBuffer v = new StringBuffer(size);
        int i = 0;
        while (i < size) {
            char ch = str.charAt(i);
            if (ch < '\u0080') {
                v.append(ch);
            } else {
                codecs.decoding_error("ascii", v, errors, "ordinal not in range(128)");
            }
            ++i;
        }
        return v.toString();
    }

    public static String PyUnicode_EncodeASCII(String str, int size, String errors) {
        StringBuffer v = new StringBuffer(size);
        int i = 0;
        while (i < size) {
            char ch = str.charAt(i);
            if (ch >= '\u0080') {
                codecs.encoding_error("ascii", v, errors, "ordinal not in range(128)");
            } else {
                v.append(ch);
            }
            ++i;
        }
        return v.toString();
    }

    public static String PyUnicode_EncodeRawUnicodeEscape(String str, String errors, boolean modifed) {
        int size = str.length();
        StringBuffer v = new StringBuffer(str.length());
        int i = 0;
        while (i < size) {
            char ch = str.charAt(i);
            if (ch >= '\u0100' || modifed && (ch == '\n' || ch == '\\')) {
                v.append("\\u");
                v.append(hexdigit[ch >>> 12 & 0xF]);
                v.append(hexdigit[ch >>> 8 & 0xF]);
                v.append(hexdigit[ch >>> 4 & 0xF]);
                v.append(hexdigit[ch & 0xF]);
            } else {
                v.append(ch);
            }
            ++i;
        }
        return v.toString();
    }

    public static String PyUnicode_DecodeRawUnicodeEscape(String str, String errors) {
        int size = str.length();
        StringBuffer v = new StringBuffer(size);
        int i = 0;
        while (i < size) {
            char ch = str.charAt(i);
            if (ch != '\\') {
                v.append(ch);
                ++i;
                continue;
            }
            int bs = i;
            while (i < size) {
                ch = str.charAt(i);
                if (ch != '\\') break;
                v.append(ch);
                ++i;
            }
            if ((i - bs & 1) == 0 || i >= size || ch != 'u') continue;
            v.setLength(v.length() - 1);
            ++i;
            int x = 0;
            int j = 0;
            while (j < 4) {
                ch = str.charAt(i + j);
                int d = Character.digit(ch, 16);
                if (d == -1) {
                    codecs.decoding_error("unicode escape", v, errors, "truncated \\uXXXX");
                    break;
                }
                x = (x << 4 & 0xFFFFFFF0) + d;
                ++j;
            }
            i += 4;
            v.append((char)x);
        }
        return v.toString();
    }

    public static void encoding_error(String type, StringBuffer dest, String errors, String details) {
        if (errors == null || errors == "strict") {
            throw Py.UnicodeError(type + " encoding error: " + details);
        }
        if (errors != "ignore") {
            if (errors == "replace") {
                dest.append('?');
            } else {
                throw Py.ValueError(type + " encoding error; " + "unknown error handling code: " + errors);
            }
        }
    }

    public static void decoding_error(String type, StringBuffer dest, String errors, String details) {
        if (errors == null || errors == "strict") {
            throw Py.UnicodeError(type + " decoding error: " + details);
        }
        if (errors != "ignore") {
            if (errors == "replace") {
                if (dest != null) {
                    dest.append(Py_UNICODE_REPLACEMENT_CHARACTER);
                }
            } else {
                throw Py.ValueError(type + " decoding error; " + "unknown error handling code: " + errors);
            }
        }
    }
}

