/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.util.Vector;
import org.python.core.ClassDictInit;
import org.python.core.ListFunctions;
import org.python.core.Py;
import org.python.core.PyClass;
import org.python.core.PyIgnoreMethodTag;
import org.python.core.PyInteger;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.ThreadState;

public class PyList
extends PySequence
implements ClassDictInit {
    protected static PyObject __methods__;
    private static final int MINSIZE = 10;
    private static final int STACKSIZE = 64;
    public static PyClass __class__;
    protected PyObject[] list;
    protected int length;

    public static void classDictInit(PyObject dict) {
        PySequence.classDictInit(dict);
        dict.__setitem__("reverse", (PyObject)new ListFunctions("reverse", 1, 0));
        dict.__setitem__("sort", (PyObject)new ListFunctions("sort", 2, 0, 1));
        dict.__setitem__("__len__", (PyObject)new ListFunctions("__len__", 3, 0));
        dict.__setitem__("append", (PyObject)new ListFunctions("append", 10, 1));
        dict.__setitem__("count", (PyObject)new ListFunctions("count", 11, 1));
        dict.__setitem__("index", (PyObject)new ListFunctions("index", 12, 1));
        dict.__setitem__("remove", (PyObject)new ListFunctions("remove", 13, 1));
        dict.__setitem__("extend", (PyObject)new ListFunctions("extend", 14, 1));
        dict.__setitem__("__add__", (PyObject)new ListFunctions("__add__", 15, 1));
        dict.__setitem__("insert", (PyObject)new ListFunctions("insert", 20, 2));
        dict.__setitem__("initModule", null);
        dict.__setitem__("toString", null);
        dict.__setitem__("hashCode", null);
    }

    public String safeRepr() throws PyIgnoreMethodTag {
        return "'list' object";
    }

    public int __len__() {
        return this.length;
    }

    public PyObject __findattr__(String name) {
        if (name.equals("__methods__")) {
            PyList mlist = (PyList)__methods__;
            PyObject[] methods = new PyString[mlist.length];
            int i = 0;
            while (i < mlist.length) {
                methods[i] = (PyString)mlist.list[i];
                ++i;
            }
            return new PyList(methods);
        }
        return super.__findattr__(name);
    }

    protected PyObject get(int i) {
        return this.list[i];
    }

    protected PyObject getslice(int start, int stop, int step) {
        if (step > 0 && stop < start) {
            stop = start;
        }
        int n = PySequence.sliceLength(start, stop, step);
        PyObject[] newList = new PyObject[n];
        if (step == 1) {
            System.arraycopy(this.list, start, newList, 0, stop - start);
            return new PyList(newList);
        }
        int j = 0;
        int i = start;
        while (j < n) {
            newList[j] = this.list[i];
            ++j;
            i += step;
        }
        return new PyList(newList);
    }

    protected void del(int i) {
        --this.length;
        System.arraycopy(this.list, i + 1, this.list, i, this.length - i);
        this.list[this.length] = null;
    }

    protected void delRange(int start, int stop, int step) {
        if (step != 1) {
            throw Py.ValueError("step size must be 1 for deleting list slice");
        }
        System.arraycopy(this.list, stop, this.list, start, this.length - stop);
        int newLength = this.length - (stop - start);
        int oldLength = this.length;
        int i = newLength;
        while (i < oldLength) {
            this.list[i] = null;
            ++i;
        }
        this.length = newLength;
    }

    protected void set(int i, PyObject value) {
        this.list[i] = value;
    }

    protected void setslice(int start, int stop, int step, PyObject value) {
        int i;
        PySequence seq;
        int n;
        int length;
        int newLength;
        if (!(value instanceof PySequence)) {
            throw Py.TypeError("rhs of setslice must be a sequence");
        }
        if (step != 1) {
            throw Py.ValueError("step size must be 1 for setting list slice");
        }
        if (stop < start) {
            stop = start;
        }
        if ((newLength = (length = this.length) - (stop - start) + (n = (seq = (PySequence)value).__len__())) > length || newLength < length) {
            this.resize(newLength);
            System.arraycopy(this.list, stop, this.list, stop + (newLength - length), length - stop);
            if (newLength < length) {
                i = newLength;
                while (i < length) {
                    this.list[i] = null;
                    ++i;
                }
            }
        }
        PyObject[] otherList = null;
        if (value instanceof PyTuple) {
            otherList = ((PyTuple)value).list;
        }
        if (value instanceof PyList && (otherList = ((PyList)value).list) == this.list) {
            otherList = (PyObject[])otherList.clone();
        }
        if (otherList != null) {
            System.arraycopy(otherList, 0, this.list, start, n);
        } else {
            i = 0;
            while (i < n) {
                this.list[i + start] = seq.get(i);
                ++i;
            }
        }
    }

    protected PyObject repeat(int count) {
        int l = this.length;
        PyObject[] newList = new PyObject[l * count];
        int i = 0;
        while (i < count) {
            System.arraycopy(this.list, 0, newList, i * l, l);
            ++i;
        }
        return new PyList(newList);
    }

    public PyObject __imul__(PyObject o) {
        if (!(o instanceof PyInteger) && !(o instanceof PyLong)) {
            throw Py.TypeError("can't multiply sequence to non-int");
        }
        int l = this.length;
        int count = o.__int__().getValue();
        this.resize(l * count);
        int i = 0;
        while (i < count) {
            System.arraycopy(this.list, 0, this.list, i * l, l);
            ++i;
        }
        return this;
    }

    public PyObject __add__(PyObject genericOther) {
        if (genericOther instanceof PyList) {
            PyList other = (PyList)genericOther;
            PyObject[] newList = new PyObject[this.length + other.length];
            System.arraycopy(this.list, 0, newList, 0, this.length);
            System.arraycopy(other.list, 0, newList, this.length, other.length);
            return new PyList(newList);
        }
        return null;
    }

    public String toString() {
        ThreadState ts = Py.getThreadState();
        if (!ts.enterRepr(this)) {
            return "[...]";
        }
        StringBuffer buf = new StringBuffer("[");
        int i = 0;
        while (i < this.length - 1) {
            buf.append(this.list[i].__repr__().toString());
            buf.append(", ");
            ++i;
        }
        if (this.length > 0) {
            buf.append(this.list[this.length - 1].__repr__().toString());
        }
        buf.append("]");
        ts.exitRepr(this);
        return buf.toString();
    }

    protected void resize(int n) {
        if (this.list.length < n) {
            PyObject[] newList = new PyObject[(int)((double)n * 1.5)];
            System.arraycopy(this.list, 0, newList, 0, this.length);
            this.list = newList;
        }
        this.length = n;
    }

    public void append(PyObject o) {
        this.resize(this.length + 1);
        this.list[this.length - 1] = o;
    }

    public int count(PyObject o) {
        int count = 0;
        int n = this.length;
        PyObject[] list = this.list;
        int i = 0;
        while (i < n) {
            if (list[i].equals(o)) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public int index(PyObject o) {
        return this._index(o, "list.index(x): x not in list");
    }

    private final int _index(PyObject o, String message) {
        int n = this.length;
        PyObject[] list = this.list;
        int i = 0;
        while (i < n) {
            if (list[i].equals(o)) break;
            ++i;
        }
        if (i == n) {
            throw Py.ValueError(message);
        }
        return i;
    }

    public void insert(int index, PyObject o) {
        if (index < 0) {
            index = 0;
        }
        if (index > this.length) {
            index = this.length;
        }
        this.resize(this.length + 1);
        System.arraycopy(this.list, index, this.list, index + 1, this.length - index - 1);
        this.list[index] = o;
    }

    public void remove(PyObject o) {
        this.del(this._index(o, "list.remove(x): x not in list"));
    }

    public void reverse() {
        int n = this.length;
        PyObject[] list = this.list;
        int j = n - 1;
        int i = 0;
        while (i < n / 2) {
            PyObject tmp = list[i];
            list[i] = list[j];
            list[j] = tmp;
            ++i;
            --j;
        }
    }

    public PyObject pop() {
        return this.pop(-1);
    }

    public PyObject pop(int n) {
        if (this.length == 0) {
            throw Py.IndexError("pop from empty list");
        }
        if (n < 0) {
            n += this.length;
        }
        if (n < 0 || n >= this.length) {
            throw Py.IndexError("pop index out of range");
        }
        PyObject v = this.list[n];
        this.setslice(n, n + 1, 1, Py.EmptyTuple);
        return v;
    }

    public void extend(PyObject o) {
        this.setslice(this.length, this.length, 1, o);
    }

    public PyObject __iadd__(PyObject o) {
        this.extend(PySequence.fastSequence(o, "argument to += must be a sequence"));
        return this;
    }

    private static final int docompare(PyObject x, PyObject y, PyObject compare, String cmpop) {
        PyObject ret;
        if (compare == null) {
            if (cmpop == "<") {
                return x._lt(y).__nonzero__() ? -1 : 0;
            }
            if (cmpop == "<=") {
                return x._le(y).__nonzero__() ? -1 : 1;
            }
        }
        if ((ret = compare.__call__(new PyObject[]{x, y})) instanceof PyInteger) {
            int v = ((PyInteger)ret).getValue();
            return v < 0 ? -1 : (v > 0 ? 1 : 0);
        }
        throw Py.TypeError("comparision function must return int");
    }

    private static final void insertionsort(PyObject[] array, int off, int size, PyObject compare) {
        int end = off + size;
        int i = off + 1;
        while (i < end) {
            PyObject key = array[i];
            int j = i;
            while (--j >= off) {
                PyObject q = array[j];
                if (PyList.docompare(q, key, compare, "<=") <= 0) break;
                array[j + 1] = q;
                array[j] = key;
            }
            ++i;
        }
    }

    private static final void quicksort(PyObject[] array, int off, int size, PyObject compare) {
        int[] lostack = new int[64];
        int[] histack = new int[64];
        lostack[0] = off;
        histack[0] = off + size;
        int top = 1;
        while (--top >= 0) {
            int hi = histack[top];
            int lo = lostack[top];
            int n = hi - lo;
            if (n < 10) continue;
            int l = lo + (n >> 1);
            int r = hi - 1;
            PyObject left = array[l];
            PyObject right = array[lo];
            if (PyList.docompare(left, right, compare, "<") < 0) {
                array[lo] = left;
                array[l] = right;
            }
            if (PyList.docompare(left = array[r], right = array[l], compare, "<") < 0) {
                array[r] = left;
                array[l] = right;
            }
            if (PyList.docompare(left = array[l], right = array[lo], compare, "<") < 0) {
                array[lo] = left;
                array[l] = right;
            }
            PyObject pivot = array[l];
            l = lo + 1;
            r = hi - 2;
            while (true) {
                if (l < hi) {
                    if (PyList.docompare(array[l], pivot, compare, "<") < 0) {
                        ++l;
                        continue;
                    }
                }
                while (r >= lo) {
                    if (PyList.docompare(pivot, array[r], compare, "<") >= 0) break;
                    --r;
                }
                if (l < r) {
                    PyObject tmp = array[l];
                    array[l] = array[r];
                    array[r] = tmp;
                    ++l;
                    --r;
                } else if (l == r) {
                    ++l;
                    --r;
                    break;
                }
                if (l > r) break;
            }
            n = r - lo;
            int n2 = hi - l;
            if (n > n2) {
                if (n <= 10) continue;
                lostack[top] = lo;
                histack[top++] = r;
                if (n2 <= 10) continue;
                lostack[top] = l;
                histack[top++] = hi;
                continue;
            }
            if (n2 <= 10) continue;
            lostack[top] = l;
            histack[top++] = hi;
            if (n <= 10) continue;
            lostack[top] = lo;
            histack[top++] = r;
        }
        PyList.insertionsort(array, off, size, compare);
    }

    public synchronized void sort(PyObject compare) {
        PyList.quicksort(this.list, 0, this.length, compare);
    }

    public void sort() {
        this.sort(null);
    }

    protected PyClass getPyClass() {
        return __class__;
    }

    public int hashCode() {
        throw Py.TypeError("unhashable type");
    }

    public PyList() {
        this(Py.EmptyObjects);
    }

    public PyList(Vector ilist) {
        this(new PyObject[ilist.size()]);
        int i = 0;
        while (i < ilist.size()) {
            this.list[i] = (PyObject)ilist.elementAt(i);
            ++i;
        }
    }

    public PyList(PyObject[] elements) {
        this.list = elements;
        this.length = elements.length;
    }

    static {
        PyList list = new PyList();
        String[] methods = new String[]{"append", "count", "extend", "index", "insert", "pop", "remove", "reverse", "sort"};
        int i = 0;
        while (i < methods.length) {
            list.append(new PyString(methods[i]));
            ++i;
        }
        __methods__ = list;
    }
}

