/*
 * Decompiled with CFR 0.152.
 */
package org.python.compiler;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.python.compiler.ClassConstants;
import org.python.compiler.Code;
import org.python.compiler.CompilationContext;
import org.python.compiler.ConstantPool;
import org.python.compiler.Future;
import org.python.compiler.Label;
import org.python.compiler.Module;
import org.python.compiler.ScopeInfo;
import org.python.compiler.ScopesCompiler;
import org.python.compiler.SymInfo;
import org.python.core.CompilerFlags;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.parser.ParseException;
import org.python.parser.PythonGrammarTreeConstants;
import org.python.parser.SimpleNode;
import org.python.parser.Visitor;

public class CodeCompiler
extends Visitor
implements CompilationContext,
ClassConstants,
PythonGrammarTreeConstants {
    public static final Object Exit = new Integer(1);
    public static final Object NoExit = null;
    public static final int GET = 0;
    public static final int SET = 1;
    public static final int DEL = 2;
    public static final int AUGGET = 3;
    public static final int AUGSET = 4;
    public static final Object DoFinally = new Integer(2);
    public Module module;
    public Code code;
    public ConstantPool pool;
    public CodeCompiler mrefs;
    int mode;
    int temporary;
    public boolean fast_locals;
    public boolean print_results;
    public Future futures;
    public Hashtable tbl;
    public ScopeInfo my_scope;
    boolean optimizeGlobals = true;
    public Vector names;
    public String className;
    public Stack continueLabels;
    public Stack breakLabels;
    public Stack finallyLabels;
    public Stack listComprehensionExprs;
    public Stack listComprehensionAppends;
    public int PyNone;
    public int setline;
    public int EmptyObjects;
    int getclosure;
    int f_globals;
    int PyFunction_init;
    int PyFunction_closure_init;
    public int printResult;
    public int print1;
    public int print2;
    public int print3;
    public int print4;
    public int print5;
    public int print6;
    public int makeException0;
    public int makeException1;
    public int makeException2;
    public int makeException3;
    public int importOne;
    public int importOneAs;
    public int importAll;
    public int importFrom;
    public int exec;
    public int assert1;
    public int assert2;
    public int nonzero;
    public int safe_getitem = 0;
    public int match_exception;
    public int add_traceback;
    public int set_exception;
    public Integer less;
    public Integer greater;
    public Integer equal;
    public Integer less_equal;
    public Integer greater_equal;
    public Integer notequal;
    public Integer in;
    public Integer not_in;
    public Integer is;
    public Integer is_not;
    public int invokea0;
    public int invokea1;
    public int invokea2;
    public int invoke2;
    public int callextra;
    public int call1;
    public int call2;
    public int calla0;
    public int calla1;
    public int calla2;
    public int calla3;
    public int calla4;
    public int getslice;
    public int setslice;
    public int delslice;
    public int getitem;
    public int delitem;
    public int setitem;
    public int getattr;
    public int delattr;
    public int setattr;
    public int getitem2;
    public int unpackSequence;
    public int PyTuple_init;
    public int PyList_init;
    public int PyDictionary_init;
    public int PyList_init2;
    public int PyFunction_init1;
    public int PyFunction_closure_init1;
    public int Ellipsis;
    public int PySlice_init;
    public int makeClass;
    public int makeClass_closure;
    int getglobal;
    int getlocal1;
    int getlocal2;
    int setglobal;
    int setlocal1;
    int setlocal2;
    int delglobal;
    int dellocal1;
    int dellocal2;
    int getderef;
    int setderef;

    public Future getFutures() {
        return this.futures;
    }

    public String getFilename() {
        return this.module.sfilename;
    }

    public void getNone() throws IOException {
        if (this.mrefs.PyNone == 0) {
            this.mrefs.PyNone = this.pool.Fieldref("org/python/core/Py", "None", "Lorg/python/core/PyObject;");
        }
        this.code.getstatic(this.mrefs.PyNone);
    }

    public void loadFrame() throws Exception {
        this.code.aload(1);
    }

    public int storeTop() throws Exception {
        int tmp = this.code.getLocal();
        this.code.astore(tmp);
        return tmp;
    }

    public void setline(int line) throws Exception {
        if (this.module.linenumbers) {
            this.code.setline(line);
            this.loadFrame();
            this.code.iconst(line);
            if (this.mrefs.setline == 0) {
                this.mrefs.setline = this.pool.Methodref("org/python/core/PyFrame", "setline", "(I)V");
            }
            this.code.invokevirtual(this.mrefs.setline);
        }
    }

    public void setline(SimpleNode node) throws Exception {
        this.setline(node.beginLine);
    }

    public void set(SimpleNode node) throws Exception {
        int tmp = this.storeTop();
        this.set(node, tmp);
        this.code.aconst_null();
        this.code.astore(tmp);
        this.code.freeLocal(tmp);
    }

    public void set(SimpleNode node, int tmp) throws Exception {
        if (this.mode == 1) {
            int old_tmp = this.temporary;
            this.temporary = tmp;
            node.visit(this);
            this.temporary = old_tmp;
        } else {
            this.temporary = tmp;
            this.mode = 1;
            node.visit(this);
            this.mode = 0;
        }
    }

    private final void saveAugTmps(SimpleNode node, int count) throws Exception {
        if (count >= 4) {
            node.aug_tmp4 = this.code.getLocal();
            this.code.astore(node.aug_tmp4);
        }
        if (count >= 3) {
            node.aug_tmp3 = this.code.getLocal();
            this.code.astore(node.aug_tmp3);
        }
        if (count >= 2) {
            node.aug_tmp2 = this.code.getLocal();
            this.code.astore(node.aug_tmp2);
        }
        node.aug_tmp1 = this.code.getLocal();
        this.code.astore(node.aug_tmp1);
        this.code.aload(node.aug_tmp1);
        if (count >= 2) {
            this.code.aload(node.aug_tmp2);
        }
        if (count >= 3) {
            this.code.aload(node.aug_tmp3);
        }
        if (count >= 4) {
            this.code.aload(node.aug_tmp4);
        }
    }

    private final void restoreAugTmps(SimpleNode node, int count) throws Exception {
        this.code.aload(node.aug_tmp1);
        this.code.freeLocal(node.aug_tmp1);
        if (count == 1) {
            return;
        }
        this.code.aload(node.aug_tmp2);
        this.code.freeLocal(node.aug_tmp2);
        if (count == 2) {
            return;
        }
        this.code.aload(node.aug_tmp3);
        this.code.freeLocal(node.aug_tmp3);
        if (count == 3) {
            return;
        }
        this.code.aload(node.aug_tmp4);
        this.code.freeLocal(node.aug_tmp4);
        if (count == 4) {
            return;
        }
    }

    public void error(String msg, boolean err, SimpleNode node) throws Exception {
        block3: {
            if (!err) {
                try {
                    Py.warning(Py.SyntaxWarning, msg, this.module.sfilename != null ? this.module.sfilename : "?", node.beginLine, null, Py.None);
                    return;
                }
                catch (PyException e) {
                    if (Py.matchException(e, Py.SyntaxWarning)) break block3;
                    throw e;
                }
            }
        }
        throw new ParseException(msg, node);
    }

    public void parse(SimpleNode node, Code code, boolean fast_locals, String className, boolean classBody, ScopeInfo scope, CompilerFlags cflags) throws Exception {
        this.fast_locals = fast_locals;
        this.className = className;
        this.code = code;
        if (scope == null) {
            this.futures = new Future();
            this.futures.preprocessFutures(node, cflags);
            new ScopesCompiler(this).parse(node);
            scope = node.scope;
        }
        this.my_scope = scope;
        this.names = scope.names;
        this.tbl = scope.tbl;
        this.optimizeGlobals = fast_locals && !scope.exec && !scope.from_import_star;
        this.mode = 0;
        Object exit = node.visit(this);
        if (classBody) {
            this.loadFrame();
            code.invokevirtual("org/python/core/PyFrame", "getf_locals", "()Lorg/python/core/PyObject;");
            code.areturn();
        } else if (exit == null) {
            this.getNone();
            code.areturn();
        }
    }

    public Object single_input(SimpleNode node) throws Exception {
        return this.suite(node);
    }

    public Object file_input(SimpleNode suite) throws Exception {
        if (this.mrefs.setglobal == 0) {
            this.mrefs.setglobal = this.code.pool.Methodref("org/python/core/PyFrame", "setglobal", "(Ljava/lang/String;Lorg/python/core/PyObject;)V");
        }
        if (suite.getNumChildren() > 0 && suite.getChild((int)0).id == 10 && suite.getChild((int)0).getChild((int)0).id == 95) {
            this.loadFrame();
            this.code.ldc("__doc__");
            suite.getChild(0).getChild(0).visit(this);
            this.code.invokevirtual(this.mrefs.setglobal);
        }
        if (this.module.setFile) {
            this.loadFrame();
            this.code.ldc("__file__");
            this.module.filename.get(this.code);
            this.code.invokevirtual(this.mrefs.setglobal);
        }
        return this.suite(suite);
    }

    public Object eval_input(SimpleNode node) throws Exception {
        return this.return_stmt(node, true);
    }

    public void makeArray(SimpleNode[] nodes) throws Exception {
        int n;
        if (nodes == null) {
            boolean bl = false;
        } else {
            n = nodes.length;
        }
        if (n > 0 && nodes[n - 1].id == 84) {
            --n;
        }
        if (n == 0) {
            if (this.mrefs.EmptyObjects == 0) {
                this.mrefs.EmptyObjects = this.code.pool.Fieldref("org/python/core/Py", "EmptyObjects", "[Lorg/python/core/PyObject;");
            }
            this.code.getstatic(this.mrefs.EmptyObjects);
        } else {
            int tmp = this.code.getLocal();
            this.code.iconst(n);
            this.code.anewarray(this.code.pool.Class("org/python/core/PyObject"));
            this.code.astore(tmp);
            int i = 0;
            while (i < n) {
                this.code.aload(tmp);
                this.code.iconst(i);
                nodes[i].visit(this);
                this.code.aastore();
                ++i;
            }
            this.code.aload(tmp);
            this.code.freeLocal(tmp);
        }
    }

    public void getDocString(SimpleNode suite) throws Exception {
        if (suite.getNumChildren() > 0 && suite.getChild((int)0).id == 10 && suite.getChild((int)0).getChild((int)0).id == 95) {
            suite.getChild(0).getChild(0).visit(this);
        } else {
            this.code.aconst_null();
        }
    }

    public boolean makeClosure(Vector freenames) throws Exception {
        if (freenames == null) {
            return false;
        }
        int n = freenames.size();
        if (n == 0) {
            return false;
        }
        if (this.mrefs.getclosure == 0) {
            this.mrefs.getclosure = this.code.pool.Methodref("org/python/core/PyFrame", "getclosure", "(I)Lorg/python/core/PyObject;");
        }
        int tmp = this.code.getLocal();
        this.code.iconst(n);
        this.code.anewarray(this.code.pool.Class("org/python/core/PyObject"));
        this.code.astore(tmp);
        int i = 0;
        while (i < n) {
            this.code.aload(tmp);
            this.code.iconst(i);
            this.code.aload(1);
            this.code.iconst(((SymInfo)this.tbl.get(freenames.elementAt((int)i))).env_index);
            this.code.invokevirtual(this.getclosure);
            this.code.aastore();
            ++i;
        }
        this.code.aload(tmp);
        this.code.freeLocal(tmp);
        return true;
    }

    public Object funcdef(SimpleNode node) throws Exception {
        SimpleNode suite;
        String name = this.getName(node.getChild(0));
        if (node.getNumChildren() == 3) {
            SimpleNode simpleNode = node.getChild(2);
        } else {
            suite = node.getChild(1);
        }
        this.setline(node);
        this.code.new_(this.code.pool.Class("org/python/core/PyFunction"));
        this.code.dup();
        this.loadFrame();
        if (this.mrefs.f_globals == 0) {
            this.mrefs.f_globals = this.code.pool.Fieldref("org/python/core/PyFrame", "f_globals", "Lorg/python/core/PyObject;");
        }
        this.code.getfield(this.mrefs.f_globals);
        this.makeArray(node.scope.ac.getDefaults());
        node.scope.setup_closure(this.my_scope);
        node.scope.dump();
        this.module.PyCode(suite, name, true, this.className, false, false, node.beginLine, node.scope).get(this.code);
        Vector freenames = node.scope.freevars;
        node.scope = null;
        this.getDocString(suite);
        if (!this.makeClosure(freenames)) {
            if (this.mrefs.PyFunction_init == 0) {
                this.mrefs.PyFunction_init = this.code.pool.Methodref("org/python/core/PyFunction", "<init>", "(Lorg/python/core/PyObject;[Lorg/python/core/PyObject;Lorg/python/core/PyCode;Lorg/python/core/PyObject;)V");
            }
            this.code.invokespecial(this.mrefs.PyFunction_init);
        } else {
            if (this.mrefs.PyFunction_closure_init == 0) {
                this.mrefs.PyFunction_closure_init = this.code.pool.Methodref("org/python/core/PyFunction", "<init>", "(Lorg/python/core/PyObject;[Lorg/python/core/PyObject;Lorg/python/core/PyCode;Lorg/python/core/PyObject;[Lorg/python/core/PyObject;)V");
            }
            this.code.invokespecial(this.mrefs.PyFunction_closure_init);
        }
        this.set(node.getChild(0));
        return null;
    }

    public Object expr_stmt(SimpleNode node) throws Exception {
        this.setline(node);
        int n = node.getNumChildren();
        if (n == 1 && node.getChild((int)0).id >= 11 && node.getChild((int)0).id <= 21) {
            node.getChild(0).visit(this);
            return null;
        }
        node.getChild(n - 1).visit(this);
        if (n == 1) {
            if (this.print_results) {
                if (this.mrefs.printResult == 0) {
                    this.mrefs.printResult = this.code.pool.Methodref("org/python/core/Py", "printResult", "(Lorg/python/core/PyObject;)V");
                }
                this.code.invokestatic(this.mrefs.printResult);
            } else {
                this.code.pop();
            }
            return null;
        }
        if (n == 2) {
            this.set(node.getChild(0));
            return null;
        }
        int tmp = this.storeTop();
        int i = n - 2;
        while (i >= 0) {
            this.set(node.getChild(i), tmp);
            --i;
        }
        this.code.freeLocal(tmp);
        return null;
    }

    public Object print_ext(SimpleNode node) throws Exception {
        node.getChild(0).visit(this);
        return null;
    }

    public Object print_stmt(SimpleNode node) throws Exception {
        int printlnv;
        int println;
        int printcomma;
        this.setline(node);
        int n = node.getNumChildren();
        int tmp = -1;
        int i = 0;
        int nochildren = 0;
        boolean printext = false;
        if (node.getNumChildren() > 0 && node.getChild((int)0).id == 23) {
            printext = true;
            node.getChild(0).visit(this);
            tmp = this.storeTop();
            i = 1;
            nochildren = 1;
            if (this.mrefs.print4 == 0) {
                this.mrefs.print4 = this.pool.Methodref("org/python/core/Py", "printComma", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;)V");
            }
            printcomma = this.mrefs.print4;
            if (this.mrefs.print5 == 0) {
                this.mrefs.print5 = this.pool.Methodref("org/python/core/Py", "println", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;)V");
            }
            println = this.mrefs.print5;
            if (this.mrefs.print6 == 0) {
                this.mrefs.print6 = this.pool.Methodref("org/python/core/Py", "printlnv", "(Lorg/python/core/PyObject;)V");
            }
            int n2 = this.mrefs.print6;
        } else {
            if (this.mrefs.print1 == 0) {
                this.mrefs.print1 = this.pool.Methodref("org/python/core/Py", "printComma", "(Lorg/python/core/PyObject;)V");
            }
            printcomma = this.mrefs.print1;
            if (this.mrefs.print2 == 0) {
                this.mrefs.print2 = this.pool.Methodref("org/python/core/Py", "println", "(Lorg/python/core/PyObject;)V");
            }
            println = this.mrefs.print2;
            if (this.mrefs.print3 == 0) {
                this.mrefs.print3 = this.pool.Methodref("org/python/core/Py", "println", "()V");
            }
            printlnv = this.mrefs.print3;
        }
        while (i < n - 1) {
            if (printext) {
                this.code.aload(tmp);
            }
            node.getChild(i).visit(this);
            this.code.invokestatic(printcomma);
            ++i;
        }
        if (node.getNumChildren() == nochildren) {
            if (printext) {
                this.code.aload(tmp);
            }
            this.code.invokestatic(printlnv);
        } else if (node.getChild((int)(n - 1)).id != 84) {
            if (printext) {
                this.code.aload(tmp);
            }
            node.getChild(n - 1).visit(this);
            this.code.invokestatic(println);
        }
        if (printext) {
            this.code.freeLocal(tmp);
        }
        return null;
    }

    public Object del_stmt(SimpleNode node) throws Exception {
        this.setline(node);
        this.mode = 2;
        node.getChild(0).visit(this);
        this.mode = 0;
        return null;
    }

    public Object pass_stmt(SimpleNode node) throws Exception {
        this.setline(node);
        return null;
    }

    public Object break_stmt(SimpleNode node) throws Exception {
        if (this.breakLabels.empty()) {
            throw new ParseException("'break' outside loop", node);
        }
        Object obj = this.breakLabels.peek();
        if (obj == DoFinally) {
            this.code.jsr((Label)this.finallyLabels.peek());
            Object tmp = obj;
            this.breakLabels.pop();
            obj = this.breakLabels.peek();
            this.breakLabels.push(tmp);
        }
        this.code.goto_((Label)obj);
        return null;
    }

    public Object continue_stmt(SimpleNode node) throws Exception {
        if (this.continueLabels.empty()) {
            throw new ParseException("'continue' not properly in loop", node);
        }
        Object obj = this.continueLabels.peek();
        if (obj == DoFinally) {
            this.code.jsr((Label)this.finallyLabels.peek());
            Object tmp = obj;
            this.continueLabels.pop();
            obj = this.continueLabels.peek();
            this.continueLabels.push(tmp);
        }
        this.code.goto_((Label)obj);
        return null;
    }

    public Object return_stmt(SimpleNode node) throws Exception {
        return this.return_stmt(node, false);
    }

    public Object return_stmt(SimpleNode node, boolean inEval) throws Exception {
        this.setline(node);
        if (!inEval && !this.fast_locals) {
            throw new ParseException("'return' outside function", node);
        }
        if (node.getNumChildren() == 1) {
            node.getChild(0).visit(this);
        } else {
            this.getNone();
        }
        int tmp = this.code.getLocal();
        this.code.astore(tmp);
        if (!this.finallyLabels.empty()) {
            this.code.jsr((Label)this.finallyLabels.peek());
        }
        this.code.aload(tmp);
        this.code.areturn();
        return Exit;
    }

    public Object raise_stmt(SimpleNode node) throws Exception {
        this.setline(node);
        int n = node.getNumChildren();
        int i = 0;
        while (i < n) {
            node.getChild(i).visit(this);
            ++i;
        }
        switch (n) {
            case 0: {
                if (this.mrefs.makeException0 == 0) {
                    this.mrefs.makeException0 = this.code.pool.Methodref("org/python/core/Py", "makeException", "()Lorg/python/core/PyException;");
                }
                this.code.invokestatic(this.mrefs.makeException0);
                break;
            }
            case 1: {
                if (this.mrefs.makeException1 == 0) {
                    this.mrefs.makeException1 = this.code.pool.Methodref("org/python/core/Py", "makeException", "(Lorg/python/core/PyObject;)Lorg/python/core/PyException;");
                }
                this.code.invokestatic(this.mrefs.makeException1);
                break;
            }
            case 2: {
                if (this.mrefs.makeException2 == 0) {
                    this.mrefs.makeException2 = this.code.pool.Methodref("org/python/core/Py", "makeException", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;)Lorg/python/core/PyException;");
                }
                this.code.invokestatic(this.mrefs.makeException2);
                break;
            }
            case 3: {
                if (this.mrefs.makeException3 == 0) {
                    this.mrefs.makeException3 = this.code.pool.Methodref("org/python/core/Py", "makeException", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;Lorg/python/core/PyObject;)Lorg/python/core/PyException;");
                }
                this.code.invokestatic(this.mrefs.makeException3);
                break;
            }
        }
        this.code.athrow();
        return Exit;
    }

    public Object Import(SimpleNode node) throws Exception {
        this.setline(node);
        int n = node.getNumChildren();
        int i = 0;
        while (i < n) {
            SimpleNode asnameNode;
            String name;
            SimpleNode cnode = node.getChild(i);
            if (cnode.id == 32) {
                name = (String)cnode.getChild(0).visit(this);
                asnameNode = cnode.getChild(1);
                this.code.ldc(name);
                this.loadFrame();
                if (this.mrefs.importOneAs == 0) {
                    this.mrefs.importOneAs = this.code.pool.Methodref("org/python/core/imp", "importOneAs", "(Ljava/lang/String;Lorg/python/core/PyFrame;)Lorg/python/core/PyObject;");
                }
                this.code.invokestatic(this.mrefs.importOneAs);
            } else {
                name = (String)cnode.visit(this);
                asnameNode = cnode.getChild(0);
                this.code.ldc(name);
                this.loadFrame();
                if (this.mrefs.importOne == 0) {
                    this.mrefs.importOne = this.code.pool.Methodref("org/python/core/imp", "importOne", "(Ljava/lang/String;Lorg/python/core/PyFrame;)Lorg/python/core/PyObject;");
                }
                this.code.invokestatic(this.mrefs.importOne);
            }
            this.set(asnameNode);
            ++i;
        }
        return null;
    }

    public Object ImportFrom(SimpleNode node) throws Exception {
        Future.checkFromFuture(node);
        this.setline(node);
        String name = (String)node.getChild(0).visit(this);
        this.code.ldc(name);
        int n = node.getNumChildren();
        if (n > 1) {
            String[] names = new String[n - 1];
            SimpleNode[] asnameNodes = new SimpleNode[n - 1];
            int i = 0;
            while (i < n - 1) {
                SimpleNode cnode = node.getChild(i + 1);
                if (cnode.id == 34) {
                    names[i] = (String)cnode.getChild(0).getInfo();
                    asnameNodes[i] = cnode.getChild(1);
                } else {
                    names[i] = (String)cnode.getInfo();
                    asnameNodes[i] = cnode;
                }
                ++i;
            }
            CodeCompiler.makeStrings(this.code, names, names.length);
            this.loadFrame();
            if (this.mrefs.importFrom == 0) {
                this.mrefs.importFrom = this.code.pool.Methodref("org/python/core/imp", "importFrom", "(Ljava/lang/String;[Ljava/lang/String;Lorg/python/core/PyFrame;)[Lorg/python/core/PyObject;");
            }
            this.code.invokestatic(this.mrefs.importFrom);
            int tmp = this.storeTop();
            int i2 = 0;
            while (i2 < n - 1) {
                this.code.aload(tmp);
                this.code.iconst(i2);
                this.code.aaload();
                this.set(asnameNodes[i2]);
                ++i2;
            }
            this.code.freeLocal(tmp);
        } else {
            this.loadFrame();
            if (this.mrefs.importAll == 0) {
                this.mrefs.importAll = this.code.pool.Methodref("org/python/core/imp", "importAll", "(Ljava/lang/String;Lorg/python/core/PyFrame;)V");
            }
            this.code.invokestatic(this.mrefs.importAll);
        }
        return null;
    }

    public Object dotted_name(SimpleNode node) throws Exception {
        int n = node.getNumChildren();
        String name = (String)node.getChild(0).getInfo();
        int i = 1;
        while (i < n) {
            name = name + "." + (String)node.getChild(i).getInfo();
            ++i;
        }
        return name;
    }

    public Object global_stmt(SimpleNode node) throws Exception {
        return null;
    }

    public Object exec_stmt(SimpleNode node) throws Exception {
        this.setline(node);
        node.getChild(0).visit(this);
        if (node.getNumChildren() > 1) {
            node.getChild(1).visit(this);
        } else {
            this.code.aconst_null();
        }
        if (node.getNumChildren() > 2) {
            node.getChild(2).visit(this);
        } else {
            this.code.aconst_null();
        }
        if (this.mrefs.exec == 0) {
            this.mrefs.exec = this.code.pool.Methodref("org/python/core/Py", "exec", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;Lorg/python/core/PyObject;)V");
        }
        this.code.invokestatic(this.mrefs.exec);
        return null;
    }

    public Object assert_stmt(SimpleNode node) throws Exception {
        this.setline(node);
        Label end_of_assert = this.code.getLabel();
        this.loadFrame();
        this.emitGetGlobal("__debug__");
        if (this.mrefs.nonzero == 0) {
            this.mrefs.nonzero = this.code.pool.Methodref("org/python/core/PyObject", "__nonzero__", "()Z");
        }
        this.code.invokevirtual(this.mrefs.nonzero);
        this.code.ifeq(end_of_assert);
        node.getChild(0).visit(this);
        if (node.getNumChildren() == 2) {
            node.getChild(1).visit(this);
            if (this.mrefs.assert2 == 0) {
                this.mrefs.assert2 = this.code.pool.Methodref("org/python/core/Py", "assert", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;)V");
            }
            this.code.invokestatic(this.mrefs.assert2);
        } else {
            if (this.mrefs.assert1 == 0) {
                this.mrefs.assert1 = this.code.pool.Methodref("org/python/core/Py", "assert", "(Lorg/python/core/PyObject;)V");
            }
            this.code.invokestatic(this.mrefs.assert1);
        }
        end_of_assert.setPosition();
        return null;
    }

    public Object doTest(Label end_of_if, SimpleNode node, int index) throws Exception {
        SimpleNode test = node.getChild(index);
        SimpleNode suite = node.getChild(index + 1);
        Label end_of_suite = this.code.getLabel();
        this.setline(test);
        test.visit(this);
        if (this.mrefs.nonzero == 0) {
            this.mrefs.nonzero = this.code.pool.Methodref("org/python/core/PyObject", "__nonzero__", "()Z");
        }
        this.code.invokevirtual(this.mrefs.nonzero);
        this.code.ifeq(end_of_suite);
        Object exit = suite.visit(this);
        if (end_of_if != null && exit == null) {
            this.code.goto_(end_of_if);
        }
        end_of_suite.setPosition();
        int remaining = node.getNumChildren() - index - 2;
        if (remaining > 1) {
            return this.doTest(end_of_if, node, index + 2) != null ? exit : null;
        }
        if (remaining == 1) {
            return node.getChild(index + 2).visit(this) != null ? exit : null;
        }
        return null;
    }

    public Object if_stmt(SimpleNode node) throws Exception {
        int n = node.getNumChildren();
        Label end_of_if = null;
        if (n > 2) {
            end_of_if = this.code.getLabel();
        }
        Object exit = this.doTest(end_of_if, node, 0);
        if (end_of_if != null) {
            end_of_if.setPosition();
        }
        return exit;
    }

    public void beginLoop() {
        this.continueLabels.push(this.code.getLabel());
        this.breakLabels.push(this.code.getLabel());
    }

    public void finishLoop() {
        this.continueLabels.pop();
        this.breakLabels.pop();
    }

    public Object while_stmt(SimpleNode node) throws Exception {
        this.beginLoop();
        Label continue_loop = (Label)this.continueLabels.peek();
        Label break_loop = (Label)this.breakLabels.peek();
        Label start_loop = this.code.getLabel();
        this.code.goto_(continue_loop);
        start_loop.setPosition();
        node.getChild(1).visit(this);
        continue_loop.setPosition();
        this.setline(node);
        node.getChild(0).visit(this);
        if (this.mrefs.nonzero == 0) {
            this.mrefs.nonzero = this.code.pool.Methodref("org/python/core/PyObject", "__nonzero__", "()Z");
        }
        this.code.invokevirtual(this.mrefs.nonzero);
        this.code.ifne(start_loop);
        this.finishLoop();
        if (node.getNumChildren() == 3) {
            node.getChild(2).visit(this);
        }
        break_loop.setPosition();
        return null;
    }

    public Object for_stmt(SimpleNode node) throws Exception {
        this.beginLoop();
        Label continue_loop = (Label)this.continueLabels.peek();
        Label break_loop = (Label)this.breakLabels.peek();
        Label start_loop = this.code.getLabel();
        Label next_loop = this.code.getLabel();
        int list_tmp = this.code.getLocal();
        int index_tmp = this.code.getLocal();
        int expr_tmp = this.code.getLocal();
        this.setline(node);
        node.getChild(1).visit(this);
        this.code.astore(list_tmp);
        this.code.iconst(0);
        this.code.istore(index_tmp);
        this.code.goto_(next_loop);
        start_loop.setPosition();
        this.set(node.getChild(0), expr_tmp);
        node.getChild(2).visit(this);
        continue_loop.setPosition();
        this.code.iinc(index_tmp, 1);
        next_loop.setPosition();
        this.setline(node);
        this.code.aload(list_tmp);
        this.code.iload(index_tmp);
        if (this.mrefs.safe_getitem == 0) {
            this.mrefs.safe_getitem = this.code.pool.Methodref("org/python/core/PyObject", "__finditem__", "(I)Lorg/python/core/PyObject;");
        }
        this.code.invokevirtual(this.mrefs.safe_getitem);
        this.code.astore(expr_tmp);
        this.code.aload(expr_tmp);
        this.code.ifnonnull(start_loop);
        this.finishLoop();
        if (node.getNumChildren() > 3) {
            node.getChild(3).visit(this);
        }
        break_loop.setPosition();
        this.code.freeLocal(list_tmp);
        this.code.freeLocal(index_tmp);
        this.code.freeLocal(expr_tmp);
        return null;
    }

    public void exceptionTest(int exc, Label end_of_exceptions, SimpleNode node, int index) throws Exception {
        SimpleNode name = node.getChild(index);
        SimpleNode suite = node.getChild(index + 1);
        Label end_of_self = this.code.getLabel();
        if (name.getNumChildren() > 0) {
            this.code.aload(exc);
            name.getChild(0).visit(this);
            if (this.mrefs.match_exception == 0) {
                this.mrefs.match_exception = this.code.pool.Methodref("org/python/core/Py", "matchException", "(Lorg/python/core/PyException;Lorg/python/core/PyObject;)Z");
            }
            this.code.invokestatic(this.mrefs.match_exception);
            this.code.ifeq(end_of_self);
        } else if (node.getNumChildren() > index + 3) {
            throw new ParseException("bare except must be last except clause", name);
        }
        if (name.getNumChildren() > 1) {
            this.code.aload(exc);
            this.code.getfield(this.code.pool.Fieldref("org/python/core/PyException", "value", "Lorg/python/core/PyObject;"));
            this.set(name.getChild(1));
        }
        suite.visit(this);
        this.code.goto_(end_of_exceptions);
        end_of_self.setPosition();
        if (node.getNumChildren() > index + 3) {
            this.exceptionTest(exc, end_of_exceptions, node, index + 2);
        } else {
            this.code.aload(exc);
            this.code.athrow();
        }
    }

    public Object tryFinally(SimpleNode trySuite, SimpleNode finallySuite) throws Exception {
        Label start = this.code.getLabel();
        Label end = this.code.getLabel();
        Label handlerStart = this.code.getLabel();
        Label finallyStart = this.code.getLabel();
        Label finallyEnd = this.code.getLabel();
        Label skipSuite = this.code.getLabel();
        this.continueLabels.push(DoFinally);
        this.breakLabels.push(DoFinally);
        this.finallyLabels.push(finallyStart);
        start.setPosition();
        Object ret = trySuite.visit(this);
        end.setPosition();
        if (ret == null) {
            this.code.jsr(finallyStart);
            this.code.goto_(finallyEnd);
        }
        this.continueLabels.pop();
        this.breakLabels.pop();
        this.finallyLabels.pop();
        handlerStart.setPosition();
        this.code.stack = 1;
        int excLocal = this.code.getLocal();
        this.code.astore(excLocal);
        this.code.aload(excLocal);
        this.loadFrame();
        if (this.mrefs.add_traceback == 0) {
            this.mrefs.add_traceback = this.code.pool.Methodref("org/python/core/Py", "addTraceback", "(Ljava/lang/Throwable;Lorg/python/core/PyFrame;)V");
        }
        this.code.invokestatic(this.mrefs.add_traceback);
        this.code.jsr(finallyStart);
        this.code.aload(excLocal);
        this.code.athrow();
        finallyStart.setPosition();
        this.code.stack = 1;
        int retLocal = this.code.getLocal();
        this.code.astore(retLocal);
        this.code.iconst(1);
        this.code.ifeq(skipSuite);
        ret = finallySuite.visit(this);
        skipSuite.setPosition();
        this.code.ret(retLocal);
        finallyEnd.setPosition();
        this.code.freeLocal(retLocal);
        this.code.freeLocal(excLocal);
        this.code.addExceptionHandler(start, end, handlerStart, this.code.pool.Class("java/lang/Throwable"));
        return null;
    }

    public Object try_stmt(SimpleNode node) throws Exception {
        int n = node.getNumChildren();
        if (n == 2) {
            return this.tryFinally(node.getChild(0), node.getChild(1));
        }
        Label start = this.code.getLabel();
        Label end = this.code.getLabel();
        Label handler_start = this.code.getLabel();
        Label handler_end = this.code.getLabel();
        start.setPosition();
        Object exit = node.getChild(0).visit(this);
        end.setPosition();
        if (exit == null) {
            this.code.goto_(handler_end);
        }
        handler_start.setPosition();
        this.code.stack = 1;
        this.loadFrame();
        if (this.mrefs.set_exception == 0) {
            this.mrefs.set_exception = this.code.pool.Methodref("org/python/core/Py", "setException", "(Ljava/lang/Throwable;Lorg/python/core/PyFrame;)Lorg/python/core/PyException;");
        }
        this.code.invokestatic(this.mrefs.set_exception);
        int exc = this.storeTop();
        if (n % 2 != 0) {
            this.exceptionTest(exc, handler_end, node, 1);
            handler_end.setPosition();
        } else {
            Label else_end = this.code.getLabel();
            this.exceptionTest(exc, else_end, node, 1);
            handler_end.setPosition();
            node.getChild(n - 1).visit(this);
            else_end.setPosition();
        }
        this.code.freeLocal(exc);
        this.code.addExceptionHandler(start, end, handler_start, this.code.pool.Class("java/lang/Throwable"));
        return null;
    }

    public Object except_clause(SimpleNode node) throws Exception {
        throw new ParseException("Unhandled Node: " + node, node);
    }

    public Object suite(SimpleNode node) throws Exception {
        int n = node.getNumChildren();
        int i = 0;
        while (i < n) {
            Object exit = node.getChild(i).visit(this);
            if (exit != null) {
                return Exit;
            }
            ++i;
        }
        return null;
    }

    public Object or_boolean(SimpleNode node) throws Exception {
        Label end = this.code.getLabel();
        node.getChild(0).visit(this);
        this.code.dup();
        if (this.mrefs.nonzero == 0) {
            this.mrefs.nonzero = this.code.pool.Methodref("org/python/core/PyObject", "__nonzero__", "()Z");
        }
        this.code.invokevirtual(this.mrefs.nonzero);
        this.code.ifne(end);
        this.code.pop();
        node.getChild(1).visit(this);
        end.setPosition();
        return null;
    }

    public Object and_boolean(SimpleNode node) throws Exception {
        Label end = this.code.getLabel();
        node.getChild(0).visit(this);
        this.code.dup();
        if (this.mrefs.nonzero == 0) {
            this.mrefs.nonzero = this.code.pool.Methodref("org/python/core/PyObject", "__nonzero__", "()Z");
        }
        this.code.invokevirtual(this.mrefs.nonzero);
        this.code.ifeq(end);
        this.code.pop();
        node.getChild(1).visit(this);
        end.setPosition();
        return null;
    }

    public Object not_1op(SimpleNode node) throws Exception {
        return this.unaryop(node, "__not__");
    }

    public Object comparision(SimpleNode node) throws Exception {
        int n = node.getNumChildren();
        int tmp1 = this.code.getLocal();
        int tmp2 = this.code.getLocal();
        if (this.mrefs.nonzero == 0) {
            this.mrefs.nonzero = this.code.pool.Methodref("org/python/core/PyObject", "__nonzero__", "()Z");
        }
        Label end = this.code.getLabel();
        node.getChild(0).visit(this);
        int i = 1;
        while (i < n - 2) {
            node.getChild(i + 1).visit(this);
            this.code.dup();
            this.code.astore(tmp1);
            this.code.invokevirtual((Integer)node.getChild(i).visit(this));
            this.code.dup();
            this.code.astore(tmp2);
            this.code.invokevirtual(this.mrefs.nonzero);
            this.code.ifeq(end);
            this.code.aload(tmp1);
            i += 2;
        }
        node.getChild(n - 1).visit(this);
        this.code.invokevirtual((Integer)node.getChild(n - 2).visit(this));
        if (n > 3) {
            this.code.astore(tmp2);
            end.setPosition();
            this.code.aload(tmp2);
        }
        this.code.freeLocal(tmp1);
        this.code.freeLocal(tmp2);
        return null;
    }

    public int make_binop(String name) throws Exception {
        return this.code.pool.Methodref("org/python/core/PyObject", name, "(Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
    }

    public Object less_cmp(SimpleNode node) throws Exception {
        if (this.mrefs.less == null) {
            this.less = new Integer(this.make_binop("_lt"));
        }
        return this.mrefs.less;
    }

    public Object greater_cmp(SimpleNode node) throws Exception {
        if (this.mrefs.greater == null) {
            this.greater = new Integer(this.make_binop("_gt"));
        }
        return this.mrefs.greater;
    }

    public Object equal_cmp(SimpleNode node) throws Exception {
        if (this.mrefs.equal == null) {
            this.equal = new Integer(this.make_binop("_eq"));
        }
        return this.mrefs.equal;
    }

    public Object less_equal_cmp(SimpleNode node) throws Exception {
        if (this.mrefs.less_equal == null) {
            this.less_equal = new Integer(this.make_binop("_le"));
        }
        return this.mrefs.less_equal;
    }

    public Object greater_equal_cmp(SimpleNode node) throws Exception {
        if (this.mrefs.greater_equal == null) {
            this.greater_equal = new Integer(this.make_binop("_ge"));
        }
        return this.mrefs.greater_equal;
    }

    public Object notequal_cmp(SimpleNode node) throws Exception {
        if (this.mrefs.notequal == null) {
            this.notequal = new Integer(this.make_binop("_ne"));
        }
        return this.mrefs.notequal;
    }

    public Object in_cmp(SimpleNode node) throws Exception {
        if (this.mrefs.in == null) {
            this.in = new Integer(this.make_binop("_in"));
        }
        return this.mrefs.in;
    }

    public Object not_in_cmp(SimpleNode node) throws Exception {
        if (this.mrefs.not_in == null) {
            this.not_in = new Integer(this.make_binop("_notin"));
        }
        return this.mrefs.not_in;
    }

    public Object is_cmp(SimpleNode node) throws Exception {
        if (this.mrefs.is == null) {
            this.is = new Integer(this.make_binop("_is"));
        }
        return this.mrefs.is;
    }

    public Object is_not_cmp(SimpleNode node) throws Exception {
        if (this.mrefs.is_not == null) {
            this.is_not = new Integer(this.make_binop("_isnot"));
        }
        return this.mrefs.is_not;
    }

    public Object binaryop(SimpleNode node, String name) throws Exception {
        node.getChild(0).visit(this);
        node.getChild(1).visit(this);
        this.code.invokevirtual("org/python/core/PyObject", name, "(Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
        return null;
    }

    public Object unaryop(SimpleNode node, String name) throws Exception {
        node.getChild(0).visit(this);
        this.code.invokevirtual("org/python/core/PyObject", name, "()Lorg/python/core/PyObject;");
        return null;
    }

    public Object or_2op(SimpleNode node) throws Exception {
        return this.binaryop(node, "_or");
    }

    public Object xor_2op(SimpleNode node) throws Exception {
        return this.binaryop(node, "_xor");
    }

    public Object and_2op(SimpleNode node) throws Exception {
        return this.binaryop(node, "_and");
    }

    public Object lshift_2op(SimpleNode node) throws Exception {
        return this.binaryop(node, "_lshift");
    }

    public Object rshift_2op(SimpleNode node) throws Exception {
        return this.binaryop(node, "_rshift");
    }

    public Object add_2op(SimpleNode node) throws Exception {
        return this.binaryop(node, "_add");
    }

    public Object strjoin(SimpleNode node) throws Exception {
        return this.binaryop(node, "__add__");
    }

    public Object sub_2op(SimpleNode node) throws Exception {
        return this.binaryop(node, "_sub");
    }

    public Object mul_2op(SimpleNode node) throws Exception {
        return this.binaryop(node, "_mul");
    }

    public Object div_2op(SimpleNode node) throws Exception {
        return this.binaryop(node, "_div");
    }

    public Object mod_2op(SimpleNode node) throws Exception {
        return this.binaryop(node, "_mod");
    }

    public Object pos_1op(SimpleNode node) throws Exception {
        return this.unaryop(node, "__pos__");
    }

    public Object neg_1op(SimpleNode node) throws Exception {
        return this.unaryop(node, "__neg__");
    }

    public Object invert_1op(SimpleNode node) throws Exception {
        return this.unaryop(node, "__invert__");
    }

    public Object pow_2op(SimpleNode node) throws Exception {
        return this.binaryop(node, "_pow");
    }

    public Object aug_binaryop(SimpleNode node, String name) throws Exception {
        node.getChild(1).visit(this);
        int tmp = this.storeTop();
        this.mode = 3;
        node.getChild(0).visit(this);
        this.code.aload(tmp);
        this.code.invokevirtual("org/python/core/PyObject", name, "(Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
        this.code.freeLocal(tmp);
        this.temporary = this.storeTop();
        this.mode = 4;
        node.getChild(0).visit(this);
        this.mode = 0;
        return null;
    }

    public Object aug_plus(SimpleNode node) throws Exception {
        return this.aug_binaryop(node, "__iadd__");
    }

    public Object aug_minus(SimpleNode node) throws Exception {
        return this.aug_binaryop(node, "__isub__");
    }

    public Object aug_multiply(SimpleNode node) throws Exception {
        return this.aug_binaryop(node, "__imul__");
    }

    public Object aug_divide(SimpleNode node) throws Exception {
        return this.aug_binaryop(node, "__idiv__");
    }

    public Object aug_modulo(SimpleNode node) throws Exception {
        return this.aug_binaryop(node, "__imod__");
    }

    public Object aug_and(SimpleNode node) throws Exception {
        return this.aug_binaryop(node, "__iand__");
    }

    public Object aug_or(SimpleNode node) throws Exception {
        return this.aug_binaryop(node, "__ior__");
    }

    public Object aug_xor(SimpleNode node) throws Exception {
        return this.aug_binaryop(node, "__ixor__");
    }

    public Object aug_lshift(SimpleNode node) throws Exception {
        return this.aug_binaryop(node, "__ilshift__");
    }

    public Object aug_rshift(SimpleNode node) throws Exception {
        return this.aug_binaryop(node, "__irshift__");
    }

    public Object aug_power(SimpleNode node) throws Exception {
        return this.aug_binaryop(node, "__ipow__");
    }

    public static void makeStrings(Code c, String[] names, int n) throws IOException {
        c.iconst(n);
        c.anewarray(c.pool.Class("java/lang/String"));
        int strings = c.getLocal();
        c.astore(strings);
        int i = 0;
        while (i < n) {
            c.aload(strings);
            c.iconst(i);
            c.ldc(names[i]);
            c.aastore();
            ++i;
        }
        c.aload(strings);
        c.freeLocal(strings);
    }

    public Object Invoke(SimpleNode inst, SimpleNode nname, SimpleNode[] values) throws Exception {
        String name = this.getName(nname);
        inst.visit(this);
        this.code.ldc(name);
        switch (values.length) {
            case 0: {
                if (this.mrefs.invokea0 == 0) {
                    this.mrefs.invokea0 = this.code.pool.Methodref("org/python/core/PyObject", "invoke", "(Ljava/lang/String;)Lorg/python/core/PyObject;");
                }
                this.code.invokevirtual(this.mrefs.invokea0);
                break;
            }
            case 1: {
                if (this.mrefs.invokea1 == 0) {
                    this.mrefs.invokea1 = this.code.pool.Methodref("org/python/core/PyObject", "invoke", "(Ljava/lang/String;Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
                }
                values[0].visit(this);
                this.code.invokevirtual(this.mrefs.invokea1);
                break;
            }
            case 2: {
                if (this.mrefs.invokea2 == 0) {
                    this.mrefs.invokea2 = this.code.pool.Methodref("org/python/core/PyObject", "invoke", "(Ljava/lang/String;Lorg/python/core/PyObject;Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
                }
                values[0].visit(this);
                values[1].visit(this);
                this.code.invokevirtual(this.mrefs.invokea2);
                break;
            }
            default: {
                this.makeArray(values);
                if (this.mrefs.invoke2 == 0) {
                    this.mrefs.invoke2 = this.code.pool.Methodref("org/python/core/PyObject", "invoke", "(Ljava/lang/String;[Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
                }
                this.code.invokevirtual(this.mrefs.invoke2);
                break;
            }
        }
        return null;
    }

    public Object Call_Op(SimpleNode node) throws Exception {
        SimpleNode[] values;
        SimpleNode callee = node.getChild(0);
        SimpleNode args = null;
        if (node.getNumChildren() > 1) {
            args = node.getChild(1);
        }
        String[] keys = null;
        int nKeywords = 0;
        SimpleNode starargs = null;
        SimpleNode kwargs = null;
        if (args != null) {
            int n = args.getNumChildren();
            SimpleNode lastarg = args.getChild(n - 1);
            if (lastarg.id == 89) {
                --n;
                kwargs = lastarg;
            }
            if (n > 0) {
                lastarg = args.getChild(n - 1);
                if (lastarg.id == 88) {
                    --n;
                    starargs = lastarg;
                }
            }
            values = new SimpleNode[n];
            keys = new String[n];
            int i = 0;
            while (i < n) {
                SimpleNode arg = args.getChild(i);
                if (arg.id != 90) {
                    values[i] = arg;
                    if (nKeywords > 0) {
                        throw new ParseException("non-keyword argument following keyword", node);
                    }
                } else {
                    values[i] = arg.getChild(1);
                    keys[nKeywords++] = (String)arg.getChild(0).getInfo();
                }
                ++i;
            }
        } else {
            values = new SimpleNode[]{};
        }
        if (nKeywords == 0 && starargs == null && kwargs == null && callee.id == 74) {
            return this.Invoke(callee.getChild(0), callee.getChild(1), values);
        }
        callee.visit(this);
        if (starargs != null || kwargs != null) {
            this.makeArray(values);
            CodeCompiler.makeStrings(this.code, keys, nKeywords);
            if (starargs == null) {
                this.code.aconst_null();
            } else {
                starargs.getChild(0).visit(this);
            }
            if (kwargs == null) {
                this.code.aconst_null();
            } else {
                kwargs.getChild(0).visit(this);
            }
            if (this.mrefs.callextra == 0) {
                this.mrefs.callextra = this.code.pool.Methodref("org/python/core/PyObject", "_callextra", "([Lorg/python/core/PyObject;[Ljava/lang/String;Lorg/python/core/PyObject;Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
            }
            this.code.invokevirtual(this.mrefs.callextra);
        } else if (nKeywords > 0) {
            this.makeArray(values);
            CodeCompiler.makeStrings(this.code, keys, nKeywords);
            if (this.mrefs.call1 == 0) {
                this.mrefs.call1 = this.code.pool.Methodref("org/python/core/PyObject", "__call__", "([Lorg/python/core/PyObject;[Ljava/lang/String;)Lorg/python/core/PyObject;");
            }
            this.code.invokevirtual(this.mrefs.call1);
        } else {
            switch (values.length) {
                case 0: {
                    if (this.mrefs.calla0 == 0) {
                        this.mrefs.calla0 = this.code.pool.Methodref("org/python/core/PyObject", "__call__", "()Lorg/python/core/PyObject;");
                    }
                    this.code.invokevirtual(this.mrefs.calla0);
                    break;
                }
                case 1: {
                    if (this.mrefs.calla1 == 0) {
                        this.mrefs.calla1 = this.code.pool.Methodref("org/python/core/PyObject", "__call__", "(Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
                    }
                    values[0].visit(this);
                    this.code.invokevirtual(this.mrefs.calla1);
                    break;
                }
                case 2: {
                    if (this.mrefs.calla2 == 0) {
                        this.mrefs.calla2 = this.code.pool.Methodref("org/python/core/PyObject", "__call__", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
                    }
                    values[0].visit(this);
                    values[1].visit(this);
                    this.code.invokevirtual(this.mrefs.calla2);
                    break;
                }
                case 3: {
                    if (this.mrefs.calla3 == 0) {
                        this.mrefs.calla3 = this.code.pool.Methodref("org/python/core/PyObject", "__call__", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
                    }
                    values[0].visit(this);
                    values[1].visit(this);
                    values[2].visit(this);
                    this.code.invokevirtual(this.mrefs.calla3);
                    break;
                }
                case 4: {
                    if (this.mrefs.calla4 == 0) {
                        this.mrefs.calla4 = this.code.pool.Methodref("org/python/core/PyObject", "__call__", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;Lorg/python/core/PyObject;Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
                    }
                    values[0].visit(this);
                    values[1].visit(this);
                    values[2].visit(this);
                    values[3].visit(this);
                    this.code.invokevirtual(this.mrefs.calla4);
                    break;
                }
                default: {
                    this.makeArray(values);
                    if (this.mrefs.call2 == 0) {
                        this.mrefs.call2 = this.code.pool.Methodref("org/python/core/PyObject", "__call__", "([Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
                    }
                    this.code.invokevirtual(this.mrefs.call2);
                    break;
                }
            }
        }
        return null;
    }

    public Object Slice_Op(SimpleNode seq, SimpleNode node) throws Exception {
        if (this.mode == 4) {
            this.restoreAugTmps(node, 4);
            this.mode = 1;
        } else {
            int old_mode = this.mode;
            this.mode = 0;
            seq.visit(this);
            SimpleNode[] slice = new SimpleNode[3];
            int n = node.getNumChildren();
            int i = 0;
            int j = 0;
            while (j < n) {
                SimpleNode child = node.getChild(j);
                if (child.id == 83) {
                    ++i;
                } else {
                    slice[i] = child;
                }
                ++j;
            }
            i = 0;
            while (i < 3) {
                if (slice[i] == null) {
                    this.code.aconst_null();
                } else {
                    slice[i].visit(this);
                }
                ++i;
            }
            this.mode = old_mode;
            if (this.mode == 3) {
                this.saveAugTmps(node, 4);
                this.mode = 0;
            }
        }
        switch (this.mode) {
            case 2: {
                if (this.mrefs.delslice == 0) {
                    this.mrefs.delslice = this.code.pool.Methodref("org/python/core/PyObject", "__delslice__", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;Lorg/python/core/PyObject;)V");
                }
                this.code.invokevirtual(this.mrefs.delslice);
                return null;
            }
            case 0: {
                if (this.mrefs.getslice == 0) {
                    this.mrefs.getslice = this.code.pool.Methodref("org/python/core/PyObject", "__getslice__", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
                }
                this.code.invokevirtual(this.mrefs.getslice);
                return null;
            }
            case 1: {
                this.code.aload(this.temporary);
                if (this.mrefs.setslice == 0) {
                    this.mrefs.setslice = this.code.pool.Methodref("org/python/core/PyObject", "__setslice__", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;Lorg/python/core/PyObject;Lorg/python/core/PyObject;)V");
                }
                this.code.invokevirtual(this.mrefs.setslice);
                return null;
            }
        }
        return null;
    }

    public Object Index_Op(SimpleNode node) throws Exception {
        SimpleNode seq = node.getChild(0);
        SimpleNode index = node.getChild(1);
        if (index.id == 82) {
            return this.Slice_Op(seq, index);
        }
        if (this.mode == 4) {
            this.restoreAugTmps(node, 2);
            this.mode = 1;
        } else {
            int old_mode = this.mode;
            this.mode = 0;
            seq.visit(this);
            index.visit(this);
            this.mode = old_mode;
            if (this.mode == 3) {
                this.saveAugTmps(node, 2);
                this.mode = 0;
            }
        }
        switch (this.mode) {
            case 2: {
                if (this.mrefs.delitem == 0) {
                    this.mrefs.delitem = this.code.pool.Methodref("org/python/core/PyObject", "__delitem__", "(Lorg/python/core/PyObject;)V");
                }
                this.code.invokevirtual(this.mrefs.delitem);
                return null;
            }
            case 0: {
                if (this.mrefs.getitem == 0) {
                    this.mrefs.getitem = this.code.pool.Methodref("org/python/core/PyObject", "__getitem__", "(Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
                }
                this.code.invokevirtual(this.mrefs.getitem);
                return null;
            }
            case 1: {
                this.code.aload(this.temporary);
                if (this.mrefs.setitem == 0) {
                    this.mrefs.setitem = this.code.pool.Methodref("org/python/core/PyObject", "__setitem__", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;)V");
                }
                this.code.invokevirtual(this.mrefs.setitem);
                return null;
            }
        }
        return null;
    }

    public Object Dot_Op(SimpleNode node) throws Exception {
        if (this.mode == 4) {
            this.restoreAugTmps(node, 2);
            this.mode = 1;
        } else {
            String name = this.getName(node.getChild(1));
            int old_mode = this.mode;
            this.mode = 0;
            node.getChild(0).visit(this);
            this.mode = old_mode;
            this.code.ldc(name);
            if (this.mode == 3) {
                this.saveAugTmps(node, 2);
                this.mode = 0;
            }
        }
        switch (this.mode) {
            case 2: {
                if (this.mrefs.delattr == 0) {
                    this.mrefs.delattr = this.code.pool.Methodref("org/python/core/PyObject", "__delattr__", "(Ljava/lang/String;)V");
                }
                this.code.invokevirtual(this.mrefs.delattr);
                return null;
            }
            case 0: {
                if (this.mrefs.getattr == 0) {
                    this.mrefs.getattr = this.code.pool.Methodref("org/python/core/PyObject", "__getattr__", "(Ljava/lang/String;)Lorg/python/core/PyObject;");
                }
                this.code.invokevirtual(this.mrefs.getattr);
                return null;
            }
            case 1: {
                this.code.aload(this.temporary);
                if (this.mrefs.setattr == 0) {
                    this.mrefs.setattr = this.code.pool.Methodref("org/python/core/PyObject", "__setattr__", "(Ljava/lang/String;Lorg/python/core/PyObject;)V");
                }
                this.code.invokevirtual(this.mrefs.setattr);
                return null;
            }
        }
        return null;
    }

    public Object seqSet(SimpleNode node) throws Exception {
        int n = node.getNumChildren();
        if (n > 0 && node.getChild((int)(n - 1)).id == 84) {
            --n;
        }
        if (this.mrefs.unpackSequence == 0) {
            this.mrefs.unpackSequence = this.code.pool.Methodref("org/python/core/Py", "unpackSequence", "(Lorg/python/core/PyObject;I)[Lorg/python/core/PyObject;");
        }
        this.code.aload(this.temporary);
        this.code.iconst(n);
        this.code.invokestatic(this.mrefs.unpackSequence);
        int tmp = this.code.getLocal();
        this.code.astore(tmp);
        int i = 0;
        while (i < n) {
            this.code.aload(tmp);
            this.code.iconst(i);
            this.code.aaload();
            this.set(node.getChild(i));
            ++i;
        }
        this.code.freeLocal(tmp);
        return null;
    }

    public Object seqDel(SimpleNode node) throws Exception {
        int n = node.getNumChildren();
        if (n > 0 && node.getChild((int)(n - 1)).id == 84) {
            --n;
        }
        int i = 0;
        while (i < n) {
            node.getChild(i).visit(this);
            ++i;
        }
        return null;
    }

    public Object tuple(SimpleNode node) throws Exception {
        if (this.mode == 1) {
            return this.seqSet(node);
        }
        if (this.mode == 2) {
            return this.seqDel(node);
        }
        this.code.new_(this.code.pool.Class("org/python/core/PyTuple"));
        this.code.dup();
        this.makeArray(node.children);
        if (this.mrefs.PyTuple_init == 0) {
            this.mrefs.PyTuple_init = this.code.pool.Methodref("org/python/core/PyTuple", "<init>", "([Lorg/python/core/PyObject;)V");
        }
        this.code.invokespecial(this.mrefs.PyTuple_init);
        return null;
    }

    public Object fplist(SimpleNode node) throws Exception {
        if (this.mode == 1) {
            return this.seqSet(node);
        }
        throw new ParseException("in fplist node", node);
    }

    public Object list(SimpleNode node) throws Exception {
        if (node.getNumChildren() > 1 && node.getChild((int)1).id == 40) {
            return this.list_comprehension(node);
        }
        if (this.mode == 1) {
            return this.seqSet(node);
        }
        if (this.mode == 2) {
            return this.seqDel(node);
        }
        this.code.new_(this.code.pool.Class("org/python/core/PyList"));
        this.code.dup();
        this.makeArray(node.children);
        if (this.mrefs.PyList_init == 0) {
            this.mrefs.PyList_init = this.code.pool.Methodref("org/python/core/PyList", "<init>", "([Lorg/python/core/PyObject;)V");
        }
        this.code.invokespecial(this.mrefs.PyList_init);
        return null;
    }

    public Object list_comprehension(SimpleNode node) throws Exception {
        this.code.new_(this.code.pool.Class("org/python/core/PyList"));
        this.code.dup();
        if (this.mrefs.PyList_init2 == 0) {
            this.mrefs.PyList_init2 = this.code.pool.Methodref("org/python/core/PyList", "<init>", "()V");
        }
        this.code.invokespecial(this.mrefs.PyList_init2);
        this.code.dup();
        int tmp_list = this.storeTop();
        this.code.aload(tmp_list);
        this.code.ldc("append");
        if (this.mrefs.getattr == 0) {
            this.mrefs.getattr = this.code.pool.Methodref("org/python/core/PyObject", "__getattr__", "(Ljava/lang/String;)Lorg/python/core/PyObject;");
        }
        this.code.invokevirtual(this.mrefs.getattr);
        int tmp_append = this.storeTop();
        this.listComprehensionExprs.push(node.getChild(0));
        this.listComprehensionAppends.push(new Integer(tmp_append));
        node.getChild(1).visit(this);
        this.listComprehensionAppends.pop();
        this.listComprehensionExprs.pop();
        return null;
    }

    public Object list_iter(SimpleNode node) throws Exception {
        if (node.getNumChildren() == 0) {
            int tmp_append = (Integer)this.listComprehensionAppends.peek();
            SimpleNode exprNode = (SimpleNode)this.listComprehensionExprs.peek();
            this.code.aload(tmp_append);
            exprNode.visit(this);
            if (this.mrefs.calla1 == 0) {
                this.mrefs.calla1 = this.code.pool.Methodref("org/python/core/PyObject", "__call__", "(Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
            }
            this.code.invokevirtual(this.mrefs.calla1);
            this.code.pop();
            return null;
        }
        return node.getChild(0).visit(this);
    }

    public Object dictionary(SimpleNode node) throws Exception {
        this.code.new_(this.code.pool.Class("org/python/core/PyDictionary"));
        this.code.dup();
        this.makeArray(node.children);
        if (this.mrefs.PyDictionary_init == 0) {
            this.mrefs.PyDictionary_init = this.code.pool.Methodref("org/python/core/PyDictionary", "<init>", "([Lorg/python/core/PyObject;)V");
        }
        this.code.invokespecial(this.mrefs.PyDictionary_init);
        return null;
    }

    public Object str_1op(SimpleNode node) throws Exception {
        node.getChild(0).visit(this);
        this.code.invokevirtual("org/python/core/PyObject", "__repr__", "()Lorg/python/core/PyString;");
        return null;
    }

    public Object lambdef(SimpleNode node) throws Exception {
        SimpleNode suite;
        String name = "<lambda>";
        if (node.getNumChildren() == 2) {
            SimpleNode simpleNode = node.getChild(1);
        } else {
            suite = node.getChild(0);
        }
        SimpleNode retSuite = new SimpleNode(28);
        retSuite.jjtAddChild(suite, 0);
        this.setline(node);
        this.code.new_(this.code.pool.Class("org/python/core/PyFunction"));
        this.code.dup();
        this.loadFrame();
        if (this.mrefs.f_globals == 0) {
            this.mrefs.f_globals = this.code.pool.Fieldref("org/python/core/PyFrame", "f_globals", "Lorg/python/core/PyObject;");
        }
        this.code.getfield(this.mrefs.f_globals);
        this.makeArray(node.scope.ac.getDefaults());
        node.scope.setup_closure(this.my_scope);
        node.scope.dump();
        this.module.PyCode(retSuite, name, true, this.className, false, false, node.beginLine, node.scope).get(this.code);
        Vector freenames = node.scope.freevars;
        node.scope = null;
        if (!this.makeClosure(freenames)) {
            if (this.mrefs.PyFunction_init1 == 0) {
                this.mrefs.PyFunction_init1 = this.code.pool.Methodref("org/python/core/PyFunction", "<init>", "(Lorg/python/core/PyObject;[Lorg/python/core/PyObject;Lorg/python/core/PyCode;)V");
            }
            this.code.invokespecial(this.mrefs.PyFunction_init1);
        } else {
            if (this.mrefs.PyFunction_closure_init1 == 0) {
                this.mrefs.PyFunction_closure_init1 = this.code.pool.Methodref("org/python/core/PyFunction", "<init>", "(Lorg/python/core/PyObject;[Lorg/python/core/PyObject;Lorg/python/core/PyCode;[Lorg/python/core/PyObject;)V");
            }
            this.code.invokespecial(this.mrefs.PyFunction_closure_init1);
        }
        return null;
    }

    public Object Ellipses(SimpleNode node) throws Exception {
        if (this.mrefs.Ellipsis == 0) {
            this.mrefs.Ellipsis = this.code.pool.Fieldref("org/python/core/Py", "Ellipsis", "Lorg/python/core/PyObject;");
        }
        this.code.getstatic(this.mrefs.Ellipsis);
        return null;
    }

    public Object Slice(SimpleNode node) throws Exception {
        SimpleNode[] slice = new SimpleNode[3];
        int n = node.getNumChildren();
        int i = 0;
        int j = 0;
        while (j < n) {
            SimpleNode child = node.getChild(j);
            if (child.id == 83) {
                ++i;
            } else {
                slice[i] = child;
            }
            ++j;
        }
        this.code.new_(this.code.pool.Class("org/python/core/PySlice"));
        this.code.dup();
        i = 0;
        while (i < 3) {
            if (slice[i] == null) {
                this.getNone();
            } else {
                slice[i].visit(this);
            }
            ++i;
        }
        if (this.mrefs.PySlice_init == 0) {
            this.mrefs.PySlice_init = this.code.pool.Methodref("org/python/core/PySlice", "<init>", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;Lorg/python/core/PyObject;)V");
        }
        this.code.invokespecial(this.mrefs.PySlice_init);
        return null;
    }

    public Object classdef(SimpleNode node) throws Exception {
        this.setline(node);
        String name = this.getName(node.getChild(0));
        this.code.ldc(name);
        int n = node.getNumChildren();
        SimpleNode[] bases = new SimpleNode[n - 2];
        int i = 0;
        while (i < n - 2) {
            bases[i] = node.getChild(i + 1);
            ++i;
        }
        this.makeArray(bases);
        node.scope.setup_closure(this.my_scope);
        node.scope.dump();
        this.module.PyCode(node.getChild(n - 1), name, false, name, true, false, node.beginLine, node.scope).get(this.code);
        Vector freenames = node.scope.freevars;
        node.scope = null;
        this.getDocString(node.getChild(n - 1));
        if (!this.makeClosure(freenames)) {
            if (this.mrefs.makeClass == 0) {
                this.mrefs.makeClass = this.code.pool.Methodref("org/python/core/Py", "makeClass", "(Ljava/lang/String;[Lorg/python/core/PyObject;Lorg/python/core/PyCode;Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
            }
            this.code.invokestatic(this.mrefs.makeClass);
        } else {
            if (this.mrefs.makeClass_closure == 0) {
                this.mrefs.makeClass_closure = this.code.pool.Methodref("org/python/core/Py", "makeClass", "(Ljava/lang/String;[Lorg/python/core/PyObject;Lorg/python/core/PyCode;Lorg/python/core/PyObject;[Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
            }
            this.code.invokestatic(this.mrefs.makeClass_closure);
        }
        this.set(node.getChild(0));
        return null;
    }

    public Object Int(SimpleNode node) throws Exception {
        Object n = node.getInfo();
        if (n instanceof Integer) {
            int i = (Integer)n;
            this.module.PyInteger(i).get(this.code);
        } else {
            this.module.PyLong((String)n).get(this.code);
        }
        return null;
    }

    public Object Float(SimpleNode node) throws Exception {
        this.module.PyFloat((Double)node.getInfo()).get(this.code);
        return null;
    }

    public Object Complex(SimpleNode node) throws Exception {
        this.module.PyComplex((Double)node.getInfo()).get(this.code);
        return null;
    }

    private final String getName(SimpleNode node) {
        String name = (String)node.getInfo();
        if (this.className != null && name.startsWith("__") && !name.endsWith("__")) {
            return "_" + this.className + name;
        }
        return name;
    }

    void emitGetGlobal(String name) throws Exception {
        this.code.ldc(name);
        if (this.mrefs.getglobal == 0) {
            this.mrefs.getglobal = this.code.pool.Methodref("org/python/core/PyFrame", "getglobal", "(Ljava/lang/String;)Lorg/python/core/PyObject;");
        }
        this.code.invokevirtual(this.mrefs.getglobal);
    }

    public Object Name(SimpleNode node) throws Exception {
        String name;
        if (this.fast_locals) {
            String string2 = (String)node.getInfo();
        } else {
            name = this.getName(node);
        }
        if (this.mode == 3) {
            this.mode = 0;
        } else if (this.mode == 4) {
            this.mode = 1;
        }
        SymInfo syminf = (SymInfo)this.tbl.get(name);
        switch (this.mode) {
            case 0: {
                this.loadFrame();
                if (syminf != null) {
                    int flags = syminf.flags;
                    if (!this.my_scope.nested_scopes) {
                        flags &= 0xFFFFFFDF;
                    }
                    if ((flags & 0x42) != 0 || this.optimizeGlobals && (flags & 0x31) == 0) {
                        this.emitGetGlobal(name);
                        return null;
                    }
                    if (this.fast_locals) {
                        if ((flags & 0x10) != 0) {
                            this.code.iconst(syminf.env_index);
                            if (this.mrefs.getderef == 0) {
                                this.mrefs.getderef = this.code.pool.Methodref("org/python/core/PyFrame", "getderef", "(I)Lorg/python/core/PyObject;");
                            }
                            this.code.invokevirtual(this.mrefs.getderef);
                            return null;
                        }
                        if ((flags & 1) != 0) {
                            this.code.iconst(syminf.locals_index);
                            if (this.mrefs.getlocal2 == 0) {
                                this.mrefs.getlocal2 = this.code.pool.Methodref("org/python/core/PyFrame", "getlocal", "(I)Lorg/python/core/PyObject;");
                            }
                            this.code.invokevirtual(this.mrefs.getlocal2);
                            return null;
                        }
                    }
                    if ((flags & 0x20) != 0 && (flags & 1) == 0) {
                        this.code.iconst(syminf.env_index);
                        if (this.mrefs.getderef == 0) {
                            this.mrefs.getderef = this.code.pool.Methodref("org/python/core/PyFrame", "getderef", "(I)Lorg/python/core/PyObject;");
                        }
                        this.code.invokevirtual(this.mrefs.getderef);
                        return null;
                    }
                }
                this.code.ldc(name);
                if (this.mrefs.getlocal1 == 0) {
                    this.mrefs.getlocal1 = this.code.pool.Methodref("org/python/core/PyFrame", "getname", "(Ljava/lang/String;)Lorg/python/core/PyObject;");
                }
                this.code.invokevirtual(this.mrefs.getlocal1);
                return null;
            }
            case 1: {
                this.loadFrame();
                if (syminf != null && (syminf.flags & 0x42) != 0) {
                    this.code.ldc(name);
                    this.code.aload(this.temporary);
                    if (this.mrefs.setglobal == 0) {
                        this.mrefs.setglobal = this.code.pool.Methodref("org/python/core/PyFrame", "setglobal", "(Ljava/lang/String;Lorg/python/core/PyObject;)V");
                    }
                    this.code.invokevirtual(this.mrefs.setglobal);
                } else if (!this.fast_locals) {
                    this.code.ldc(name);
                    this.code.aload(this.temporary);
                    if (this.mrefs.setlocal1 == 0) {
                        this.mrefs.setlocal1 = this.code.pool.Methodref("org/python/core/PyFrame", "setlocal", "(Ljava/lang/String;Lorg/python/core/PyObject;)V");
                    }
                    this.code.invokevirtual(this.mrefs.setlocal1);
                } else {
                    if (syminf == null) {
                        System.err.println("internal compiler error: " + node);
                    }
                    if ((syminf.flags & 0x10) != 0) {
                        this.code.iconst(syminf.env_index);
                        this.code.aload(this.temporary);
                        if (this.mrefs.setderef == 0) {
                            this.mrefs.setderef = this.code.pool.Methodref("org/python/core/PyFrame", "setderef", "(ILorg/python/core/PyObject;)V");
                        }
                        this.code.invokevirtual(this.mrefs.setderef);
                    } else {
                        this.code.iconst(syminf.locals_index);
                        this.code.aload(this.temporary);
                        if (this.mrefs.setlocal2 == 0) {
                            this.mrefs.setlocal2 = this.code.pool.Methodref("org/python/core/PyFrame", "setlocal", "(ILorg/python/core/PyObject;)V");
                        }
                        this.code.invokevirtual(this.mrefs.setlocal2);
                    }
                }
                return null;
            }
            case 2: {
                this.loadFrame();
                if (syminf != null && (syminf.flags & 0x42) != 0) {
                    this.code.ldc(name);
                    if (this.mrefs.delglobal == 0) {
                        this.mrefs.delglobal = this.code.pool.Methodref("org/python/core/PyFrame", "delglobal", "(Ljava/lang/String;)V");
                    }
                    this.code.invokevirtual(this.mrefs.delglobal);
                } else if (!this.fast_locals) {
                    this.code.ldc(name);
                    if (this.mrefs.dellocal1 == 0) {
                        this.mrefs.dellocal1 = this.code.pool.Methodref("org/python/core/PyFrame", "dellocal", "(Ljava/lang/String;)V");
                    }
                    this.code.invokevirtual(this.mrefs.dellocal1);
                } else {
                    if (syminf == null) {
                        System.err.println("internal compiler error: " + node);
                    }
                    if ((syminf.flags & 0x10) != 0) {
                        this.error("can not delete variable '" + name + "' referenced in nested scope", true, node);
                    }
                    this.code.iconst(syminf.locals_index);
                    if (this.mrefs.dellocal2 == 0) {
                        this.mrefs.dellocal2 = this.code.pool.Methodref("org/python/core/PyFrame", "dellocal", "(I)V");
                    }
                    this.code.invokevirtual(this.mrefs.dellocal2);
                }
                return null;
            }
        }
        return null;
    }

    public Object String(SimpleNode node) throws Exception {
        String s = (String)node.getInfo();
        if (s.length() > Short.MAX_VALUE) {
            throw new ParseException("string constant too large (more than 32767 characters)", node);
        }
        this.module.PyString(s).get(this.code);
        return null;
    }

    public CodeCompiler(Module module, boolean print_results) {
        this.module = module;
        this.mrefs = this;
        this.pool = module.classfile.pool;
        this.continueLabels = new Stack();
        this.breakLabels = new Stack();
        this.finallyLabels = new Stack();
        this.listComprehensionExprs = new Stack();
        this.listComprehensionAppends = new Stack();
        this.print_results = print_results;
    }
}

