/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringBufferInputStream;
import java.io.UnsupportedEncodingException;
import org.python.core.CompilerFlags;
import org.python.core.FixMacReaderBug;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PySyntaxError;
import org.python.parser.Node;
import org.python.parser.ParseException;
import org.python.parser.PythonGrammar;
import org.python.parser.ReaderCharStream;
import org.python.parser.SimpleNode;
import org.python.parser.Token;
import org.python.parser.TokenMgrError;

public class parser {
    /*
     * WARNING - void declaration
     */
    static String getLine(BufferedReader reader, int line) {
        if (reader == null) {
            return "";
        }
        try {
            void ioe;
            String text = null;
            int i = 0;
            while (i < line) {
                text = reader.readLine();
                ++i;
            }
            return ioe;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public static PyException fixParseError(BufferedReader reader, Throwable t, String filename) {
        return parser.fixParseError(reader, t, filename, false);
    }

    static PyException fixParseError(BufferedReader reader, Throwable t, String filename, boolean forceNewline) {
        if (t instanceof ParseException) {
            ParseException e = (ParseException)t;
            Token tok = e.currentToken;
            int col = 0;
            int line = 0;
            if (tok != null && tok.next != null) {
                col = tok.next.beginColumn;
                line = tok.next.beginLine;
            }
            String text = parser.getLine(reader, line);
            return new PySyntaxError(e.getMessage(), line, col, text, filename, forceNewline);
        }
        if (t instanceof TokenMgrError) {
            TokenMgrError e = (TokenMgrError)t;
            boolean eofSeen = e.EOFSeen;
            int col = e.errorColumn;
            int line = e.errorLine;
            String text = parser.getLine(reader, line);
            if (eofSeen) {
                --col;
            }
            return new PySyntaxError(e.getMessage(), line, col, text, filename, forceNewline);
        }
        return Py.JavaError(t);
    }

    public static Node parse(String string2, String kind) {
        return parser.parse(new StringBufferInputStream(string2), kind, "<string>", null);
    }

    public static SimpleNode parse(InputStream istream, String kind, String filename, CompilerFlags cflags) {
        SimpleNode node;
        block17: {
            int nbytes;
            try {
                int n = istream.available();
            }
            catch (IOException ioe1) {
                nbytes = 10000;
            }
            if (nbytes <= 0) {
                nbytes = 10000;
            }
            if (nbytes > 100000) {
                nbytes = 100000;
            }
            Reader reader = null;
            try {
                if (cflags != null && cflags.encoding != null) {
                    reader = new InputStreamReader(istream, cflags.encoding);
                }
            }
            catch (UnsupportedEncodingException exc) {
                // empty catch block
            }
            if (reader == null) {
                reader = new InputStreamReader(istream);
            }
            reader = new FixMacReaderBug(reader);
            BufferedReader bufreader = new BufferedReader(reader);
            try {
                bufreader.mark(nbytes);
            }
            catch (IOException exc) {
                // empty catch block
            }
            PythonGrammar g = new PythonGrammar(new ReaderCharStream(bufreader));
            node = null;
            try {
                if (kind.equals("eval")) {
                    node = g.eval_input();
                    break block17;
                }
                if (kind.equals("exec")) {
                    node = g.file_input();
                    break block17;
                }
                if (kind.equals("single")) {
                    node = g.single_input();
                    break block17;
                }
                throw Py.ValueError("parse kind must be eval, exec, or single");
            }
            catch (Throwable t) {
                try {
                    bufreader.reset();
                    throw parser.fixParseError(bufreader, t, filename, g.token_source.forcedNewline);
                }
                catch (IOException ioe) {
                    throw parser.fixParseError(null, t, filename, g.token_source.forcedNewline);
                }
            }
        }
        return node;
    }

    public static SimpleNode partialParse(String string2, String kind, String filename, CompilerFlags cflags) {
        SimpleNode node = null;
        try {
            node = parser.parse(new StringBufferInputStream(string2), kind, filename, cflags);
        }
        catch (PySyntaxError e) {
            block4: {
                try {
                    node = parser.parse(new StringBufferInputStream(string2 + "\n"), kind, filename, cflags);
                }
                catch (PySyntaxError e1) {
                    if (!e.forceNewline && e1.forceNewline) break block4;
                    throw e;
                }
            }
            return null;
        }
        return node;
    }

    private parser() {
    }
}

