/*
 * Decompiled with CFR 0.152.
 */
package org.python.compiler;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.python.parser.ParseException;
import org.python.parser.PythonGrammarTreeConstants;
import org.python.parser.SimpleNode;
import org.python.parser.Visitor;

public class ArgListCompiler
extends Visitor
implements PythonGrammarTreeConstants {
    public boolean arglist = false;
    public boolean keywordlist = false;
    public Vector defaults = new Vector();
    public Vector names = new Vector();
    public SimpleNode init_code = new SimpleNode(43);

    public void reset() {
        this.keywordlist = false;
        this.arglist = false;
        this.defaults.removeAllElements();
        this.names.removeAllElements();
    }

    public SimpleNode[] getDefaults() {
        SimpleNode[] children = new SimpleNode[this.defaults.size()];
        int i = 0;
        while (i < children.length) {
            children[i] = (SimpleNode)this.defaults.elementAt(i);
            ++i;
        }
        return children;
    }

    public Object varargslist(SimpleNode node) throws Exception {
        int n = node.getNumChildren();
        int i = 0;
        while (i < n) {
            node.getChild(i).visit(this);
            ++i;
        }
        return null;
    }

    public Object ExtraArgList(SimpleNode node) throws Exception {
        this.arglist = true;
        this.names.addElement(node.getChild(0).visit(this));
        return null;
    }

    public Object ExtraKeywordList(SimpleNode node) throws Exception {
        this.keywordlist = true;
        this.names.addElement(node.getChild(0).visit(this));
        return null;
    }

    public Object defaultarg(SimpleNode node) throws Exception {
        Object name = node.getChild(0).visit(this);
        Enumeration e = this.names.elements();
        while (e.hasMoreElements()) {
            String objname = (String)e.nextElement();
            if (!objname.equals(name)) continue;
            throw new ParseException("duplicate argument name found: " + name, node);
        }
        this.names.addElement(name);
        if (node.getChild((int)0).id == 9) {
            SimpleNode expr = new SimpleNode(10);
            expr.beginLine = node.beginLine;
            expr.jjtAddChild(node.getChild(0), 0);
            SimpleNode nm = new SimpleNode(94);
            nm.setInfo(name);
            expr.jjtAddChild(nm, 1);
            this.init_code.jjtAddChild(expr, this.init_code.getNumChildren());
        }
        if (node.getNumChildren() > 1) {
            this.defaults.addElement(node.getChild(1));
        } else if (this.defaults.size() > 0) {
            throw new ParseException("non-default argument follows default argument");
        }
        return null;
    }

    public Object fplist(SimpleNode node) throws Exception {
        String name = "(";
        int n = node.getNumChildren();
        int i = 0;
        while (i < n - 1) {
            name = name + node.getChild(i).visit(this) + ", ";
            ++i;
        }
        name = name + node.getChild(n - 1).visit(this) + ")";
        return name;
    }

    public Object Name(SimpleNode node) throws ParseException, IOException {
        return node.getInfo();
    }
}

