/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.jyconsole.command;

import com.artenum.jyconsole.python.JInteractiveInterpreter;
import java.io.File;

public class Command
implements Runnable {
    private JInteractiveInterpreter pythonInterpreter;
    private File commandFile;
    private String command;
    private boolean isRunning = false;
    private Thread myThread;

    public Command(JInteractiveInterpreter jInteractiveInterpreter, File file) {
        this.pythonInterpreter = jInteractiveInterpreter;
        this.commandFile = file;
    }

    public Command(JInteractiveInterpreter jInteractiveInterpreter, String string) {
        this.pythonInterpreter = jInteractiveInterpreter;
        this.command = string;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Command command = this;
        synchronized (command) {
            if (this.isRunning()) {
                this.myThread.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Command command;
        try {
            command = this;
            synchronized (command) {
                this.isRunning = true;
                this.myThread = Thread.currentThread();
            }
            if (this.commandFile != null) {
                this.pythonInterpreter.execfile(this.commandFile.getAbsolutePath());
            }
            if (this.command != null) {
                this.pythonInterpreter.runsource(this.command);
            }
        }
        finally {
            command = this;
            synchronized (command) {
                this.isRunning = false;
                this.notifyAll();
            }
        }
    }

    public String toString() {
        if (this.commandFile != null) {
            return this.commandFile.getAbsolutePath();
        }
        return this.command;
    }
}

