/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.jyconsole;

import com.artenum.jyconsole.CommandLine;
import com.artenum.jyconsole.HistoryManager;
import com.artenum.jyconsole.LogWriter;
import com.artenum.jyconsole.PreferenceManager;
import com.artenum.jyconsole.ScrollingView;
import com.artenum.jyconsole.TextComponent;
import com.artenum.jyconsole.TextPrinter;
import com.artenum.jyconsole.action.DefaultKeyBinding;
import com.artenum.jyconsole.ui.PopupMenu;
import com.artenum.jyconsole.util.PropertyLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import org.python.util.InteractiveInterpreter;

public class JyConsole
extends JPanel {
    public static final String STYLE_DEFAULT = "style.default";
    public static final String STYLE_ERROR = "style.error";
    private TextComponent archive;
    private JScrollPane scroll;
    private TextComponent command;
    private JPanel prompt;
    private JLabel promptLabel;
    private InteractiveInterpreter interpreter;
    private LogWriter out;
    private LogWriter err;
    private HistoryManager historyManager;
    private ScrollingView panel;
    private int i = 10;
    private PopupMenu popupMenu;
    private CommandLine cmd = new CommandLine();
    private File currentScriptDir;
    private PreferenceManager prefManager = new PreferenceManager();

    public JyConsole() {
        super(new BorderLayout());
        Style style = StyleContext.getDefaultStyleContext().getStyle("default");
        this.archive = new TextComponent();
        this.archive.setEditable(false);
        this.archive.setFocusable(true);
        Style style2 = this.archive.getStyledDocument().addStyle(STYLE_DEFAULT, style);
        Style style3 = this.archive.getStyledDocument().addStyle(STYLE_ERROR, style2);
        StyleConstants.setItalic(style3, true);
        StyleConstants.setForeground(style3, Color.RED);
        this.command = new TextComponent();
        this.command.setFocusable(true);
        style2 = this.command.getStyledDocument().addStyle(STYLE_DEFAULT, style);
        style3 = this.command.getStyledDocument().addStyle(STYLE_ERROR, style2);
        StyleConstants.setItalic(style3, true);
        StyleConstants.setForeground(style3, Color.RED);
        this.prompt = new JPanel();
        this.prompt.setBackground(Color.WHITE);
        this.prompt.setLayout(new BoxLayout(this.prompt, 1));
        this.promptLabel = new JLabel(">>> ");
        this.prompt.add(this.promptLabel);
        this.prompt.add(Box.createVerticalGlue());
        this.prompt.setBackground(Color.WHITE);
        this.prompt.setFocusable(false);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        jPanel.add(this.prompt);
        jPanel.add(this.command);
        jPanel.setFocusable(false);
        this.panel = new ScrollingView(new BorderLayout());
        this.panel.add((Component)this.archive, "North");
        this.panel.add((Component)jPanel, "Center");
        this.panel.setFocusable(false);
        this.panel.setOpaque(true);
        this.scroll = new JScrollPane(this.panel);
        this.add((Component)this.scroll, "Center");
        this.out = new LogWriter(this.archive, STYLE_DEFAULT);
        this.err = new LogWriter(this.archive, STYLE_ERROR);
        this.interpreter = new InteractiveInterpreter();
        this.interpreter.setOut((Writer)this.out);
        this.interpreter.setErr((Writer)this.err);
        this.historyManager = new HistoryManager(this);
        this.popupMenu = new PopupMenu(this);
        this.addMouseListener(this.popupMenu);
        this.prompt.addMouseListener(this.popupMenu);
        this.archive.addMouseListener(this.popupMenu);
        this.command.addMouseListener(this.popupMenu);
        this.scroll.addMouseListener(this.popupMenu);
        try {
            this.out.write("Welcome on JyConsole by Artenum (www.artenum.com) !");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.prefManager.addBgColorComponent(this.archive);
        this.prefManager.addBgColorComponent(this.command);
        this.prefManager.addBgColorComponent(this.prompt);
        this.prefManager.addBgColorComponent(this.scroll);
        this.prefManager.addTxtDocument(this.archive.getStyledDocument());
        this.prefManager.addTxtDocument(this.command.getStyledDocument());
        this.prefManager.setPrompt(this.promptLabel);
        if (System.getProperty("jyconsole.script.dir") != null) {
            this.setScriptDirectory(new File(System.getProperty("jyconsole.script.dir")));
        }
    }

    public void updateScrollPosition() {
        this.scroll.getViewport().scrollRectToVisible(new Rectangle(0, this.panel.getHeight() + this.scroll.getHeight() + 100, 50, 50));
    }

    public static void main(String[] stringArray) {
        try {
            PropertyLoader.loadProperties("./config.properties");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        JyConsole jyConsole = new JyConsole();
        DefaultKeyBinding.applyDefaultMapping(jyConsole);
        JFrame jFrame = new JFrame("JyConsole");
        jFrame.getContentPane().add((Component)jyConsole, "Center");
        jFrame.setDefaultCloseOperation(3);
        jFrame.setSize(600, 400);
        jFrame.setVisible(true);
    }

    public InteractiveInterpreter getInterpreter() {
        return this.interpreter;
    }

    public TextPrinter getInputComponent() {
        return this.command;
    }

    public TextPrinter getOutputComponent() {
        return this.archive;
    }

    public HistoryManager getHistoryManager() {
        return this.historyManager;
    }

    public void setFocusForInput() {
        this.command.requestFocus();
        this.command.setCaretPosition(this.command.getText().length());
    }

    public void setSimulationFlag(boolean bl) {
        this.err.setSimulationFlag(bl);
    }

    public int getPromptWidth() {
        return this.prompt.getWidth();
    }

    public CommandLine getCommandLine() {
        this.cmd.updateData(this.command.getCaretPosition(), this.command.getText());
        return this.cmd;
    }

    public void updateCommandLine(String string) {
        this.command.setText(string);
    }

    public File getScriptDirectory() {
        return this.currentScriptDir;
    }

    public void setScriptDirectory(File file) {
        this.currentScriptDir = file;
    }

    public PreferenceManager getPreferenceManager() {
        return this.prefManager;
    }
}

