/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.language;

import de.hunsicker.antlr.ANTLRHashString;
import de.hunsicker.antlr.ByteBuffer;
import de.hunsicker.antlr.CharBuffer;
import de.hunsicker.antlr.CharScanner;
import de.hunsicker.antlr.CharStreamException;
import de.hunsicker.antlr.CharStreamIOException;
import de.hunsicker.antlr.InputBuffer;
import de.hunsicker.antlr.LexerSharedInputState;
import de.hunsicker.antlr.NoViableAltForCharException;
import de.hunsicker.antlr.RecognitionException;
import de.hunsicker.antlr.Token;
import de.hunsicker.antlr.TokenStream;
import de.hunsicker.antlr.TokenStreamException;
import de.hunsicker.antlr.TokenStreamIOException;
import de.hunsicker.antlr.collections.impl.BitSet;
import de.hunsicker.io.FileFormat;
import de.hunsicker.jalopy.language.ExtendedToken;
import de.hunsicker.jalopy.language.JavaNodeFactory;
import de.hunsicker.jalopy.language.JavaParser;
import de.hunsicker.jalopy.language.JavadocLexer;
import de.hunsicker.jalopy.language.JavadocParser;
import de.hunsicker.jalopy.language.Lexer;
import de.hunsicker.jalopy.language.Node;
import de.hunsicker.jalopy.language.Parser;
import de.hunsicker.jalopy.language.Recognizer;
import de.hunsicker.util.StringHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Hashtable;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public final class JavaLexer
extends CharScanner
implements TokenStream,
Lexer {
    public static final int JDK_1_3 = 13;
    public static final int JDK_1_4 = 14;
    private static final String SPACE = " ";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String EMPTY_STRING = "";
    private FileFormat _fileFormat = FileFormat.UNKNOWN;
    private String _lineSeparator = System.getProperty("line.separator");
    private Recognizer _recognizer;
    private Logger _logger = Logger.getLogger((String)"de.hunsicker.jalopy.language.java");
    boolean parseJavadocComments;
    int sourceVersion = 14;
    boolean removeJavadocComments;
    boolean formatMLComments;
    boolean removeSLComments;
    boolean removeMLComments;
    private JavaParser _parser;
    private JavadocParser _javadocParser;
    private static final BitSet _tokenSet_0 = new BitSet(JavaLexer.mk_tokenSet_0());
    private static final BitSet _tokenSet_1 = new BitSet(JavaLexer.mk_tokenSet_1());
    private static final BitSet _tokenSet_2 = new BitSet(JavaLexer.mk_tokenSet_2());
    private static final BitSet _tokenSet_3 = new BitSet(JavaLexer.mk_tokenSet_3());
    private static final BitSet _tokenSet_4 = new BitSet(JavaLexer.mk_tokenSet_4());
    private static final BitSet _tokenSet_5 = new BitSet(JavaLexer.mk_tokenSet_5());
    private static final BitSet _tokenSet_6 = new BitSet(JavaLexer.mk_tokenSet_6());
    private static final BitSet _tokenSet_7 = new BitSet(JavaLexer.mk_tokenSet_7());
    private static final BitSet _tokenSet_8 = new BitSet(JavaLexer.mk_tokenSet_8());

    public JavaLexer() {
        this(new StringReader(EMPTY_STRING));
        JavadocLexer lexer = new JavadocLexer();
        this._javadocParser = (JavadocParser)lexer.getParser();
        this._recognizer = new Recognizer(this._javadocParser, lexer);
        this._parser = new JavaParser(this);
        this._parser.setASTFactory(new JavaNodeFactory());
    }

    public JavadocParser getJavadocParser() {
        return this._javadocParser;
    }

    public Parser getParser() {
        return this._parser;
    }

    public void setRemoveMLComments(boolean remove) {
        this.removeMLComments = remove;
    }

    public void setFormatMLComments(boolean format) {
        this.formatMLComments = format;
    }

    public boolean isFormatMLComments() {
        return this.formatMLComments;
    }

    public boolean isRemoveMLComments() {
        return this.removeMLComments;
    }

    public void setRemoveSLComments(boolean remove) {
        this.removeSLComments = remove;
    }

    public boolean isRemoveSLComments() {
        return this.removeSLComments;
    }

    public void setRemoveJavadocComments(boolean remove) {
        this.removeJavadocComments = remove;
    }

    public boolean isRemoveJavadocComments() {
        return this.removeJavadocComments;
    }

    public void setParseJavadocComments(boolean parse) {
        this.parseJavadocComments = parse;
    }

    public boolean isParseJavadocComments() {
        return this.parseJavadocComments;
    }

    public void setCompatibility(int version) {
        this.sourceVersion = version;
    }

    public int getCompatibility() {
        return this.sourceVersion;
    }

    public int testLiteralsTable(int ttype) {
        this.hashString.setBuffer(this.text.getBuffer(), this.text.length());
        Integer literalsIndex = (Integer)this.literals.get(this.hashString);
        if (literalsIndex != null) {
            ttype = literalsIndex;
            switch (ttype) {
                case 98: {
                    switch (this.sourceVersion) {
                        case 13: {
                            ttype = 68;
                        }
                    }
                }
            }
        }
        return ttype;
    }

    public int testLiteralsTable(String text, int ttype) {
        ANTLRHashString s = new ANTLRHashString(text, this);
        Integer literalsIndex = (Integer)this.literals.get(s);
        if (literalsIndex != null) {
            ttype = literalsIndex;
            switch (ttype) {
                case 98: {
                    switch (this.sourceVersion) {
                        case 13: {
                            ttype = 68;
                        }
                    }
                }
            }
        }
        return ttype;
    }

    public void panic() {
        if (this.inputState != null) {
            Object[] args = new Object[]{this.getFilename(), new Integer(this.getLine()), new Integer(this.getColumn()), "JavaLexer: panic"};
            this._logger.l7dlog((Priority)Level.FATAL, "PARSER_ERROR", args, null);
        } else {
            if (this._logger == null) {
                this._logger = Logger.getLogger((String)"de.hunsicker.jalopy.language.java");
            }
            Object[] args = new Object[]{"???", new Integer(0), new Integer(0), "JavaLexer: panic"};
            this._logger.l7dlog((Priority)Level.FATAL, "PARSER_ERROR", args, null);
        }
    }

    public void panic(String message) {
        if (this.inputState != null) {
            Object[] args = new Object[]{this.getFilename(), new Integer(this.getLine()), new Integer(this.getColumn()), message};
            this._logger.l7dlog((Priority)Level.FATAL, "PARSER_ERROR", args, null);
        } else {
            if (this._logger == null) {
                this._logger = Logger.getLogger((String)"de.hunsicker.jalopy.language.java");
            }
            Object[] args = new Object[]{"???", new Integer(0), new Integer(0), message};
            this._logger.l7dlog((Priority)Level.FATAL, "PARSER_ERROR", args, null);
        }
    }

    public void reportError(RecognitionException ex) {
        Object[] args = new Object[]{this.getFilename(), new Integer(this.getLine()), new Integer(this.getColumn()), ex.getMessage()};
        this._logger.l7dlog((Priority)Level.ERROR, "PARSER_ERROR", args, (Throwable)ex);
    }

    public void reportError(String message) {
        Object[] args = new Object[]{this.getFilename(), new Integer(this.getLine()), new Integer(this.getColumn()), message};
        this._logger.l7dlog((Priority)Level.ERROR, "PARSER_ERROR", args, null);
    }

    public void reportWarning(String message) {
        Object[] args = new Object[]{this.getFilename(), new Integer(this.getLine()), new Integer(this.getColumn()), message};
        this._logger.l7dlog((Priority)Level.WARN, "PARSER_ERROR", args, null);
    }

    protected Token makeToken(int t) {
        return new ExtendedToken(t, this.inputState.tokenStartLine, this.inputState.tokenStartColumn, this.inputState.line, this.inputState.column);
    }

    public void setTokenObjectClass(String clazz) {
        if (clazz.equals("de.hunsicker.antlr.CommonToken")) {
            clazz = "de.hunsicker.jalopy.language.ExtendedToken";
        }
        super.setTokenObjectClass(clazz);
        Object instance = null;
        try {
            instance = this.tokenObjectClass.newInstance();
        }
        catch (Exception ex) {
            this.panic(EMPTY_STRING + ex);
            return;
        }
        if (!(instance instanceof ExtendedToken)) {
            throw new IllegalArgumentException("your TokenObject class must extend de.hunsicker.jalopy.language.ExtendedToken");
        }
    }

    public FileFormat getFileFormat() {
        return this._fileFormat;
    }

    public void setInputBuffer(InputBuffer buf) {
        if (this.inputState != null) {
            this.inputState.setInputBuffer(buf);
        }
    }

    public void setInputBuffer(Reader in) {
        this.setInputBuffer(new CharBuffer(in));
    }

    public void reset() {
        if (this.inputState != null) {
            this.inputState.reset();
        }
        this.setFilename("<unknown>");
    }

    private void getNextSeparator(SeparatorInfo result, String str) {
        int offset = str.indexOf("\r\n");
        if (offset > -1) {
            result.offset = offset;
            result.length = 2;
        } else {
            result.length = 1;
            offset = str.indexOf(10);
            result.offset = offset > -1 ? offset : (offset = str.indexOf(13));
        }
    }

    private String removeLeadingWhitespace(String comment, int column, String lineSeparator) {
        String[] lines = this.split(comment, column);
        StringBuffer buf = new StringBuffer(comment.length());
        int size = lines.length;
        for (int i = 0; i < size; ++i) {
            buf.append(lines[i]);
            buf.append(this._lineSeparator);
        }
        buf.setLength(buf.length() - this._lineSeparator.length());
        return buf.toString();
    }

    private String[] split(String str, int beginOffset) {
        ArrayList<String> lines = new ArrayList<String>(15);
        SeparatorInfo info = new SeparatorInfo();
        this.getNextSeparator(info, str);
        while (info.offset > -1) {
            String line = str.substring(0, info.offset);
            str = str.substring(info.offset + info.length);
            int charOffset = StringHelper.indexOfNonWhitespace(line);
            line = charOffset > beginOffset ? line.substring(beginOffset) : (charOffset > -1 ? line.substring(charOffset) : EMPTY_STRING);
            lines.add(line);
            this.getNextSeparator(info, str);
        }
        int charOffset = StringHelper.indexOfNonWhitespace(str);
        str = charOffset > beginOffset ? str.substring(beginOffset) : (charOffset > -1 ? str.substring(charOffset) : EMPTY_STRING);
        lines.add(str);
        return lines.toArray(EMPTY_STRING_ARRAY);
    }

    public JavaLexer(InputStream in) {
        this(new ByteBuffer(in));
    }

    public JavaLexer(Reader in) {
        this(new CharBuffer(in));
    }

    public JavaLexer(InputBuffer ib) {
        this(new LexerSharedInputState(ib));
    }

    public JavaLexer(LexerSharedInputState state) {
        super(state);
        this.caseSensitiveLiterals = true;
        this.setCaseSensitive(true);
        this.literals = new Hashtable();
        this.literals.put(new ANTLRHashString("byte", this), new Integer(61));
        this.literals.put(new ANTLRHashString("public", this), new Integer(72));
        this.literals.put(new ANTLRHashString("case", this), new Integer(103));
        this.literals.put(new ANTLRHashString("short", this), new Integer(63));
        this.literals.put(new ANTLRHashString("break", this), new Integer(97));
        this.literals.put(new ANTLRHashString("while", this), new Integer(95));
        this.literals.put(new ANTLRHashString("new", this), new Integer(146));
        this.literals.put(new ANTLRHashString("instanceof", this), new Integer(131));
        this.literals.put(new ANTLRHashString("implements", this), new Integer(83));
        this.literals.put(new ANTLRHashString("synchronized", this), new Integer(77));
        this.literals.put(new ANTLRHashString("float", this), new Integer(65));
        this.literals.put(new ANTLRHashString("package", this), new Integer(54));
        this.literals.put(new ANTLRHashString("return", this), new Integer(100));
        this.literals.put(new ANTLRHashString("throw", this), new Integer(102));
        this.literals.put(new ANTLRHashString("null", this), new Integer(145));
        this.literals.put(new ANTLRHashString("protected", this), new Integer(73));
        this.literals.put(new ANTLRHashString("class", this), new Integer(79));
        this.literals.put(new ANTLRHashString("throws", this), new Integer(90));
        this.literals.put(new ANTLRHashString("do", this), new Integer(96));
        this.literals.put(new ANTLRHashString("strictfp", this), new Integer(45));
        this.literals.put(new ANTLRHashString("super", this), new Integer(87));
        this.literals.put(new ANTLRHashString("transient", this), new Integer(75));
        this.literals.put(new ANTLRHashString("native", this), new Integer(76));
        this.literals.put(new ANTLRHashString("interface", this), new Integer(81));
        this.literals.put(new ANTLRHashString("final", this), new Integer(43));
        this.literals.put(new ANTLRHashString("if", this), new Integer(92));
        this.literals.put(new ANTLRHashString("double", this), new Integer(67));
        this.literals.put(new ANTLRHashString("volatile", this), new Integer(78));
        this.literals.put(new ANTLRHashString("assert", this), new Integer(98));
        this.literals.put(new ANTLRHashString("catch", this), new Integer(106));
        this.literals.put(new ANTLRHashString("try", this), new Integer(105));
        this.literals.put(new ANTLRHashString("int", this), new Integer(64));
        this.literals.put(new ANTLRHashString("for", this), new Integer(94));
        this.literals.put(new ANTLRHashString("extends", this), new Integer(80));
        this.literals.put(new ANTLRHashString("boolean", this), new Integer(60));
        this.literals.put(new ANTLRHashString("char", this), new Integer(62));
        this.literals.put(new ANTLRHashString("private", this), new Integer(71));
        this.literals.put(new ANTLRHashString("default", this), new Integer(104));
        this.literals.put(new ANTLRHashString("false", this), new Integer(144));
        this.literals.put(new ANTLRHashString("this", this), new Integer(86));
        this.literals.put(new ANTLRHashString("static", this), new Integer(74));
        this.literals.put(new ANTLRHashString("abstract", this), new Integer(44));
        this.literals.put(new ANTLRHashString("continue", this), new Integer(99));
        this.literals.put(new ANTLRHashString("finally", this), new Integer(107));
        this.literals.put(new ANTLRHashString("else", this), new Integer(93));
        this.literals.put(new ANTLRHashString("import", this), new Integer(56));
        this.literals.put(new ANTLRHashString("void", this), new Integer(59));
        this.literals.put(new ANTLRHashString("switch", this), new Integer(101));
        this.literals.put(new ANTLRHashString("true", this), new Integer(143));
        this.literals.put(new ANTLRHashString("long", this), new Integer(66));
    }

    public Token nextToken() throws TokenStreamException {
        Token theRetToken = null;
        while (true) {
            Object _token = null;
            int _ttype = 0;
            this.resetText();
            try {
                try {
                    switch (this.LA(1)) {
                        case '?': {
                            this.mQUESTION(true);
                            theRetToken = this._returnToken;
                            break;
                        }
                        case '(': {
                            this.mLPAREN(true);
                            theRetToken = this._returnToken;
                            break;
                        }
                        case ')': {
                            this.mRPAREN(true);
                            theRetToken = this._returnToken;
                            break;
                        }
                        case '[': {
                            this.mLBRACK(true);
                            theRetToken = this._returnToken;
                            break;
                        }
                        case ']': {
                            this.mRBRACK(true);
                            theRetToken = this._returnToken;
                            break;
                        }
                        case '{': {
                            this.mLCURLY(true);
                            theRetToken = this._returnToken;
                            break;
                        }
                        case '}': {
                            this.mRCURLY(true);
                            theRetToken = this._returnToken;
                            break;
                        }
                        case ':': {
                            this.mCOLON(true);
                            theRetToken = this._returnToken;
                            break;
                        }
                        case ',': {
                            this.mCOMMA(true);
                            theRetToken = this._returnToken;
                            break;
                        }
                        case '~': {
                            this.mBNOT(true);
                            theRetToken = this._returnToken;
                            break;
                        }
                        case ';': {
                            this.mSEMI(true);
                            theRetToken = this._returnToken;
                            break;
                        }
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            this.mWS(true);
                            theRetToken = this._returnToken;
                            break;
                        }
                        case '\'': {
                            this.mCHAR_LITERAL(true);
                            theRetToken = this._returnToken;
                            break;
                        }
                        case '\"': {
                            this.mSTRING_LITERAL(true);
                            theRetToken = this._returnToken;
                            break;
                        }
                        case '$': 
                        case 'A': 
                        case 'B': 
                        case 'C': 
                        case 'D': 
                        case 'E': 
                        case 'F': 
                        case 'G': 
                        case 'H': 
                        case 'I': 
                        case 'J': 
                        case 'K': 
                        case 'L': 
                        case 'M': 
                        case 'N': 
                        case 'O': 
                        case 'P': 
                        case 'Q': 
                        case 'R': 
                        case 'S': 
                        case 'T': 
                        case 'U': 
                        case 'V': 
                        case 'W': 
                        case 'X': 
                        case 'Y': 
                        case 'Z': 
                        case '_': 
                        case 'a': 
                        case 'b': 
                        case 'c': 
                        case 'd': 
                        case 'e': 
                        case 'f': 
                        case 'g': 
                        case 'h': 
                        case 'i': 
                        case 'j': 
                        case 'k': 
                        case 'l': 
                        case 'm': 
                        case 'n': 
                        case 'o': 
                        case 'p': 
                        case 'q': 
                        case 'r': 
                        case 's': 
                        case 't': 
                        case 'u': 
                        case 'v': 
                        case 'w': 
                        case 'x': 
                        case 'y': 
                        case 'z': 
                        case '\u00c0': 
                        case '\u00c1': 
                        case '\u00c2': 
                        case '\u00c3': 
                        case '\u00c4': 
                        case '\u00c5': 
                        case '\u00c6': 
                        case '\u00c7': 
                        case '\u00c8': 
                        case '\u00c9': 
                        case '\u00ca': 
                        case '\u00cb': 
                        case '\u00cc': 
                        case '\u00cd': 
                        case '\u00ce': 
                        case '\u00cf': 
                        case '\u00d0': 
                        case '\u00d1': 
                        case '\u00d2': 
                        case '\u00d3': 
                        case '\u00d4': 
                        case '\u00d5': 
                        case '\u00d6': 
                        case '\u00d8': 
                        case '\u00d9': 
                        case '\u00da': 
                        case '\u00db': 
                        case '\u00dc': 
                        case '\u00dd': 
                        case '\u00de': 
                        case '\u00df': 
                        case '\u00e0': 
                        case '\u00e1': 
                        case '\u00e2': 
                        case '\u00e3': 
                        case '\u00e4': 
                        case '\u00e5': 
                        case '\u00e6': 
                        case '\u00e7': 
                        case '\u00e8': 
                        case '\u00e9': 
                        case '\u00ea': 
                        case '\u00eb': 
                        case '\u00ec': 
                        case '\u00ed': 
                        case '\u00ee': 
                        case '\u00ef': 
                        case '\u00f0': 
                        case '\u00f1': 
                        case '\u00f2': 
                        case '\u00f3': 
                        case '\u00f4': 
                        case '\u00f5': 
                        case '\u00f6': 
                        case '\u00f8': 
                        case '\u00f9': 
                        case '\u00fa': 
                        case '\u00fb': 
                        case '\u00fc': 
                        case '\u00fd': 
                        case '\u00fe': 
                        case '\u00ff': {
                            this.mIDENT(true);
                            theRetToken = this._returnToken;
                            break;
                        }
                        case '.': 
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            this.mNUM_INT(true);
                            theRetToken = this._returnToken;
                            break;
                        }
                        default: {
                            if (this.LA(1) == '>' && this.LA(2) == '>' && this.LA(3) == '>' && this.LA(4) == '=') {
                                this.mBSR_ASSIGN(true);
                                theRetToken = this._returnToken;
                                break;
                            }
                            if (this.LA(1) == '>' && this.LA(2) == '>' && this.LA(3) == '=') {
                                this.mSR_ASSIGN(true);
                                theRetToken = this._returnToken;
                                break;
                            }
                            if (this.LA(1) == '>' && this.LA(2) == '>' && this.LA(3) == '>') {
                                this.mBSR(true);
                                theRetToken = this._returnToken;
                                break;
                            }
                            if (this.LA(1) == '<' && this.LA(2) == '<' && this.LA(3) == '=') {
                                this.mSL_ASSIGN(true);
                                theRetToken = this._returnToken;
                                break;
                            }
                            if (this.LA(1) == '=' && this.LA(2) == '=') {
                                this.mEQUAL(true);
                                theRetToken = this._returnToken;
                                break;
                            }
                            if (this.LA(1) == '!' && this.LA(2) == '=') {
                                this.mNOT_EQUAL(true);
                                theRetToken = this._returnToken;
                                break;
                            }
                            if (this.LA(1) == '/' && this.LA(2) == '=') {
                                this.mDIV_ASSIGN(true);
                                theRetToken = this._returnToken;
                                break;
                            }
                            if (this.LA(1) == '+' && this.LA(2) == '=') {
                                this.mPLUS_ASSIGN(true);
                                theRetToken = this._returnToken;
                                break;
                            }
                            if (this.LA(1) == '+' && this.LA(2) == '+') {
                                this.mINC(true);
                                theRetToken = this._returnToken;
                                break;
                            }
                            if (this.LA(1) == '-' && this.LA(2) == '=') {
                                this.mMINUS_ASSIGN(true);
                                theRetToken = this._returnToken;
                                break;
                            }
                            if (this.LA(1) == '-' && this.LA(2) == '-') {
                                this.mDEC(true);
                                theRetToken = this._returnToken;
                                break;
                            }
                            if (this.LA(1) == '*' && this.LA(2) == '=') {
                                this.mSTAR_ASSIGN(true);
                                theRetToken = this._returnToken;
                                break;
                            }
                            if (this.LA(1) == '%' && this.LA(2) == '=') {
                                this.mMOD_ASSIGN(true);
                                theRetToken = this._returnToken;
                                break;
                            }
                            if (this.LA(1) == '>' && this.LA(2) == '>') {
                                this.mSR(true);
                                theRetToken = this._returnToken;
                                break;
                            }
                            if (this.LA(1) == '>' && this.LA(2) == '=') {
                                this.mGE(true);
                                theRetToken = this._returnToken;
                                break;
                            }
                            if (this.LA(1) == '<' && this.LA(2) == '<') {
                                this.mSL(true);
                                theRetToken = this._returnToken;
                                break;
                            }
                            if (this.LA(1) == '<' && this.LA(2) == '=') {
                                this.mLE(true);
                                theRetToken = this._returnToken;
                                break;
                            }
                            if (this.LA(1) == '^' && this.LA(2) == '=') {
                                this.mBXOR_ASSIGN(true);
                                theRetToken = this._returnToken;
                                break;
                            }
                            if (this.LA(1) == '|' && this.LA(2) == '=') {
                                this.mBOR_ASSIGN(true);
                                theRetToken = this._returnToken;
                                break;
                            }
                            if (this.LA(1) == '|' && this.LA(2) == '|') {
                                this.mLOR(true);
                                theRetToken = this._returnToken;
                                break;
                            }
                            if (this.LA(1) == '&' && this.LA(2) == '=') {
                                this.mBAND_ASSIGN(true);
                                theRetToken = this._returnToken;
                                break;
                            }
                            if (this.LA(1) == '&' && this.LA(2) == '&') {
                                this.mLAND(true);
                                theRetToken = this._returnToken;
                                break;
                            }
                            if (this.LA(1) == '/' && this.LA(2) == '/') {
                                this.mCOMMENT(true);
                                theRetToken = this._returnToken;
                                break;
                            }
                            if (this.LA(1) == '/' && this.LA(2) == '*') {
                                this.mML_COMMENT(true);
                                theRetToken = this._returnToken;
                                break;
                            }
                            if (this.LA(1) == '=') {
                                this.mASSIGN(true);
                                theRetToken = this._returnToken;
                                break;
                            }
                            if (this.LA(1) == '!') {
                                this.mLNOT(true);
                                theRetToken = this._returnToken;
                                break;
                            }
                            if (this.LA(1) == '/') {
                                this.mDIV(true);
                                theRetToken = this._returnToken;
                                break;
                            }
                            if (this.LA(1) == '+') {
                                this.mPLUS(true);
                                theRetToken = this._returnToken;
                                break;
                            }
                            if (this.LA(1) == '-') {
                                this.mMINUS(true);
                                theRetToken = this._returnToken;
                                break;
                            }
                            if (this.LA(1) == '*') {
                                this.mSTAR(true);
                                theRetToken = this._returnToken;
                                break;
                            }
                            if (this.LA(1) == '%') {
                                this.mMOD(true);
                                theRetToken = this._returnToken;
                                break;
                            }
                            if (this.LA(1) == '>') {
                                this.mGT(true);
                                theRetToken = this._returnToken;
                                break;
                            }
                            if (this.LA(1) == '<') {
                                this.mLT(true);
                                theRetToken = this._returnToken;
                                break;
                            }
                            if (this.LA(1) == '^') {
                                this.mBXOR(true);
                                theRetToken = this._returnToken;
                                break;
                            }
                            if (this.LA(1) == '|') {
                                this.mBOR(true);
                                theRetToken = this._returnToken;
                                break;
                            }
                            if (this.LA(1) == '&') {
                                this.mBAND(true);
                                theRetToken = this._returnToken;
                                break;
                            }
                            if (this.LA(1) == '\uffff') {
                                this.uponEOF();
                                this._returnToken = this.makeToken(1);
                                break;
                            }
                            throw new NoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                        }
                    }
                    if (this._returnToken == null) continue;
                    _ttype = this._returnToken.getType();
                    this._returnToken.setType(_ttype);
                    return this._returnToken;
                }
                catch (RecognitionException e) {
                    this.reportError(e);
                    this.consume();
                }
            }
            catch (CharStreamException cse) {
                if (cse instanceof CharStreamIOException) {
                    throw new TokenStreamIOException(((CharStreamIOException)cse).io);
                }
                throw new TokenStreamException(cse.getMessage());
            }
        }
    }

    public final void mQUESTION(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 119;
        try {
            this.match('?');
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_0);
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mLPAREN(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 84;
        try {
            this.match('(');
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_0);
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mRPAREN(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 85;
        try {
            this.match(')');
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_0);
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mLBRACK(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 57;
        try {
            this.match('[');
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_0);
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mRBRACK(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 58;
        try {
            this.match(']');
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_0);
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mLCURLY(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 7;
        try {
            this.match('{');
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_0);
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mRCURLY(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 8;
        try {
            this.match('}');
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_0);
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mCOLON(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 91;
        try {
            this.match(':');
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_0);
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mCOMMA(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 82;
        try {
            this.match(',');
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_0);
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mASSIGN(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 89;
        try {
            this.match('=');
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_0);
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mEQUAL(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 126;
        try {
            this.match("==");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_0);
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mLNOT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 142;
        try {
            this.match('!');
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_0);
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mBNOT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 141;
        try {
            this.match('~');
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_0);
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mNOT_EQUAL(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 125;
        try {
            this.match("!=");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_0);
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mDIV(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 137;
        try {
            this.match('/');
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_0);
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mDIV_ASSIGN(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 111;
        try {
            this.match("/=");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_0);
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mPLUS(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 135;
        try {
            this.match('+');
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_0);
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mPLUS_ASSIGN(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 108;
        try {
            this.match("+=");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_0);
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mINC(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 139;
        try {
            this.match("++");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_0);
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mMINUS(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 136;
        try {
            this.match('-');
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_0);
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mMINUS_ASSIGN(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 109;
        try {
            this.match("-=");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_0);
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mDEC(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 140;
        try {
            this.match("--");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_0);
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mSTAR(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 70;
        try {
            this.match('*');
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_0);
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mSTAR_ASSIGN(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 110;
        try {
            this.match("*=");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_0);
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mMOD(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 138;
        try {
            this.match('%');
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_0);
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mMOD_ASSIGN(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 112;
        try {
            this.match("%=");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_0);
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mSR(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 133;
        try {
            this.match(">>");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_0);
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mSR_ASSIGN(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 113;
        try {
            this.match(">>=");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_0);
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mBSR(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 134;
        try {
            this.match(">>>");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_0);
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mBSR_ASSIGN(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 114;
        try {
            this.match(">>>=");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_0);
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mGE(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 130;
        try {
            this.match(">=");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_0);
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mGT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 128;
        try {
            this.match(">");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_0);
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mSL(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 132;
        try {
            this.match("<<");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_0);
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mSL_ASSIGN(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 115;
        try {
            this.match("<<=");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_0);
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mLE(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 129;
        try {
            this.match("<=");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_0);
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mLT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 127;
        try {
            this.match('<');
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_0);
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mBXOR(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 123;
        try {
            this.match('^');
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_0);
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mBXOR_ASSIGN(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 117;
        try {
            this.match("^=");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_0);
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mBOR(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 122;
        try {
            this.match('|');
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_0);
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mBOR_ASSIGN(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 118;
        try {
            this.match("|=");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_0);
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mLOR(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 120;
        try {
            this.match("||");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_0);
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mBAND(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 124;
        try {
            this.match('&');
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_0);
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mBAND_ASSIGN(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 116;
        try {
            this.match("&=");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_0);
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mLAND(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 121;
        try {
            this.match("&&");
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_0);
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mSEMI(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 55;
        try {
            this.match(';');
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_0);
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mWS(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        block20: {
            _token = null;
            _begin = this.text.length();
            _ttype = 153;
            try {
                int _cnt246 = 0;
                while (true) {
                    switch (this.LA(1)) {
                        case ' ': {
                            this.match(' ');
                            break;
                        }
                        case '\t': {
                            this.match('\t');
                            break;
                        }
                        case '\f': {
                            this.match('\f');
                            break;
                        }
                        case '\n': 
                        case '\r': {
                            if (this.LA(1) == '\r' && this.LA(2) == '\n') {
                                this.match("\r\n");
                                if (this._fileFormat == FileFormat.UNKNOWN) {
                                    this._fileFormat = FileFormat.DOS;
                                }
                                this._lineSeparator = "\r\n";
                            } else if (this.LA(1) == '\n') {
                                this.match('\n');
                                if (this._fileFormat == FileFormat.UNKNOWN) {
                                    this._fileFormat = FileFormat.UNIX;
                                }
                                this._lineSeparator = "\n";
                            } else if (this.LA(1) == '\r') {
                                this.match('\r');
                                if (this._fileFormat == FileFormat.UNKNOWN) {
                                    this._fileFormat = FileFormat.MAC;
                                }
                                this._lineSeparator = "\r";
                            } else {
                                throw new NoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                            }
                            this.newline();
                            break;
                        }
                        default: {
                            if (_cnt246 < 1) {
                                throw new NoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                            }
                            break block20;
                        }
                    }
                    ++_cnt246;
                }
            }
            catch (RecognitionException ex) {
                this.reportError(ex);
                this.consume();
                this.consumeUntil(_tokenSet_0);
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mSPECIAL_COMMENT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 154;
        int column = this.getColumn() - 1;
        try {
            this.match("//J-");
            while (this.LA(1) != '/' || this.LA(2) != '/' || this.LA(3) != 'J' || this.LA(4) != '+') {
                if (this.LA(1) == '\r' && this.LA(2) >= '\u0000' && this.LA(2) <= '\ufffe' && this.LA(3) >= '\u0000' && this.LA(3) <= '\ufffe' && this.LA(4) >= '\u0000' && this.LA(4) <= '\ufffe') {
                    this.match('\r');
                    if (this.LA(1) == '\n' && this.LA(2) >= '\u0000' && this.LA(2) <= '\ufffe' && this.LA(3) >= '\u0000' && this.LA(3) <= '\ufffe' && this.LA(4) >= '\u0000' && this.LA(4) <= '\ufffe') {
                        this.match('\n');
                    } else if (this.LA(1) < '\u0000' || this.LA(1) > '\ufffe' || this.LA(2) < '\u0000' || this.LA(2) > '\ufffe' || this.LA(3) < '\u0000' || this.LA(3) > '\ufffe' || this.LA(4) < '\u0000' || this.LA(4) > '\ufffe') {
                        throw new NoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                    }
                    this.newline();
                    continue;
                }
                if (this.LA(1) == '\n' && this.LA(2) >= '\u0000' && this.LA(2) <= '\ufffe' && this.LA(3) >= '\u0000' && this.LA(3) <= '\ufffe' && this.LA(4) >= '\u0000' && this.LA(4) <= '\ufffe') {
                    this.match('\n');
                    this.newline();
                    continue;
                }
                if (this.LA(1) < '\u0000' || this.LA(1) > '\ufffe' || this.LA(2) < '\u0000' || this.LA(2) > '\ufffe' || this.LA(3) < '\u0000' || this.LA(3) > '\ufffe' || this.LA(4) < '\u0000' || this.LA(4) > '\ufffe') break;
                this.matchNot('\uffff');
            }
            this.match("//J+");
            String t = new String(this.text.getBuffer(), _begin, this.text.length() - _begin);
            ExtendedToken tok = new ExtendedToken(154, StringHelper.leftPad(t, t.length() + column));
            _token = tok;
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_0);
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mSEPARATOR_COMMENT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 52;
        try {
            this.match("//~");
            while (_tokenSet_1.member(this.LA(1))) {
                this.match(_tokenSet_1);
                if (this.LA(1) != '\uffff') continue;
            }
            switch (this.LA(1)) {
                case '\n': {
                    int _saveIndex = this.text.length();
                    this.match('\n');
                    this.text.setLength(_saveIndex);
                    break;
                }
                case '\r': {
                    int _saveIndex = this.text.length();
                    this.match('\r');
                    this.text.setLength(_saveIndex);
                    if (this.LA(1) != '\n') break;
                    _saveIndex = this.text.length();
                    this.match('\n');
                    this.text.setLength(_saveIndex);
                    break;
                }
            }
            this.newline();
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_0);
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mSL_COMMENT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 155;
        try {
            this.match("//");
            while (_tokenSet_1.member(this.LA(1))) {
                this.match(_tokenSet_1);
                if (this.LA(1) != '\uffff') continue;
            }
            switch (this.LA(1)) {
                case '\n': {
                    int _saveIndex = this.text.length();
                    this.match('\n');
                    this.text.setLength(_saveIndex);
                    break;
                }
                case '\r': {
                    int _saveIndex = this.text.length();
                    this.match('\r');
                    this.text.setLength(_saveIndex);
                    if (this.LA(1) != '\n') break;
                    _saveIndex = this.text.length();
                    this.match('\n');
                    this.text.setLength(_saveIndex);
                    break;
                }
            }
            this.newline();
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_0);
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mCOMMENT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        block6: {
            _token = null;
            _begin = this.text.length();
            _ttype = 156;
            Token spec = null;
            Token sep = null;
            Token sl = null;
            try {
                if (this.LA(1) == '/' && this.LA(2) == '/' && this.LA(3) == 'J' && this.LA(4) == '-') {
                    this.mSPECIAL_COMMENT(true);
                    _token = spec = this._returnToken;
                    break block6;
                }
                if (this.LA(1) == '/' && this.LA(2) == '/' && this.LA(3) == '~') {
                    this.mSEPARATOR_COMMENT(true);
                    _token = sep = this._returnToken;
                    break block6;
                }
                if (this.LA(1) == '/' && this.LA(2) == '/') {
                    this.mSL_COMMENT(true);
                    _token = sl = this._returnToken;
                    break block6;
                }
                throw new NoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
            }
            catch (RecognitionException ex) {
                this.reportError(ex);
                this.consume();
                this.consumeUntil(_tokenSet_0);
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mML_COMMENT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        int _ttype;
        int _begin;
        Token _token;
        block20: {
            _token = null;
            _begin = this.text.length();
            _ttype = 157;
            int line = this.getLine();
            int column = this.getColumn();
            boolean javadoc = false;
            try {
                this.match("/*");
                if (this.LA(1) == '*') {
                    javadoc = true;
                }
                while (true) {
                    if (this.LA(1) == '\r' && this.LA(2) == '\n' && this.LA(3) >= '\u0000' && this.LA(3) <= '\ufffe' && this.LA(4) >= '\u0000' && this.LA(4) <= '\ufffe') {
                        this.match('\r');
                        this.match('\n');
                        this.newline();
                        continue;
                    }
                    if (this.LA(1) == '*' && this.LA(2) >= '\u0000' && this.LA(2) <= '\ufffe' && this.LA(3) >= '\u0000' && this.LA(3) <= '\ufffe' && this.LA(2) != '/') {
                        this.match('*');
                        continue;
                    }
                    if (this.LA(1) == '\r' && this.LA(2) >= '\u0000' && this.LA(2) <= '\ufffe' && this.LA(3) >= '\u0000' && this.LA(3) <= '\ufffe') {
                        this.match('\r');
                        this.newline();
                        continue;
                    }
                    if (this.LA(1) == '\n') {
                        this.match('\n');
                        this.newline();
                        continue;
                    }
                    if (!_tokenSet_2.member(this.LA(1))) break;
                    this.match(_tokenSet_2);
                }
                this.match("*/");
                if (javadoc) {
                    if (!this.removeJavadocComments) {
                        if (this.parseJavadocComments) {
                            try {
                                String t = new String(this.text.getBuffer(), _begin, this.text.length() - _begin);
                                this._recognizer.setLine(line);
                                this._recognizer.setColumn(column);
                                this._recognizer.parse(t, this.getFilename());
                                Node comment = (Node)this._recognizer.getParseTree();
                                if (comment != JavadocParser.EMPTY_JAVADOC_COMMENT) {
                                    ExtendedToken token = new ExtendedToken(6, t);
                                    token.comment = comment;
                                    _token = token;
                                }
                                break block20;
                            }
                            catch (IOException ex) {
                                throw new TokenStreamIOException(ex);
                            }
                        }
                        String t = new String(this.text.getBuffer(), _begin, this.text.length() - _begin);
                        if (t.indexOf(9) > -1) {
                            t = StringHelper.replace(t, "\t", StringHelper.repeat(SPACE, this.getTabSize()));
                        }
                        t = this.removeLeadingWhitespace(t, column - 1, this._lineSeparator);
                        this.text.setLength(_begin);
                        this.text.append(t);
                        _ttype = 6;
                        break block20;
                    }
                    _ttype = -1;
                    break block20;
                }
                if (!this.removeMLComments) {
                    String t = new String(this.text.getBuffer(), _begin, this.text.length() - _begin);
                    if (t.indexOf(9) > -1) {
                        t = StringHelper.replace(t, "\t", StringHelper.repeat(SPACE, this.getTabSize()));
                    }
                    if (!this.formatMLComments) {
                        t = this.removeLeadingWhitespace(t, column - 1, this._lineSeparator);
                    }
                    this.text.setLength(_begin);
                    this.text.append(t);
                } else {
                    _ttype = -1;
                }
            }
            catch (RecognitionException ex) {
                this.reportError(ex);
                this.consume();
                this.consumeUntil(_tokenSet_0);
            }
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mCHAR_LITERAL(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 148;
        try {
            this.match('\'');
            if (this.LA(1) == '\\') {
                this.mESC(false);
            } else if (_tokenSet_3.member(this.LA(1))) {
                this.matchNot('\'');
            } else {
                throw new NoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
            }
            this.match('\'');
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_0);
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mESC(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 158;
        try {
            this.match('\\');
            switch (this.LA(1)) {
                case 'n': {
                    this.match('n');
                    break;
                }
                case 'r': {
                    this.match('r');
                    break;
                }
                case 't': {
                    this.match('t');
                    break;
                }
                case 'b': {
                    this.match('b');
                    break;
                }
                case 'f': {
                    this.match('f');
                    break;
                }
                case '\"': {
                    this.match('\"');
                    break;
                }
                case '\'': {
                    this.match('\'');
                    break;
                }
                case '\\': {
                    this.match('\\');
                    break;
                }
                case 'u': {
                    int _cnt278 = 0;
                    while (true) {
                        if (this.LA(1) != 'u') {
                            if (_cnt278 >= 1) break;
                            throw new NoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                        }
                        this.match('u');
                        ++_cnt278;
                    }
                    this.mHEX_DIGIT(false);
                    this.mHEX_DIGIT(false);
                    this.mHEX_DIGIT(false);
                    this.mHEX_DIGIT(false);
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': {
                    this.matchRange('0', '3');
                    if (this.LA(1) >= '0' && this.LA(1) <= '7' && this.LA(2) >= '\u0000' && this.LA(2) <= '\ufffe') {
                        this.matchRange('0', '7');
                        if (this.LA(1) >= '0' && this.LA(1) <= '7' && this.LA(2) >= '\u0000' && this.LA(2) <= '\ufffe') {
                            this.matchRange('0', '7');
                            break;
                        }
                        if (this.LA(1) >= '\u0000' && this.LA(1) <= '\ufffe') break;
                        throw new NoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                    }
                    if (this.LA(1) >= '\u0000' && this.LA(1) <= '\ufffe') break;
                    throw new NoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                }
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    this.matchRange('4', '7');
                    if (this.LA(1) >= '0' && this.LA(1) <= '9' && this.LA(2) >= '\u0000' && this.LA(2) <= '\ufffe') {
                        this.matchRange('0', '9');
                        break;
                    }
                    if (this.LA(1) >= '\u0000' && this.LA(1) <= '\ufffe') break;
                    throw new NoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                }
                default: {
                    throw new NoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_4);
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mSTRING_LITERAL(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 149;
        try {
            this.match('\"');
            while (true) {
                if (this.LA(1) == '\\') {
                    this.mESC(false);
                    continue;
                }
                if (!_tokenSet_5.member(this.LA(1))) break;
                this.match(_tokenSet_5);
            }
            this.match('\"');
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_0);
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mHEX_DIGIT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 159;
        try {
            switch (this.LA(1)) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    this.matchRange('0', '9');
                    break;
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': {
                    this.matchRange('A', 'F');
                    break;
                }
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    this.matchRange('a', 'f');
                    break;
                }
                default: {
                    throw new NoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_4);
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mVOCAB(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 160;
        try {
            this.matchRange('\u0003', '\u00ff');
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_0);
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mIDENT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 68;
        try {
            switch (this.LA(1)) {
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': {
                    this.matchRange('a', 'z');
                    break;
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': {
                    this.matchRange('A', 'Z');
                    break;
                }
                case '_': {
                    this.match('_');
                    break;
                }
                case '$': {
                    this.match('$');
                    break;
                }
                case '\u00c0': 
                case '\u00c1': 
                case '\u00c2': 
                case '\u00c3': 
                case '\u00c4': 
                case '\u00c5': 
                case '\u00c6': 
                case '\u00c7': 
                case '\u00c8': 
                case '\u00c9': 
                case '\u00ca': 
                case '\u00cb': 
                case '\u00cc': 
                case '\u00cd': 
                case '\u00ce': 
                case '\u00cf': 
                case '\u00d0': 
                case '\u00d1': 
                case '\u00d2': 
                case '\u00d3': 
                case '\u00d4': 
                case '\u00d5': 
                case '\u00d6': {
                    this.matchRange('\u00c0', '\u00d6');
                    break;
                }
                case '\u00d8': 
                case '\u00d9': 
                case '\u00da': 
                case '\u00db': 
                case '\u00dc': 
                case '\u00dd': 
                case '\u00de': 
                case '\u00df': 
                case '\u00e0': 
                case '\u00e1': 
                case '\u00e2': 
                case '\u00e3': 
                case '\u00e4': 
                case '\u00e5': 
                case '\u00e6': 
                case '\u00e7': 
                case '\u00e8': 
                case '\u00e9': 
                case '\u00ea': 
                case '\u00eb': 
                case '\u00ec': 
                case '\u00ed': 
                case '\u00ee': 
                case '\u00ef': 
                case '\u00f0': 
                case '\u00f1': 
                case '\u00f2': 
                case '\u00f3': 
                case '\u00f4': 
                case '\u00f5': 
                case '\u00f6': {
                    this.matchRange('\u00d8', '\u00f6');
                    break;
                }
                case '\u00f8': 
                case '\u00f9': 
                case '\u00fa': 
                case '\u00fb': 
                case '\u00fc': 
                case '\u00fd': 
                case '\u00fe': 
                case '\u00ff': {
                    this.matchRange('\u00f8', '\u00ff');
                    break;
                }
                default: {
                    throw new NoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                }
            }
            block21: while (true) {
                switch (this.LA(1)) {
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': 
                    case 'g': 
                    case 'h': 
                    case 'i': 
                    case 'j': 
                    case 'k': 
                    case 'l': 
                    case 'm': 
                    case 'n': 
                    case 'o': 
                    case 'p': 
                    case 'q': 
                    case 'r': 
                    case 's': 
                    case 't': 
                    case 'u': 
                    case 'v': 
                    case 'w': 
                    case 'x': 
                    case 'y': 
                    case 'z': {
                        this.matchRange('a', 'z');
                        continue block21;
                    }
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'F': 
                    case 'G': 
                    case 'H': 
                    case 'I': 
                    case 'J': 
                    case 'K': 
                    case 'L': 
                    case 'M': 
                    case 'N': 
                    case 'O': 
                    case 'P': 
                    case 'Q': 
                    case 'R': 
                    case 'S': 
                    case 'T': 
                    case 'U': 
                    case 'V': 
                    case 'W': 
                    case 'X': 
                    case 'Y': 
                    case 'Z': {
                        this.matchRange('A', 'Z');
                        continue block21;
                    }
                    case '_': {
                        this.match('_');
                        continue block21;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        this.matchRange('0', '9');
                        continue block21;
                    }
                    case '$': {
                        this.match('$');
                        continue block21;
                    }
                    case '\u00c0': 
                    case '\u00c1': 
                    case '\u00c2': 
                    case '\u00c3': 
                    case '\u00c4': 
                    case '\u00c5': 
                    case '\u00c6': 
                    case '\u00c7': 
                    case '\u00c8': 
                    case '\u00c9': 
                    case '\u00ca': 
                    case '\u00cb': 
                    case '\u00cc': 
                    case '\u00cd': 
                    case '\u00ce': 
                    case '\u00cf': 
                    case '\u00d0': 
                    case '\u00d1': 
                    case '\u00d2': 
                    case '\u00d3': 
                    case '\u00d4': 
                    case '\u00d5': 
                    case '\u00d6': {
                        this.matchRange('\u00c0', '\u00d6');
                        continue block21;
                    }
                    case '\u00d8': 
                    case '\u00d9': 
                    case '\u00da': 
                    case '\u00db': 
                    case '\u00dc': 
                    case '\u00dd': 
                    case '\u00de': 
                    case '\u00df': 
                    case '\u00e0': 
                    case '\u00e1': 
                    case '\u00e2': 
                    case '\u00e3': 
                    case '\u00e4': 
                    case '\u00e5': 
                    case '\u00e6': 
                    case '\u00e7': 
                    case '\u00e8': 
                    case '\u00e9': 
                    case '\u00ea': 
                    case '\u00eb': 
                    case '\u00ec': 
                    case '\u00ed': 
                    case '\u00ee': 
                    case '\u00ef': 
                    case '\u00f0': 
                    case '\u00f1': 
                    case '\u00f2': 
                    case '\u00f3': 
                    case '\u00f4': 
                    case '\u00f5': 
                    case '\u00f6': {
                        this.matchRange('\u00d8', '\u00f6');
                        continue block21;
                    }
                    case '\u00f8': 
                    case '\u00f9': 
                    case '\u00fa': 
                    case '\u00fb': 
                    case '\u00fc': 
                    case '\u00fd': 
                    case '\u00fe': 
                    case '\u00ff': {
                        this.matchRange('\u00f8', '\u00ff');
                        continue block21;
                    }
                }
                break;
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_0);
        }
        _ttype = this.testLiteralsTable(_ttype);
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public final void mNUM_INT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 147;
        Token f1 = null;
        Token f2 = null;
        Token f3 = null;
        Token f4 = null;
        boolean isDecimal = false;
        Token t = null;
        try {
            switch (this.LA(1)) {
                case '.': {
                    this.match('.');
                    _ttype = 69;
                    if (this.LA(1) >= '0' && this.LA(1) <= '9') {
                        int _cnt296 = 0;
                        while (true) {
                            if (this.LA(1) < '0' || this.LA(1) > '9') {
                                if (_cnt296 >= 1) break;
                                throw new NoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                            }
                            this.matchRange('0', '9');
                            ++_cnt296;
                        }
                        if (this.LA(1) == 'E' || this.LA(1) == 'e') {
                            this.mEXPONENT(false);
                        }
                        if (_tokenSet_6.member(this.LA(1))) {
                            this.mFLOAT_SUFFIX(true);
                            t = f1 = this._returnToken;
                        }
                        if (t != null && t.getText().toUpperCase().indexOf(68) >= 0) {
                            _ttype = 152;
                            break;
                        }
                        _ttype = 150;
                    }
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    switch (this.LA(1)) {
                        case '0': {
                            this.match('0');
                            isDecimal = true;
                            block9 : switch (this.LA(1)) {
                                case 'X': 
                                case 'x': {
                                    switch (this.LA(1)) {
                                        case 'x': {
                                            this.match('x');
                                            break;
                                        }
                                        case 'X': {
                                            this.match('X');
                                            break;
                                        }
                                        default: {
                                            throw new NoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                                        }
                                    }
                                    int _cnt303 = 0;
                                    while (true) {
                                        if (!_tokenSet_7.member(this.LA(1))) {
                                            if (_cnt303 >= 1) break block9;
                                            throw new NoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                                        }
                                        this.mHEX_DIGIT(false);
                                        ++_cnt303;
                                    }
                                }
                                case '0': 
                                case '1': 
                                case '2': 
                                case '3': 
                                case '4': 
                                case '5': 
                                case '6': 
                                case '7': {
                                    int _cnt305 = 0;
                                    while (true) {
                                        if (this.LA(1) < '0' || this.LA(1) > '7') {
                                            if (_cnt305 >= 1) break block9;
                                            throw new NoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                                        }
                                        this.matchRange('0', '7');
                                        ++_cnt305;
                                    }
                                }
                            }
                            break;
                        }
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            this.matchRange('1', '9');
                            while (this.LA(1) >= '0' && this.LA(1) <= '9') {
                                this.matchRange('0', '9');
                            }
                            isDecimal = true;
                            break;
                        }
                        default: {
                            throw new NoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                        }
                    }
                    if (this.LA(1) == 'L' || this.LA(1) == 'l') {
                        switch (this.LA(1)) {
                            case 'l': {
                                this.match('l');
                                break;
                            }
                            case 'L': {
                                this.match('L');
                                break;
                            }
                            default: {
                                throw new NoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                            }
                        }
                        _ttype = 151;
                        break;
                    }
                    if (_tokenSet_8.member(this.LA(1)) && isDecimal) {
                        switch (this.LA(1)) {
                            case '.': {
                                this.match('.');
                                while (this.LA(1) >= '0' && this.LA(1) <= '9') {
                                    this.matchRange('0', '9');
                                }
                                if (this.LA(1) == 'E' || this.LA(1) == 'e') {
                                    this.mEXPONENT(false);
                                }
                                if (!_tokenSet_6.member(this.LA(1))) break;
                                this.mFLOAT_SUFFIX(true);
                                t = f2 = this._returnToken;
                                break;
                            }
                            case 'E': 
                            case 'e': {
                                this.mEXPONENT(false);
                                if (!_tokenSet_6.member(this.LA(1))) break;
                                this.mFLOAT_SUFFIX(true);
                                t = f3 = this._returnToken;
                                break;
                            }
                            case 'D': 
                            case 'F': 
                            case 'd': 
                            case 'f': {
                                this.mFLOAT_SUFFIX(true);
                                t = f4 = this._returnToken;
                                break;
                            }
                            default: {
                                throw new NoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                            }
                        }
                        if (t != null && t.getText().toUpperCase().indexOf(68) >= 0) {
                            _ttype = 152;
                            break;
                        }
                        _ttype = 150;
                    }
                    break;
                }
                default: {
                    throw new NoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_0);
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mEXPONENT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 161;
        try {
            switch (this.LA(1)) {
                case 'e': {
                    this.match('e');
                    break;
                }
                case 'E': {
                    this.match('E');
                    break;
                }
                default: {
                    throw new NoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                }
            }
            switch (this.LA(1)) {
                case '+': {
                    this.match('+');
                    break;
                }
                case '-': {
                    this.match('-');
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    break;
                }
                default: {
                    throw new NoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                }
            }
            int _cnt321 = 0;
            while (true) {
                if (this.LA(1) < '0' || this.LA(1) > '9') {
                    if (_cnt321 < 1) {
                        throw new NoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                    }
                    break;
                }
                this.matchRange('0', '9');
                ++_cnt321;
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_6);
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    protected final void mFLOAT_SUFFIX(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 162;
        try {
            switch (this.LA(1)) {
                case 'f': {
                    this.match('f');
                    break;
                }
                case 'F': {
                    this.match('F');
                    break;
                }
                case 'd': {
                    this.match('d');
                    break;
                }
                case 'D': {
                    this.match('D');
                    break;
                }
                default: {
                    throw new NoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_0);
        }
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    private static final long[] mk_tokenSet_0() {
        long[] data = new long[1025];
        for (int i = 0; i <= 1024; ++i) {
            data[i] = 0L;
        }
        return data;
    }

    private static final long[] mk_tokenSet_1() {
        int i;
        long[] data = new long[2048];
        data[0] = -9217L;
        for (i = 1; i <= 1022; ++i) {
            data[i] = -1L;
        }
        data[1023] = Long.MAX_VALUE;
        for (i = 1024; i <= 2047; ++i) {
            data[i] = 0L;
        }
        return data;
    }

    private static final long[] mk_tokenSet_2() {
        int i;
        long[] data = new long[2048];
        data[0] = -4398046520321L;
        for (i = 1; i <= 1022; ++i) {
            data[i] = -1L;
        }
        data[1023] = Long.MAX_VALUE;
        for (i = 1024; i <= 2047; ++i) {
            data[i] = 0L;
        }
        return data;
    }

    private static final long[] mk_tokenSet_3() {
        int i;
        long[] data = new long[2048];
        data[0] = -549755813889L;
        data[1] = -268435457L;
        for (i = 2; i <= 1022; ++i) {
            data[i] = -1L;
        }
        data[1023] = Long.MAX_VALUE;
        for (i = 1024; i <= 2047; ++i) {
            data[i] = 0L;
        }
        return data;
    }

    private static final long[] mk_tokenSet_4() {
        int i;
        long[] data = new long[2048];
        for (i = 0; i <= 1022; ++i) {
            data[i] = -1L;
        }
        data[1023] = Long.MAX_VALUE;
        for (i = 1024; i <= 2047; ++i) {
            data[i] = 0L;
        }
        return data;
    }

    private static final long[] mk_tokenSet_5() {
        int i;
        long[] data = new long[2048];
        data[0] = -17179869185L;
        data[1] = -268435457L;
        for (i = 2; i <= 1022; ++i) {
            data[i] = -1L;
        }
        data[1023] = Long.MAX_VALUE;
        for (i = 1024; i <= 2047; ++i) {
            data[i] = 0L;
        }
        return data;
    }

    private static final long[] mk_tokenSet_6() {
        long[] data = new long[1025];
        data[0] = 0L;
        data[1] = 0x5000000050L;
        for (int i = 2; i <= 1024; ++i) {
            data[i] = 0L;
        }
        return data;
    }

    private static final long[] mk_tokenSet_7() {
        long[] data = new long[1025];
        data[0] = 0x3FF000000000000L;
        data[1] = 0x7E0000007EL;
        for (int i = 2; i <= 1024; ++i) {
            data[i] = 0L;
        }
        return data;
    }

    private static final long[] mk_tokenSet_8() {
        long[] data = new long[1025];
        data[0] = 0x400000000000L;
        data[1] = 0x7000000070L;
        for (int i = 2; i <= 1024; ++i) {
            data[i] = 0L;
        }
        return data;
    }

    private static final class SeparatorInfo {
        int length = 1;
        int offset = -1;

        private SeparatorInfo() {
        }
    }
}

