/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.jyconsole.ui;

import com.artenum.jyconsole.CommandLine;
import com.artenum.jyconsole.JyConsole;
import com.artenum.jyconsole.util.ToolBox;
import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.AbstractListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CompletionWindow
extends JWindow
implements KeyListener,
ListSelectionListener {
    private JList list;
    private MethodeModel model;
    private JyConsole console;
    private JScrollPane scroll;
    private CommandLine cmdOrigine;
    private int maxHeight = -1;

    public CompletionWindow(JyConsole jyConsole) {
        super(ToolBox.getParentFrame(jyConsole));
        this.console = jyConsole;
        this.model = new MethodeModel();
        this.list = new JList(this.model);
        this.list.addListSelectionListener(this);
        this.scroll = new JScrollPane(this.list);
        this.getContentPane().add(this.scroll);
        this.setSize(300, 100);
        this.list.addKeyListener(this);
        this.list.getInputMap().clear();
        this.scroll.getInputMap().clear();
        this.maxHeight = (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight();
    }

    public MethodeModel getModel() {
        return this.model;
    }

    public void showWindow() {
        this.cmdOrigine = this.console.getCommandLine();
        this.setVisible(true);
        Point point = this.console.getInputComponent().getCaretPositionPoint();
        Component component = (Component)((Object)this.console.getInputComponent());
        for (component = component.getParent(); component != null; component = component.getParent()) {
            Point point2 = component.getLocation();
            point.translate(point2.x, point2.y);
        }
        point.x += this.console.getPromptWidth();
        if (point.y + this.getHeight() > this.maxHeight) {
            point.y = this.maxHeight - this.getHeight();
        }
        this.setLocation(point);
        this.list.setSelectedIndex(0);
    }

    private void selectMethodeWhichStartWith(String string) {
        this.model.setFilter(string);
        this.list.setSelectedIndex(0);
    }

    public void keyPressed(KeyEvent keyEvent) {
        CommandLine commandLine = this.console.getCommandLine();
        if (keyEvent.getKeyCode() == 10) {
            this.setVisible(false);
            String string = (String)this.list.getSelectedValue();
            if (this.cmdOrigine.askForDictionnary()) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.cmdOrigine.getTxtBefore());
                if (!this.cmdOrigine.getCompletionCommand().equals(this.cmdOrigine.getFilterCommand())) {
                    stringBuffer.append(this.cmdOrigine.getCompletionCommand());
                }
                stringBuffer.append(string);
                stringBuffer.append(this.cmdOrigine.getTxtAfter());
                this.console.updateCommandLine(stringBuffer.toString());
            } else if (string != null && string.toLowerCase().startsWith(commandLine.getFilterCommand().toLowerCase()) && !string.equals(commandLine.getFilterCommand())) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(commandLine.getTxtBefore());
                stringBuffer.append(commandLine.getCompletionCommand());
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(".");
                }
                if (string.indexOf("(") == -1 || string.endsWith("()")) {
                    stringBuffer.append(string);
                } else {
                    stringBuffer.append(string.substring(0, string.lastIndexOf("(") + 1));
                }
                stringBuffer.append(commandLine.getTxtAfter());
                this.console.updateCommandLine(stringBuffer.toString());
            }
            this.console.setFocusForInput();
        } else if (keyEvent.getKeyCode() == 27) {
            this.setVisible(false);
            this.console.setFocusForInput();
        } else if (keyEvent.getKeyCode() == 40) {
            if (this.model.getSize() > 0) {
                this.list.setSelectedIndex(this.list.getSelectedIndex() % this.model.getSize());
            }
        } else if (keyEvent.getKeyCode() == 38) {
            if (this.model.getSize() > 0) {
                this.list.setSelectedIndex((this.model.getSize() + this.list.getSelectedIndex()) % this.model.getSize());
            }
        } else if (keyEvent.getKeyCode() == 8) {
            if (commandLine.getFilterCommand().length() > 0) {
                StringBuffer stringBuffer = new StringBuffer(commandLine.getCommand()).deleteCharAt(commandLine.getCaretPosition() - 1);
                this.console.updateCommandLine(stringBuffer.toString());
                commandLine = this.console.getCommandLine();
                this.selectMethodeWhichStartWith(commandLine.getFilterCommand());
            } else {
                this.setVisible(false);
                this.console.setFocusForInput();
            }
        } else if (keyEvent.getKeyChar() != '\uffff') {
            this.console.getInputComponent().appendText("" + keyEvent.getKeyChar(), "style.default");
            commandLine = this.console.getCommandLine();
            this.selectMethodeWhichStartWith(commandLine.getFilterCommand());
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.list.ensureIndexIsVisible(this.list.getSelectedIndex());
    }

    public class MethodeModel
    extends AbstractListModel {
        private ArrayList data = new ArrayList();
        private ArrayList filteredData = new ArrayList();
        private String filter;

        public Object getElementAt(int n) {
            return this.filter != null ? this.filteredData.get(n) : this.data.get(n);
        }

        public int getSize() {
            return this.filter != null ? this.filteredData.size() : this.data.size();
        }

        public void setFilter(String string) {
            if (string == null || string != null && string.length() == 0) {
                this.filter = null;
            } else {
                this.filter = string;
                this.filteredData.clear();
                Iterator iterator = this.data.iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    if (!string2.toLowerCase().startsWith(string.toLowerCase())) continue;
                    this.filteredData.add(string2);
                }
            }
            this.fireContentsChanged(this, 0, this.getSize());
        }

        public void updateData(Collection collection) {
            Object[] objectArray = collection.toArray();
            Arrays.sort(objectArray);
            this.data.clear();
            for (int i = 0; i < objectArray.length; ++i) {
                this.data.add(objectArray[i].toString());
            }
            this.setFilter(null);
        }

        public void updateData(Method[] methodArray) {
            int n;
            this.data.clear();
            for (int i = 0; i < methodArray.length; ++i) {
                StringBuffer stringBuffer = new StringBuffer(methodArray[i].getName());
                stringBuffer.append("( ");
                for (n = 0; n < methodArray[i].getParameterTypes().length; ++n) {
                    stringBuffer.append(" ");
                    stringBuffer.append(methodArray[i].getParameterTypes()[n].getName());
                    stringBuffer.append(" ,");
                }
                this.data.add(stringBuffer.substring(0, stringBuffer.length() - 1) + ")");
            }
            Object[] objectArray = this.data.toArray();
            Arrays.sort(objectArray);
            this.data.clear();
            for (n = 0; n < objectArray.length; ++n) {
                this.data.add(objectArray[n]);
            }
            this.setFilter(null);
        }
    }
}

