/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import de.hunsicker.antlr.collections.AST;
import de.hunsicker.jalopy.printer.AbstractPrinter;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.Printer;
import de.hunsicker.jalopy.printer.PrinterFactory;
import de.hunsicker.jalopy.storage.ConventionKeys;
import java.io.IOException;

final class SynchronizedPrinter
extends AbstractPrinter {
    private static final Printer INSTANCE = new SynchronizedPrinter();

    protected SynchronizedPrinter() {
    }

    public static final Printer getInstance() {
        return INSTANCE;
    }

    public void print(AST node, NodeWriter out) throws IOException {
        this.printCommentsBefore(node, out);
        out.print("synchronized", 77);
        if (settings.getBoolean(ConventionKeys.SPACE_BEFORE_STATEMENT_PAREN, true)) {
            out.print(" ", 77);
        }
        AST lparen = node.getFirstChild();
        PrinterFactory.create(lparen).print(lparen, out);
        AST expr = lparen.getNextSibling();
        PrinterFactory.create(expr).print(expr, out);
        AST rparen = expr.getNextSibling();
        PrinterFactory.create(rparen).print(rparen, out);
        AST body = rparen.getNextSibling();
        PrinterFactory.create(body).print(body, out);
        out.last = 8;
    }
}

