/*
 * (c) Copyright: Artenum SARL, 101-103 Boulevard Mac Donald, 
 *                75019, Paris, France 2005.
 *                http://www.artenum.com
 *
 * License:
 *
 *  This program is free software; you can redistribute it 
 *  and/or modify it under the terms of the Q Public License; 
 *  either version 1 of the License.
 * 
 *  This program is distributed in the hope that it will be
 *  useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the Q Public License for more details.
 * 
 *  You should have received a copy of the Q Public License 
 *  License along with this program;
 *  if not, write to:
 *    Artenum SARL, 101-103 Boulevard Mac Donald,
 *    75019, PARIS, FRANCE, e-mail: contact@artenum.com
 */

package com.artenum.jyconsole;

import java.awt.Color;
import java.awt.Component;

import java.util.ArrayList;
import java.util.Iterator;

import javax.swing.JLabel;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

/**
 * <pre>
 * <b>Project ref           :</b> JyConsole project
 * <b>Copyright and license :</b> See relevant sections
 * <b>Status                :</b> under development
 * <b>Creation              :</b> 04/03/2005
 * <b>Modification          :</b>
 *
 * <b>Description  :</b> Manage the JyConsole Style
 *
 * </pre>
 * <table cellpadding="3" cellspacing="0" border="1" width="100%">
 * <tr BGCOLOR="#CCCCFF" CLASS="TableHeadingColor"><td><b>Version number</b></td><td><b>Author (name, e-mail)</b></td><td><b>Corrections/Modifications</b></td></tr>
 * <tr><td>0.1</td><td>Sebastien Jourdain, jourdain@artenum.com</td><td>Creation</td></tr>
 * </table>
 *
 * @author        Sebastien Jourdain
 * @version       0.1
 */
public class PreferenceManager {
    private ArrayList bgColorComponents;
    private ArrayList txtComponents;
    private JLabel prompt;

    public PreferenceManager() {
        bgColorComponents = new ArrayList();
        txtComponents = new ArrayList();
    }

    public void addBgColorComponent(Component c) {
        bgColorComponents.add(c);
    }

    public void addTxtDocument(StyledDocument sdoc) {
        txtComponents.add(sdoc);
    }

    public void setBgColor(Color c) {
        for (Iterator i = bgColorComponents.iterator(); i.hasNext();) {
            ((Component) i.next()).setBackground(c);
        }
    }

    public void setPrompt(JLabel prompt) {
        this.prompt = prompt;
    }

    public void setPromptTxt(String txt) {
        prompt.setText(txt);
    }

    public void setStyle(String styleName, boolean bold, boolean italic, Color color) {
        for (Iterator i = txtComponents.iterator(); i.hasNext();) {
            Style s = ((StyledDocument) i.next()).getStyle(styleName);
            StyleConstants.setItalic(s, italic);
            StyleConstants.setBold(s, bold);
            StyleConstants.setForeground(s, color);
        }
    }
}
