/*
 * (c) Copyright: Artenum SARL, 101-103 Boulevard Mac Donald, 
 *                75019, Paris, France 2005.
 *                http://www.artenum.com
 *
 * License:
 *
 *  This program is free software; you can redistribute it 
 *  and/or modify it under the terms of the Q Public License; 
 *  either version 1 of the License.
 * 
 *  This program is distributed in the hope that it will be
 *  useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the Q Public License for more details.
 * 
 *  You should have received a copy of the Q Public License 
 *  License along with this program;
 *  if not, write to:
 *    Artenum SARL, 101-103 Boulevard Mac Donald,
 *    75019, PARIS, FRANCE, e-mail: contact@artenum.com
 */

package com.artenum.jyconsole;

import java.awt.Point;

import javax.swing.BorderFactory;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyledDocument;

/**
 * <pre>
 * <b>Project ref           :</b> JyConsole project
 * <b>Copyright and license :</b> See relevant sections
 * <b>Status                :</b> under development
 * <b>Creation              :</b> 04/03/2005
 * <b>Modification          :</b>
 *
 * <b>Description  :</b> Implementation of the interface of the text components.
 *
 * </pre>
 * <table cellpadding="3" cellspacing="0" border="1" width="100%">
 * <tr BGCOLOR="#CCCCFF" CLASS="TableHeadingColor"><td><b>Version number</b></td><td><b>Author (name, e-mail)</b></td><td><b>Corrections/Modifications</b></td></tr>
 * <tr><td>0.1</td><td>Sebastien Jourdain, jourdain@artenum.com</td><td>Creation</td></tr>
 * </table>
 *
 * @author        Sebastien Jourdain
 * @version       0.1
 */
public class TextComponent extends JTextPane implements TextPrinter {
    private SimpleAttributeSet attr;
    private DefaultStyledDocument document;

    public TextComponent() {
        attr = new SimpleAttributeSet();
        document = new DefaultStyledDocument();
        setBorder(BorderFactory.createEmptyBorder());
        setDocument(document);
    }

    public void clearText() {
        this.setText("");
    }

    public void appendText(String txt, String styleName) {
        try {
            //super.append(txt);
            document.insertString(document.getLength(), txt, document.getStyle(styleName));
        } catch (BadLocationException e) {}
    }

    public Point getCaretPositionPoint() {
        Point p = new Point(0, 16);
        Point pc = getCaret().getMagicCaretPosition();
        if (pc != null) {
            p.x += pc.x;
            p.y += pc.y;
        }

        return p;
    }

    public StyledDocument getStyledDocument() {
        return document;
    }
}
