/*
 * (c) Copyright: Artenum SARL, 101-103 Boulevard Mac Donald, 
 *                75019, Paris, France 2005.
 *                http://www.artenum.com
 *
 * License:
 *
 *  This program is free software; you can redistribute it 
 *  and/or modify it under the terms of the Q Public License; 
 *  either version 1 of the License.
 * 
 *  This program is distributed in the hope that it will be
 *  useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the Q Public License for more details.
 * 
 *  You should have received a copy of the Q Public License 
 *  License along with this program;
 *  if not, write to:
 *    Artenum SARL, 101-103 Boulevard Mac Donald,
 *    75019, PARIS, FRANCE, e-mail: contact@artenum.com
 */

package com.artenum.jyconsole.action;

import com.artenum.jyconsole.CommandLine;
import com.artenum.jyconsole.JyConsole;
import com.artenum.jyconsole.ui.CompletionWindow;

import org.python.core.PyJavaInstance;
import org.python.core.PyList;
import org.python.core.PyString;

import java.awt.event.ActionEvent;

import java.lang.reflect.Method;

import java.util.ArrayList;

import javax.swing.AbstractAction;

/**
 * <pre>
 * <b>Project ref           :</b> JyConsole project
 * <b>Copyright and license :</b> See relevant sections
 * <b>Status                :</b> under development
 * <b>Creation              :</b> 04/03/2005
 * <b>Modification          :</b>
 *
 * <b>Description  :</b> Define the default Completion action. (ask for completion)
 *
 * </pre>
 * <table cellpadding="3" cellspacing="0" border="1" width="100%">
 * <tr BGCOLOR="#CCCCFF" CLASS="TableHeadingColor"><td><b>Version number</b></td><td><b>Author (name, e-mail)</b></td><td><b>Corrections/Modifications</b></td></tr>
 * <tr><td>0.1</td><td>Sebastien Jourdain, jourdain@artenum.com</td><td>Creation</td></tr>
 * </table>
 *
 * @author        Sebastien Jourdain
 * @version       0.1
 */
public class DefaultCompletionAction extends AbstractAction {
    private JyConsole console;
    private ArrayList duplicate;
    private CompletionWindow compWin;
    private CommandLine cmd;

    public DefaultCompletionAction(JyConsole console) {
        this.console = console;
        duplicate = new ArrayList();
    }

    private void initCompletionWindow() {
        compWin = new CompletionWindow(console);
    }

    public void actionPerformed(ActionEvent ae) {
        if (compWin == null) {
            initCompletionWindow();
        }

        cmd = console.getCommandLine();

        if (cmd.askForDictionnary()) {
            // build dictionnary
            console.getInterpreter().runsource("comp_tmp=dir()");
            PyList list = ((PyList) console.getInterpreter().get("comp_tmp"));
            list.sort();
            int length = list.__len__();
            ArrayList listJava = new ArrayList();
            for (int i = 0; i < length; i++) {
                listJava.add(((PyString) list.__getitem__(i)).toString());
            }

            compWin.getModel().updateData(listJava);
            compWin.getModel().setFilter(cmd.getFilterCommand());
            compWin.showWindow();
        } else {
            try {
                console.setSimulationFlag(true);
                // java completion
                String className;
                Method[] methodList;
                try {
                    console.getInterpreter().runsource("comp_tmp=" + cmd.getCompletionCommand());
                    className = ((PyJavaInstance) console.getInterpreter().get("comp_tmp")).__class__.__name__;
                    System.out.println(className);
                    methodList = Class.forName(className).getMethods();
                    compWin.getModel().updateData(methodList);
                    compWin.getModel().setFilter(cmd.getFilterCommand());
                } catch (ClassCastException castError) {
                    // build Python completion
                    console.getInterpreter().runsource("comp_tmp=dir(" + cmd.getCompletionCommand() + ")");
                    PyList list = ((PyList) console.getInterpreter().get("comp_tmp"));
                    list.sort();
                    int length = list.__len__();
                    ArrayList listJava = new ArrayList();
                    for (int i = 0; i < length; i++) {
                        listJava.add(((PyString) list.__getitem__(i)).toString());
                    }

                    compWin.getModel().updateData(listJava);
                    compWin.getModel().setFilter(cmd.getFilterCommand());
                } catch (Exception e1) {
                    e1.printStackTrace();
                }

                console.setSimulationFlag(false);
                compWin.showWindow();
            } catch (Exception e) {
                // Python completion
                console.getOutputComponent().appendText("\n>>> " + console.getInputComponent().getText(), JyConsole.STYLE_DEFAULT);
                console.getInterpreter().runsource("dir(" + cmd.getCompletionCommand() + ")");
            }
        }

        console.updateScrollPosition();
    }
}
