/*
 * (c) Copyright: Artenum SARL, 101-103 Boulevard Mac Donald, 
 *                75019, Paris, France 2005.
 *                http://www.artenum.com
 *
 * License:
 *
 *  This program is free software; you can redistribute it 
 *  and/or modify it under the terms of the Q Public License; 
 *  either version 1 of the License.
 * 
 *  This program is distributed in the hope that it will be
 *  useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the Q Public License for more details.
 * 
 *  You should have received a copy of the Q Public License 
 *  License along with this program;
 *  if not, write to:
 *    Artenum SARL, 101-103 Boulevard Mac Donald,
 *    75019, PARIS, FRANCE, e-mail: contact@artenum.com
 */

package com.artenum.jyconsole.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;

import javax.swing.JPanel;
import javax.swing.JViewport;

/**
 * <pre>
 * <b>Project ref           :</b> JyConsole project
 * <b>Copyright and license :</b> See relevant sections
 * <b>Status                :</b> under development
 * <b>Creation              :</b> 04/03/2005
 * <b>Modification          :</b>
 *
 * <b>Description  :</b> Graphical component with dynamic size in order
 *                  to remove the ugly gray block at the bottom of the console.
 *
 * </pre>
 * <table cellpadding="3" cellspacing="0" border="1" width="100%">
 * <tr BGCOLOR="#CCCCFF" CLASS="TableHeadingColor"><td><b>Version number</b></td><td><b>Author (name, e-mail)</b></td><td><b>Corrections/Modifications</b></td></tr>
 * <tr><td>0.1</td><td>Sebastien Jourdain, jourdain@artenum.com</td><td>Creation</td></tr>
 * </table>
 *
 * @author        Sebastien Jourdain
 * @version       0.1
 */
public class FillComponent extends JPanel {
    private JViewport viewPort;
    private Component[] components;

    public FillComponent(JViewport viewPort, Component[] components) {
        this.viewPort = viewPort;
        this.components = components;
        setOpaque(true);
        setBackground(Color.RED);
    }

    public Dimension getSize() {
        int maxHeight = (int) viewPort.getViewSize().getHeight();
        int compHeight = 0;
        for (int i = 0; i < components.length; i++) {
            compHeight += components[i].getHeight();
        }

        int result = maxHeight - compHeight;
        System.out.println(result);
        return new Dimension(50, 50);
    }

    public Dimension getPrefferedSize() {
        return getSize();
    }

    public Dimension getMaximumSize() {
        return getSize();
    }

    public Dimension getMinimumSize() {
        return getSize();
    }
}
