/*
 * (c) Copyright: Artenum SARL, 101-103 Boulevard Mac Donald, 
 *                75019, Paris, France 2005.
 *                http://www.artenum.com
 *
 * License:
 *
 *  This program is free software; you can redistribute it 
 *  and/or modify it under the terms of the Q Public License; 
 *  either version 1 of the License.
 * 
 *  This program is distributed in the hope that it will be
 *  useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the Q Public License for more details.
 * 
 *  You should have received a copy of the Q Public License 
 *  License along with this program;
 *  if not, write to:
 *    Artenum SARL, 101-103 Boulevard Mac Donald,
 *    75019, PARIS, FRANCE, e-mail: contact@artenum.com
 */

package com.artenum.jyconsole;

import java.util.ArrayList;

/**
 * <pre>
 * <b>Project ref           :</b> JyConsole project
 * <b>Copyright and license :</b> See relevant sections
 * <b>Status                :</b> under development
 * <b>Creation              :</b> 04/03/2005
 * <b>Modification          :</b>
 *
 * <b>Description  :</b> Interprete the command line in order to extract interessting information.
 *
 * </pre>
 * <table cellpadding="3" cellspacing="0" border="1" width="100%">
 * <tr BGCOLOR="#CCCCFF" CLASS="TableHeadingColor"><td><b>Version number</b></td><td><b>Author (name, e-mail)</b></td><td><b>Corrections/Modifications</b></td></tr>
 * <tr><td>0.1</td><td>Sebastien Jourdain, jourdain@artenum.com</td><td>Creation</td></tr>
 * </table>
 *
 * @author        Sebastien Jourdain
 * @version       0.1
 */
public class CommandLine {
    private int caretPosition = -1;
    private String command;
    private String completionCommand;
    private String filterCommand;
    private StringBuffer txtBefore;
    private String txtAfter;

    public CommandLine() {}

    public void updateData(int caretPos, String command) {
        this.caretPosition = caretPos;
        this.command = command;
        StringBuffer cmdLine = new StringBuffer(command);
        txtBefore = new StringBuffer();
        // Cut uninteresting part
        txtAfter = cmdLine.substring(caretPos);
        cmdLine.delete(caretPos, cmdLine.length());
        // Cut Line
        if (cmdLine.indexOf("\n") != -1) {
            txtBefore.append(cmdLine.substring(0, cmdLine.lastIndexOf("\n")));
            cmdLine.delete(0, cmdLine.lastIndexOf("\n"));
        }

        // Cut outter methodes
        ArrayList tree = new ArrayList();
        for (int i = 0; i < cmdLine.length(); i++) {
            if (cmdLine.charAt(i) == '(') {
                tree.add(new Integer(i));
            }

            if (cmdLine.charAt(i) == ')') {
                tree.remove(tree.size() - 1);
            }
        }

        if (tree.size() > 0) {
            txtBefore.append(cmdLine.substring(0, 1 + ((Integer) tree.get(tree.size() - 1)).intValue()));
            cmdLine.delete(0, 1 + ((Integer) tree.get(tree.size() - 1)).intValue());
        }

        if (cmdLine.indexOf(" ") != -1) {
            txtBefore.append(cmdLine.substring(0, cmdLine.lastIndexOf(" ") + 1));
            cmdLine.delete(0, cmdLine.lastIndexOf(" ") + 1);
        }

        completionCommand = cmdLine.toString();
        if (cmdLine.indexOf(".") != -1) {
            completionCommand = cmdLine.toString().substring(0, cmdLine.lastIndexOf("."));
            cmdLine.delete(0, cmdLine.lastIndexOf(".") + 1);
        }

        filterCommand = cmdLine.toString();
    }

    public int getCaretPosition() {
        return caretPosition;
    }

    public void setCaretPosition(int caretPosition) {
        this.caretPosition = caretPosition;
    }

    public String getCommand() {
        return command;
    }

    public void setCommand(String command) {
        this.command = command;
        // update other commands
    }

    public String getCompletionCommand() {
        return completionCommand;
    }

    public void setCompletionCommand(String completionCommand) {
        this.completionCommand = completionCommand;
    }

    public String getFilterCommand() {
        return filterCommand;
    }

    public void setFilterCommand(String filterCommand) {
        this.filterCommand = filterCommand;
    }

    public boolean askForDictionnary() {
        return (completionCommand.length() == 0) || (completionCommand.equals(filterCommand));
    }

    public boolean isCompletionSimple() {
        return filterCommand.length() == 0;
    }

    public boolean isCompletionWithFiltering() {
        return filterCommand.length() > 0;
    }

    public String toString() {
        StringBuffer toString = new StringBuffer();
        toString.append("Command: ");
        toString.append(command);
        toString.append("\nCaret: ");
        toString.append(caretPosition);
        toString.append("\nCompletion on: ");
        toString.append(completionCommand);
        toString.append("\nFilter on: ");
        toString.append(filterCommand);
        toString.append("\nBefore: ");
        toString.append(txtBefore);
        toString.append("\nAfter on: ");
        toString.append(txtAfter);
        toString.append("\nAskForDico: ");
        toString.append(askForDictionnary());
        return toString.toString();
    }

    public String getTxtAfter() {
        return txtAfter;
    }

    public StringBuffer getTxtBefore() {
        return txtBefore;
    }
}
