/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.language;

import de.hunsicker.antlr.RecognitionException;
import de.hunsicker.antlr.TokenBuffer;
import de.hunsicker.antlr.TokenStreamException;
import de.hunsicker.antlr.TokenStreamHiddenTokenFilter;
import de.hunsicker.antlr.TokenStreamRecognitionException;
import de.hunsicker.antlr.collections.AST;
import de.hunsicker.jalopy.language.Annotation;
import de.hunsicker.jalopy.language.ImportTransformation;
import de.hunsicker.jalopy.language.JavaLexer;
import de.hunsicker.jalopy.language.JavaNode;
import de.hunsicker.jalopy.language.JavaParser;
import de.hunsicker.jalopy.language.JavadocParser;
import de.hunsicker.jalopy.language.LoggerTransformation;
import de.hunsicker.jalopy.language.Position;
import de.hunsicker.jalopy.language.Recognizer;
import de.hunsicker.jalopy.language.SerializableTransformation;
import de.hunsicker.jalopy.language.SortTransformation;
import de.hunsicker.jalopy.language.Transformation;
import de.hunsicker.jalopy.language.TransformationException;
import de.hunsicker.jalopy.language.TreeWalker;
import de.hunsicker.jalopy.storage.Convention;
import de.hunsicker.jalopy.storage.ConventionDefaults;
import de.hunsicker.jalopy.storage.ConventionKeys;
import de.hunsicker.jalopy.storage.Loggers;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;

public final class JavaRecognizer
extends Recognizer {
    private static final String DELIMETER = "|";
    public static final int JDK_1_3 = 13;
    public static final int JDK_1_4 = 14;
    private Convention _settings;
    private List _annotations = Collections.EMPTY_LIST;
    private Position _position;
    private Transformation _importTrans;
    private Transformation _loggingTransformation;
    private Transformation _serialTrans;
    private Transformation _sortTrans;
    private boolean _trackPosition;
    private boolean _transformed;

    public JavaRecognizer() {
        this._settings = Convention.getInstance();
        JavaLexer l = new JavaLexer();
        this.lexer = l;
        JavaParser p = (JavaParser)l.getParser();
        this.parser = p;
        this._importTrans = new ImportTransformation(p.getQualifiedIdents(), p.getUnqualifiedIdents());
        this._sortTrans = new SortTransformation();
        this._serialTrans = new SerializableTransformation();
        this._loggingTransformation = new LoggerTransformation();
    }

    public String getPackageName() {
        if (!this.finished) {
            throw new IllegalStateException("parser not started or still running");
        }
        return ((JavaParser)this.parser).getPackageName();
    }

    public AST getParseTree() {
        if (!this.finished) {
            throw new IllegalStateException("parser not started or still running");
        }
        if (!this._transformed) {
            boolean trackAnnotations;
            boolean bl = trackAnnotations = !this._annotations.isEmpty();
            if (this._trackPosition || trackAnnotations) {
                PositionTracker tracker = new PositionTracker();
                if (trackAnnotations) {
                    tracker.annotation = (Annotation)this._annotations.get(0);
                }
                tracker.walk(super.getParseTree());
            }
            this.transform();
            this._transformed = true;
        }
        return super.getParseTree();
    }

    public void setPosition(int line, int column) {
        if (line < 1) {
            throw new IllegalArgumentException("line < 1 -- " + line);
        }
        if (column < 1) {
            throw new IllegalArgumentException("column < 1 -- " + column);
        }
        this._trackPosition = true;
        this._position = new Position(line, column);
    }

    public Position getPosition() {
        return this._position;
    }

    public void attachAnnotations(List annotations) {
        this._annotations = annotations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List detachAnnotations() {
        try {
            List list = this._annotations;
            return list;
        }
        finally {
            if (this._annotations != Collections.EMPTY_LIST) {
                this._annotations = Collections.EMPTY_LIST;
            }
        }
    }

    public boolean hasAnnotations() {
        return !this._annotations.isEmpty();
    }

    public boolean hasPosition() {
        return this._position != null;
    }

    public void parse(Reader in, String filename) {
        if (this.running) {
            throw new IllegalStateException("parser currently running");
        }
        this.finished = false;
        this.running = true;
        this._transformed = false;
        JavaParser parser = (JavaParser)this.parser;
        parser.stripQualification = this._settings.getBoolean(ConventionKeys.STRIP_QUALIFICATION, false);
        JavaLexer lexer = (JavaLexer)this.lexer;
        lexer.setTabSize(this._settings.getInt(ConventionKeys.INDENT_SIZE_TABS, 8));
        lexer.sourceVersion = this._settings.getInt(ConventionKeys.SOURCE_VERSION, 14);
        lexer.parseJavadocComments = this._settings.getBoolean(ConventionKeys.COMMENT_JAVADOC_PARSE, false);
        lexer.removeJavadocComments = this._settings.getBoolean(ConventionKeys.COMMENT_JAVADOC_REMOVE, false);
        lexer.removeSLComments = this._settings.getBoolean(ConventionKeys.COMMENT_REMOVE_SINGLE_LINE, false);
        lexer.removeMLComments = this._settings.getBoolean(ConventionKeys.COMMENT_REMOVE_MULTI_LINE, false);
        lexer.formatMLComments = this._settings.getBoolean(ConventionKeys.COMMENT_FORMAT_MULTI_LINE, false);
        JavadocParser javadocParser = lexer.getJavadocParser();
        javadocParser.setCustomStandardTags(this.decodeTags(this._settings.get(ConventionKeys.COMMENT_JAVADOC_TAGS_STANDARD, ConventionDefaults.COMMENT_JAVADOC_TAGS_STANDARD)));
        javadocParser.setCustomInlineTags(this.decodeTags(this._settings.get(ConventionKeys.COMMENT_JAVADOC_TAGS_INLINE, ConventionDefaults.COMMENT_JAVADOC_TAGS_INLINE)));
        this.lexer.setInputBuffer(in);
        TokenStreamHiddenTokenFilter filter = new TokenStreamHiddenTokenFilter(this.lexer);
        filter.discard(153);
        filter.discard(52);
        filter.hide(6);
        filter.hide(157);
        filter.hide(154);
        filter.hide(155);
        this.lexer.setFilename(filename);
        this.parser.setFilename(filename);
        this.parser.setTokenBuffer(new TokenBuffer(filter));
        try {
            this.parser.parse();
        }
        catch (RecognitionException ex) {
            throw new Recognizer.ParseException(ex);
        }
        catch (TokenStreamRecognitionException ex) {
            throw new Recognizer.ParseException(ex);
        }
        catch (TokenStreamException ex) {
            throw new Recognizer.ParseException(ex);
        }
        finally {
            this.finished = true;
            this.running = false;
        }
    }

    private Collection decodeTags(String tags) {
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer i = new StringTokenizer(tags, DELIMETER);
        while (i.hasMoreElements()) {
            result.add(i.nextToken());
        }
        return result;
    }

    private void transform() {
        AST tree = this.parser.getParseTree();
        if (tree != null) {
            try {
                this._importTrans.apply(tree);
                if (this._settings.getBoolean(ConventionKeys.INSERT_SERIAL_UID, false)) {
                    this._serialTrans.apply(tree);
                }
                if (this._settings.getBoolean(ConventionKeys.SORT, true)) {
                    this._sortTrans.apply(tree);
                }
                if (this._settings.getBoolean(ConventionKeys.INSERT_LOGGING_CONDITIONAL, false)) {
                    this._loggingTransformation.apply(tree);
                }
            }
            catch (TransformationException ex) {
                Object[] args = new Object[]{this.parser.getFilename()};
                Loggers.IO.l7dlog((Priority)Level.ERROR, "TRANS_ERROR", args, (Throwable)ex);
            }
        }
    }

    private final class PositionTracker
    extends TreeWalker {
        Annotation annotation;
        int index;

        private PositionTracker() {
        }

        public void visit(AST node) {
            switch (node.getType()) {
                case 9: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 46: 
                case 47: 
                case 50: 
                case 57: 
                case 58: 
                case 69: 
                case 84: 
                case 85: 
                case 89: 
                case 91: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: 
                case 128: 
                case 129: 
                case 130: 
                case 131: 
                case 132: 
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 137: 
                case 138: 
                case 139: 
                case 140: 
                case 141: 
                case 142: 
                case 146: {
                    return;
                }
            }
            JavaNode n = (JavaNode)node;
            if (this.annotation != null && n.getStartLine() == this.annotation.getLine()) {
                n.attachAnnotation(this.annotation);
                ++this.index;
                if (JavaRecognizer.this._annotations.size() > this.index) {
                    this.annotation = (Annotation)JavaRecognizer.this._annotations.get(this.index);
                } else {
                    this.annotation = null;
                    if (!JavaRecognizer.this._trackPosition) {
                        this.stop();
                    }
                }
            }
            if (JavaRecognizer.this._trackPosition) {
                int line = n.getStartLine();
                if (line == ((JavaRecognizer)JavaRecognizer.this)._position.line) {
                    n.setPosition(JavaRecognizer.this._position);
                    JavaRecognizer.this._trackPosition = false;
                    if (this.annotation == null) {
                        this.stop();
                    }
                } else if (line > ((JavaRecognizer)JavaRecognizer.this)._position.line) {
                    n.setPosition(JavaRecognizer.this._position);
                    JavaRecognizer.this._trackPosition = false;
                    if (this.annotation == null) {
                        this.stop();
                    }
                }
            }
        }
    }
}

