/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.language;

import de.hunsicker.antlr.CommonHiddenStreamToken;
import de.hunsicker.antlr.collections.AST;
import de.hunsicker.jalopy.language.DeclarationType;
import de.hunsicker.jalopy.language.ExtendedToken;
import de.hunsicker.jalopy.language.JavaNode;
import de.hunsicker.jalopy.language.JavaNodeHelper;
import de.hunsicker.jalopy.language.JavaNodeModifier;
import de.hunsicker.jalopy.language.NodeComparator;
import de.hunsicker.jalopy.language.Transformation;
import de.hunsicker.jalopy.language.TransformationException;
import de.hunsicker.jalopy.language.VariableDefNodeComparator;
import de.hunsicker.jalopy.storage.Convention;
import de.hunsicker.jalopy.storage.ConventionKeys;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;

final class SortTransformation
implements Transformation {
    private static final String EMPTY_STRING = "".intern();
    private final NodeComparator _defaultComparator = new NodeComparator();
    private final VariableDefNodeComparator _variablesComparator = new VariableDefNodeComparator();

    public void apply(AST tree) throws TransformationException {
        this.sort(tree, this._defaultComparator);
    }

    public void sort(AST tree, Comparator comp) {
        if (tree == null) {
            return;
        }
        AST first = null;
        block3: for (AST child = tree.getFirstChild(); child != null; child = child.getNextSibling()) {
            switch (child.getType()) {
                case 18: 
                case 19: {
                    first = child;
                    break block3;
                }
                default: {
                    continue block3;
                }
            }
        }
        for (AST declaration = first; declaration != null; declaration = declaration.getNextSibling()) {
            this.sortDeclarations(declaration, comp, 1);
        }
    }

    private boolean isStatic(AST node) {
        return JavaNodeModifier.isStatic(JavaNodeHelper.getFirstChild(node, 9));
    }

    private void addChild(JavaNode node, JavaNode sibling) {
        node.setNextSibling(sibling);
        sibling.prevSibling = node;
        sibling.setNextSibling(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private JavaNode addSiblings(List nodes, JavaNode node, boolean addSeparator, int indent, int maxwidth) {
        JavaNode cur = node;
        if (nodes.size() <= 0) return node;
        JavaNode next = (JavaNode)nodes.get(0);
        this.addChild(cur, next);
        cur = next;
        if (addSeparator) {
            ExtendedToken comment = new ExtendedToken(52, EMPTY_STRING);
            if (next.hasCommentsBefore()) {
                for (CommonHiddenStreamToken tok = next.getHiddenBefore(); tok != null; tok = tok.getHiddenBefore()) {
                    if (tok.getHiddenBefore() != null) continue;
                    tok.setHiddenBefore(comment);
                    comment.setHiddenAfter(tok);
                    break;
                }
            } else {
                next.setHiddenBefore(comment);
            }
            Convention settings = Convention.getInstance();
            String fillCharacter = settings.get(ConventionKeys.SEPARATOR_FILL_CHARACTER, "\u00b7");
            switch (next.getType()) {
                case 14: {
                    if (this.isStatic(cur)) {
                        this.fillComment(comment, settings.get(ConventionKeys.SEPARATOR_STATIC_VAR_INIT, "Static variables/initializers"), fillCharacter, indent, maxwidth);
                        break;
                    }
                    this.fillComment(comment, settings.get(ConventionKeys.SEPARATOR_INSTANCE_VAR, "Instance variables"), fillCharacter, indent, maxwidth);
                    break;
                }
                case 13: {
                    this.fillComment(comment, settings.get(ConventionKeys.SEPARATOR_METHOD, "Methods"), fillCharacter, indent, maxwidth);
                    break;
                }
                case 12: {
                    this.fillComment(comment, settings.get(ConventionKeys.SEPARATOR_CTOR, "Constructors"), fillCharacter, indent, maxwidth);
                    break;
                }
                case 18: {
                    this.fillComment(comment, settings.get(ConventionKeys.SEPARATOR_CLASS, "Inner classes"), fillCharacter, indent, maxwidth);
                    break;
                }
                case 19: {
                    this.fillComment(comment, settings.get(ConventionKeys.SEPARATOR_INTERFACE, "Inner Interfaces"), fillCharacter, indent, maxwidth);
                    break;
                }
                case 16: {
                    this.fillComment(comment, settings.get(ConventionKeys.SEPARATOR_STATIC_VAR_INIT, "Static variables/initializers"), fillCharacter, indent, maxwidth);
                    break;
                }
                case 15: {
                    this.fillComment(comment, settings.get(ConventionKeys.SEPARATOR_INSTANCE_INIT, "Instance initializers"), fillCharacter, indent, maxwidth);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unexpected type -- " + cur);
                }
            }
        }
        int size = nodes.size();
        for (int i = 1; i < size; ++i) {
            JavaNode next2 = (JavaNode)nodes.get(i);
            this.addChild(cur, next2);
            cur = next2;
        }
        return cur;
    }

    private void fillComment(ExtendedToken comment, String text, String character, int indent, int maxwidth) {
        StringBuffer buf = new StringBuffer(maxwidth);
        buf.append("//~ ");
        buf.append(text);
        buf.append(' ');
        int size = maxwidth - indent - 1;
        for (int i = text.length() + 4; i < size; ++i) {
            buf.append(character);
        }
        comment.setText(buf.toString());
    }

    private AST sortDeclarations(AST node, Comparator comp, int level) {
        JavaNode tmp;
        JavaNode lcurly = null;
        switch (node.getType()) {
            case 18: {
                lcurly = (JavaNode)node.getFirstChild().getNextSibling().getNextSibling().getNextSibling().getNextSibling().getNextSibling();
                break;
            }
            case 19: {
                lcurly = (JavaNode)node.getFirstChild().getNextSibling().getNextSibling().getNextSibling().getNextSibling();
                break;
            }
            default: {
                return node;
            }
        }
        switch (lcurly.getFirstChild().getType()) {
            case 8: {
                return node;
            }
        }
        ArrayList<AST> staticStuff = new ArrayList<AST>(3);
        ArrayList<AST> variables = new ArrayList<AST>();
        ArrayList<AST> initializers = new ArrayList<AST>(3);
        ArrayList<AST> ctors = new ArrayList<AST>(5);
        ArrayList<AST> methods = new ArrayList<AST>();
        ArrayList<AST> classes = new ArrayList<AST>(3);
        ArrayList<AST> interfaces = new ArrayList<AST>(3);
        ArrayList<String> names = new ArrayList<String>();
        AST rcurly = null;
        block18: for (AST child = lcurly.getFirstChild(); child != null; child = child.getNextSibling()) {
            switch (child.getType()) {
                case 13: {
                    methods.add(child);
                    continue block18;
                }
                case 14: {
                    if (this.isStatic(child)) {
                        staticStuff.add(child);
                        continue block18;
                    }
                    names.add(JavaNodeHelper.getFirstChild(child, 68).getText());
                    variables.add(child);
                    continue block18;
                }
                case 12: {
                    ctors.add(child);
                    continue block18;
                }
                case 16: {
                    staticStuff.add(child);
                    continue block18;
                }
                case 15: {
                    initializers.add(child);
                    continue block18;
                }
                case 18: {
                    classes.add(this.sortDeclarations(child, comp, level + 1));
                    continue block18;
                }
                case 19: {
                    interfaces.add(this.sortDeclarations(child, comp, level + 1));
                    continue block18;
                }
                case 8: {
                    rcurly = child;
                    continue block18;
                }
                case 55: {
                    continue block18;
                }
                default: {
                    throw new IllegalArgumentException("cannot handle node -- " + child);
                }
            }
        }
        Convention settings = Convention.getInstance();
        if (settings.getBoolean(ConventionKeys.SORT_VARIABLE, false)) {
            this._variablesComparator.names = names;
            Collections.sort(variables, this._variablesComparator);
            names.clear();
        }
        if (settings.getBoolean(ConventionKeys.SORT_CTOR, false)) {
            Collections.sort(ctors, comp);
        }
        if (settings.getBoolean(ConventionKeys.SORT_METHOD, false)) {
            Collections.sort(methods, comp);
        }
        if (settings.getBoolean(ConventionKeys.SORT_CLASS, false)) {
            Collections.sort(classes, comp);
        }
        if (settings.getBoolean(ConventionKeys.SORT_INTERFACE, false)) {
            Collections.sort(interfaces, comp);
        }
        HashMap<String, ArrayList<AST>> nodes = new HashMap<String, ArrayList<AST>>(8, 1.0f);
        nodes.put(DeclarationType.STATIC_VARIABLE_INIT.getName(), staticStuff);
        nodes.put(DeclarationType.VARIABLE.getName(), variables);
        nodes.put(DeclarationType.INIT.getName(), initializers);
        nodes.put(DeclarationType.CTOR.getName(), ctors);
        nodes.put(DeclarationType.METHOD.getName(), methods);
        nodes.put(DeclarationType.INTERFACE.getName(), interfaces);
        nodes.put(DeclarationType.CLASS.getName(), classes);
        boolean addSeparator = false;
        addSeparator = level == 1 ? settings.getBoolean(ConventionKeys.COMMENT_INSERT_SEPARATOR, false) : settings.getBoolean(ConventionKeys.COMMENT_INSERT_SEPARATOR_RECURSIVE, false);
        String sortString = settings.get(ConventionKeys.SORT_ORDER, DeclarationType.getOrder());
        int maxwidth = settings.getInt(ConventionKeys.LINE_LENGTH, 80);
        int indent = settings.getInt(ConventionKeys.INDENT_SIZE, 4);
        JavaNode current = tmp = new JavaNode();
        StringTokenizer tokens = new StringTokenizer(sortString, "|");
        while (tokens.hasMoreTokens()) {
            current = this.addSiblings((List)nodes.get(tokens.nextToken()), current, addSeparator, indent * level, maxwidth);
        }
        current.setNextSibling(rcurly);
        JavaNode sibling = (JavaNode)tmp.getNextSibling();
        sibling.prevSibling = lcurly;
        lcurly.setFirstChild(sibling);
        tmp.setNextSibling(null);
        current.setNextSibling(rcurly);
        return node;
    }
}

