/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import de.hunsicker.antlr.collections.AST;
import de.hunsicker.jalopy.language.JavaNode;
import de.hunsicker.jalopy.printer.Marker;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.OperatorPrinter;
import de.hunsicker.jalopy.printer.PrinterFactory;
import de.hunsicker.jalopy.printer.TestNodeWriter;
import de.hunsicker.jalopy.storage.ConventionKeys;
import java.io.IOException;

final class AssignmentPrinter
extends OperatorPrinter {
    static final int OFFSET_NONE = -1;
    private static final AssignmentPrinter INSTANCE = new AssignmentPrinter();

    private AssignmentPrinter() {
    }

    public static AssignmentPrinter getInstance() {
        return INSTANCE;
    }

    public void print(AST node, NodeWriter out) throws IOException {
        this.print(node, false, out);
    }

    public void print(AST node, boolean wrapAfterAssign, NodeWriter out) throws IOException {
        this.logIssues(node, out);
        this.printCommentsBefore(node, out);
        boolean wrapLines = settings.getBoolean(ConventionKeys.LINE_WRAP, true) && out.mode == 1;
        boolean preferWrapAfterLeftParen = settings.getBoolean(ConventionKeys.LINE_WRAP_AFTER_LEFT_PAREN, false);
        boolean preferWrapAfterAssign = settings.getBoolean(ConventionKeys.LINE_WRAP_AFTER_ASSIGN, false);
        boolean padding = settings.getBoolean(ConventionKeys.PADDING_ASSIGNMENT_OPERATORS, true);
        int lineLength = settings.getInt(ConventionKeys.LINE_LENGTH, 80);
        boolean indentStandard = !settings.getBoolean(ConventionKeys.INDENT_DEEP, false);
        AST expr = node.getFirstChild();
        if (this.isPartOfDeclaration(node)) {
            if (wrapLines) {
                boolean indent;
                JavaNode parent = ((JavaNode)node).getParent();
                if (!wrapAfterAssign) {
                    if (settings.getBoolean(ConventionKeys.ALIGN_VAR_ASSIGNS, false)) {
                        if (this.isNewChunk(parent, 14)) {
                            out.state.assignOffset = -1;
                        }
                        this.alignAssignment(node, true, out);
                    }
                }
                boolean bl = indent = indentStandard || wrapAfterAssign || preferWrapAfterAssign || preferWrapAfterLeftParen;
                if (indent) {
                    out.indent();
                }
                Marker marker = null;
                if (wrapAfterAssign) {
                    if (padding) {
                        out.print(" =", 89);
                    } else {
                        out.print("=", 89);
                    }
                    if (!this.printCommentsAfter(node, false, true, out)) {
                        out.printNewline();
                    }
                    this.printIndentation(out);
                    marker = out.state.markers.add();
                    PrinterFactory.create(expr).print(expr, out);
                } else if (wrapLines) {
                    TestNodeWriter tester = out.testers.get();
                    PrinterFactory.create(expr).print(expr, tester);
                    if (preferWrapAfterAssign && tester.length + out.column + (padding ? 3 : 1) > lineLength) {
                        if (padding) {
                            out.print(" =", 89);
                        } else {
                            out.print("=", 89);
                        }
                        if (!this.printCommentsAfter(node, false, true, out)) {
                            out.printNewline();
                        }
                        this.printIndentation(out);
                    } else if (indentStandard) {
                        if (out.column > lineLength) {
                            if (padding) {
                                out.print(" =", 89);
                            } else {
                                out.print("=", 89);
                            }
                            if (!this.printCommentsAfter(node, false, true, out)) {
                                out.printNewline();
                            }
                            this.printIndentation(out);
                        } else {
                            if (padding) {
                                out.print(" = ", 89);
                            } else {
                                out.print("=", 89);
                            }
                            this.printCommentsAfter(node, false, false, out);
                            if (out.newline) {
                                this.printIndentation(out);
                            }
                        }
                    } else if (padding) {
                        marker = out.state.markers.add(out.line, out.column + 2);
                        out.print(" = ", 89);
                        this.printCommentsAfter(node, false, false, out);
                        if (out.newline) {
                            this.printIndentation(out);
                        }
                    } else {
                        out.print("=", 89);
                        out.state.markers.add();
                        this.printCommentsAfter(node, false, false, out);
                        if (out.newline) {
                            this.printIndentation(out);
                        }
                    }
                    PrinterFactory.create(expr).print(expr, out);
                    out.testers.release(tester);
                    if (marker != null) {
                        out.state.markers.remove(marker);
                    }
                } else {
                    if (padding) {
                        out.print(" = ", 89);
                    } else {
                        out.print("=", 89);
                    }
                    PrinterFactory.create(expr).print(expr, out);
                }
                if (indent) {
                    out.unindent();
                }
            } else {
                if (padding) {
                    out.print(" = ", 89);
                } else {
                    out.print("=", 89);
                }
                PrinterFactory.create(expr).print(expr, out);
            }
        } else {
            AST rhs = this.printLeftHandSide(node, out);
            if (out.mode == 1) {
                boolean indent;
                TestNodeWriter tester = out.testers.get();
                PrinterFactory.create(rhs).print(rhs, tester);
                boolean bl = indent = indentStandard || wrapAfterAssign || preferWrapAfterAssign || preferWrapAfterLeftParen;
                if (indent) {
                    out.indent();
                }
                Marker marker = null;
                if (preferWrapAfterAssign && wrapLines && out.getIndentLength() < out.column && out.column + (padding ? 3 : 1) + tester.length > lineLength) {
                    if (padding) {
                        out.print(" =", 89);
                    } else {
                        out.print("=", 89);
                    }
                    out.printNewline();
                    this.printIndentation(out);
                    marker = out.state.markers.add();
                } else {
                    if (settings.getBoolean(ConventionKeys.ALIGN_VAR_ASSIGNS, false)) {
                        JavaNode parent = ((JavaNode)node).getParent();
                        if (this.isNewChunk(parent, 89)) {
                            out.state.assignOffset = -1;
                        }
                        if (this.canAlign((JavaNode)node)) {
                            this.alignAssignment(node, false, out);
                        }
                    }
                    if (padding) {
                        marker = out.state.markers.add(out.line, out.column + 2);
                        out.print(" = ", 89);
                    } else {
                        out.print("=", 89);
                        marker = out.state.markers.add();
                    }
                    out.testers.release(tester);
                }
                this.printRightHandSide(rhs, out);
                if (indent) {
                    out.unindent();
                }
                if (marker != null) {
                    out.state.markers.remove(marker);
                }
            } else {
                if (padding) {
                    out.print(" = ", 89);
                } else {
                    out.print("=", 89);
                }
                this.printRightHandSide(rhs, out);
            }
        }
    }

    void align(int amount, NodeWriter out) throws IOException {
        out.print(out.getString(amount), 153);
    }

    private boolean isAssignment(AST node) {
        AST child = node.getFirstChild();
        switch (child.getType()) {
            case 89: {
                switch (child.getFirstChild().getType()) {
                    case 119: {
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }

    private boolean isNewChunk(AST node, int type) {
        JavaNode n = (JavaNode)node;
        switch (n.getParent().getType()) {
            case 39: {
                return true;
            }
        }
        if (settings.getBoolean(ConventionKeys.CHUNKS_BY_COMMENTS, true) && n.hasCommentsBefore()) {
            return true;
        }
        int maxLinesBetween = settings.getInt(ConventionKeys.BLANK_LINES_KEEP_UP_TO, 1);
        if (maxLinesBetween > 0) {
            if (settings.getBoolean(ConventionKeys.CHUNKS_BY_BLANK_LINES, true)) {
                JavaNode prev = n.getPreviousSibling();
                switch (type) {
                    case 14: {
                        switch (prev.getType()) {
                            case 14: {
                                return maxLinesBetween > 0 && n.getStartLine() - n.getPreviousSibling().getStartLine() - 1 >= maxLinesBetween;
                            }
                        }
                        break;
                    }
                    case 89: {
                        switch (prev.getType()) {
                            case 32: {
                                return this.isAssignment(prev) && maxLinesBetween > 0 && n.getStartLine() - n.getPreviousSibling().getStartLine() - 1 >= maxLinesBetween;
                            }
                            case 14: {
                                return maxLinesBetween > 0 && n.getStartLine() - n.getPreviousSibling().getStartLine() - 1 > maxLinesBetween;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private AST getNextSibling(AST node, JavaNode parent) {
        switch (parent.getType()) {
            case 14: 
            case 32: {
                return parent.getNextSibling();
            }
            case 89: 
            case 119: 
            case 125: 
            case 126: 
            case 127: 
            case 128: {
                return this.getNextSibling(parent, parent.getParent());
            }
        }
        throw new IllegalArgumentException("unexpected parent node --" + parent);
    }

    private boolean isPartOfDeclaration(AST node) {
        return ((JavaNode)node).getParent().getType() == 14;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void alignAssignment(AST node, boolean variableAssign, NodeWriter out) throws IOException {
        JavaNode parent = ((JavaNode)node).getParent();
        AST next = this.getNextSibling(node, parent);
        if (out.state.assignOffset != -1) {
            if (out.column < out.state.assignOffset) {
                this.align(out.state.assignOffset - out.column, out);
            }
            if (next == null) return;
            switch (next.getType()) {
                case 14: {
                    if (!this.isNewChunk(next, 14)) return;
                    out.state.assignOffset = -1;
                    return;
                }
                case 32: {
                    if (this.isAssignment(next) && !this.isNewChunk(next, 89)) return;
                    out.state.assignOffset = -1;
                    return;
                }
                default: {
                    out.state.assignOffset = -1;
                    return;
                }
            }
        } else {
            if (next == null) return;
            switch (next.getType()) {
                case 32: {
                    if (variableAssign || !this.isAssignment(next)) {
                        out.state.assignOffset = -1;
                        return;
                    }
                    int length = 0;
                    TestNodeWriter tester = out.testers.get();
                    block15: for (AST def = parent; def != null; def = def.getNextSibling()) {
                        switch (def.getType()) {
                            case 32: {
                                AST t;
                                if (!this.isAssignment(def)) break block15;
                                tester.reset();
                                AST rhs = def.getFirstChild().getFirstChild();
                                PrinterFactory.create(rhs).print(rhs, tester);
                                if (tester.length > length) {
                                    length = tester.length;
                                }
                                if ((t = def.getNextSibling()) != null && this.isNewChunk(t, 89)) break block15;
                            }
                            default: {
                                continue block15;
                            }
                        }
                    }
                    out.state.assignOffset = length + out.getIndentLength() + 1;
                    if (out.column < out.state.assignOffset) {
                        this.align(out.state.assignOffset - out.column, out);
                    }
                    out.testers.release(tester);
                    return;
                }
                case 14: {
                    if (!variableAssign) {
                        out.state.assignOffset = -1;
                        return;
                    }
                    int length = -1;
                    TestNodeWriter tester = out.testers.get();
                    boolean alignVariables = settings.getBoolean(ConventionKeys.ALIGN_VAR_IDENTS, false);
                    block16: for (AST def = parent; def != null; def = def.getNextSibling()) {
                        switch (def.getType()) {
                            case 32: {
                                if (!this.isAssignment(def)) break block16;
                                tester.reset();
                                AST rhs = def.getFirstChild().getFirstChild();
                                PrinterFactory.create(rhs).print(rhs, tester);
                                if (tester.length > length) {
                                    length = tester.length;
                                }
                                if (!this.isNewChunk(def, 89)) continue block16;
                                break block16;
                            }
                            case 14: {
                                AST n;
                                tester.reset();
                                AST defModifier = def.getFirstChild();
                                PrinterFactory.create(defModifier).print(defModifier, tester);
                                AST defType = defModifier.getNextSibling();
                                PrinterFactory.create(defType).print(defType, tester);
                                if (alignVariables && out.state.variableOffset != -1 && out.state.variableOffset > tester.length) {
                                    tester.length = out.state.variableOffset - out.getIndentLength() - 1;
                                }
                                AST defIdent = defType.getNextSibling();
                                PrinterFactory.create(defIdent).print(defIdent, tester);
                                ++tester.length;
                                if (tester.length > length) {
                                    length = tester.length;
                                }
                                if ((n = def.getNextSibling()) == null || !this.isNewChunk(n, 14)) continue block16;
                                break block16;
                            }
                        }
                    }
                    out.testers.release(tester);
                    out.state.assignOffset = length + out.getIndentLength() + 1;
                    if (out.column >= out.state.assignOffset) return;
                    this.align(out.state.assignOffset - out.column, out);
                    return;
                }
                default: {
                    out.state.assignOffset = -1;
                }
            }
        }
    }

    private boolean canAlign(JavaNode node) {
        JavaNode parent = node.getParent();
        if (parent != null) {
            switch (parent.getType()) {
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 101: {
                    return false;
                }
                case 10: 
                case 11: {
                    return true;
                }
            }
            return this.canAlign(parent);
        }
        return false;
    }
}

