/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.swing.util;

import de.hunsicker.util.ResourceBundleFactory;
import java.awt.AWTEvent;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;

public class PopupSupport {
    private static final Comparator COMPARATOR = new PartialStringComparator();
    private static final String EMPTY_STRING = "".intern();
    private static final String BUNDLE_NAME = "de.hunsicker.swing.util.Bundle";
    private Action _copyAction;
    private Action _cutAction;
    private Action _deleteAction;
    private Action _pasteAction;
    private Action _selectAllAction;
    private FocusInterceptor _interceptor;
    private JPopupMenu _menu;
    private List _registeredComponents;
    private final List _supported;

    public PopupSupport() {
        this(true);
    }

    public PopupSupport(List supported) {
        this(true, supported);
    }

    public PopupSupport(boolean enable, List supported) {
        if (enable) {
            this.setEnabled(true);
        }
        this._supported = new ArrayList(supported);
        Collections.sort(this._supported);
    }

    public PopupSupport(boolean enable) {
        if (enable) {
            this.setEnabled(true);
        }
        this._supported = new ArrayList(3);
        this._supported.add("javax.swing.");
    }

    public void setEnabled(boolean enable) {
        if (enable) {
            if (this._interceptor == null) {
                this._interceptor = new FocusInterceptor();
                Toolkit.getDefaultToolkit().addAWTEventListener(this._interceptor, 4L);
            }
        } else {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this._interceptor);
            this._interceptor = null;
            if (this._registeredComponents != null) {
                int size = this._registeredComponents.size();
                for (int i = 0; i < size; ++i) {
                    ListenerSupport support = (ListenerSupport)this._registeredComponents.get(i);
                    support.remove();
                }
            }
            this._registeredComponents = null;
            this._copyAction = null;
            this._cutAction = null;
            this._selectAllAction = null;
            this._pasteAction = null;
            this._deleteAction = null;
            this._menu = null;
        }
    }

    public void addSupport(JTextComponent component) {
        if (component == null) {
            return;
        }
        if (this._registeredComponents == null) {
            this._registeredComponents = new ArrayList(10);
        }
        if (!this._registeredComponents.contains(new ListenerSupport(component))) {
            ListenerSupport support = new ListenerSupport(component, new MouseHandler(), new KeyHandler());
            this._registeredComponents.add(support);
        } else {
            this.updateSelectAllAction(component.getDocument());
            this.updateDeleteAction(component);
        }
    }

    protected boolean isClipboardEmpty() {
        Transferable data = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this);
        return data == null || !data.isDataFlavorSupported(DataFlavor.stringFlavor);
    }

    protected JPopupMenu getPopup(JTextComponent component) {
        if (this._menu == null) {
            this._menu = new JPopupMenu();
            Action[] actions = component.getActions();
            for (int i = 0; i < actions.length; ++i) {
                Object value = actions[i].getValue("Name");
                if (value.equals("cut-to-clipboard")) {
                    this._cutAction = actions[i];
                    continue;
                }
                if (value.equals("copy-to-clipboard")) {
                    this._copyAction = actions[i];
                    continue;
                }
                if (value.equals("paste-from-clipboard")) {
                    this._pasteAction = actions[i];
                    continue;
                }
                if (!value.equals("select-all")) continue;
                this._selectAllAction = actions[i];
            }
            if (this._cutAction != null) {
                JMenuItem item = new JMenuItem(this._cutAction);
                item.setText(ResourceBundleFactory.getBundle(BUNDLE_NAME).getString("MNU_CUT"));
                this._menu.add(item);
            }
            if (this._copyAction != null) {
                JMenuItem item = new JMenuItem(this._copyAction);
                item.setText(ResourceBundleFactory.getBundle(BUNDLE_NAME).getString("MNU_COPY"));
                this._menu.add(item);
            }
            if (this._pasteAction != null) {
                JMenuItem item = new JMenuItem(this._pasteAction);
                item.setText(ResourceBundleFactory.getBundle(BUNDLE_NAME).getString("MNU_PASTE"));
                this._menu.add(item);
            }
            if (this._deleteAction == null) {
                this._deleteAction = new DeleteAction();
            }
            this._menu.add(this._deleteAction);
            if (this._selectAllAction != null) {
                this._menu.add(new JPopupMenu.Separator());
                JMenuItem item = new JMenuItem(this._selectAllAction);
                item.setText(ResourceBundleFactory.getBundle(BUNDLE_NAME).getString("MNU_SELECT_ALL"));
                this._menu.add(item);
            }
        }
        this.updateCopyCutAction(component);
        this.updatePasteAction(component);
        this.updateDeleteAction(component);
        this.updateSelectAllAction(component.getDocument());
        return this._menu;
    }

    protected boolean isTextSelected(int start, int end) {
        return start < end;
    }

    private void updateCopyCutAction(JTextComponent component) {
        int endOffset;
        int startOffset = component.getSelectionStart();
        if (this.isTextSelected(startOffset, endOffset = component.getSelectionEnd())) {
            if (this._copyAction != null) {
                this._copyAction.setEnabled(true);
            }
            if (this._cutAction != null && component.isEditable()) {
                this._cutAction.setEnabled(true);
            }
        } else {
            if (this._copyAction != null) {
                this._copyAction.setEnabled(false);
            }
            if (this._cutAction != null) {
                this._cutAction.setEnabled(false);
            }
        }
    }

    private void updateDeleteAction(JTextComponent component) {
        if (component.isEditable() && component.getDocument().getLength() > 0) {
            if (this._deleteAction != null) {
                this._deleteAction.setEnabled(true);
            }
        } else if (this._deleteAction != null) {
            this._deleteAction.setEnabled(false);
        }
    }

    private void updatePasteAction(JTextComponent component) {
        if (this._pasteAction != null) {
            if (component.isEditable() && !this.isClipboardEmpty()) {
                this._pasteAction.setEnabled(true);
            } else {
                this._pasteAction.setEnabled(false);
            }
        }
    }

    private void updateSelectAllAction(Document document) {
        if (document.getLength() > 0) {
            if (this._selectAllAction != null) {
                this._selectAllAction.setEnabled(true);
            }
        } else if (this._selectAllAction != null) {
            this._selectAllAction.setEnabled(false);
        }
    }

    private final class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        public void mousePressed(MouseEvent ev) {
            ((JComponent)ev.getSource()).requestFocus();
        }

        public void mouseReleased(MouseEvent ev) {
            if (ev.isPopupTrigger()) {
                JTextComponent component = (JTextComponent)ev.getSource();
                PopupSupport.this.getPopup(component).show(component, ev.getX(), ev.getY());
            }
        }
    }

    private final class KeyHandler
    extends KeyAdapter {
        private KeyHandler() {
        }

        public void keyPressed(KeyEvent ev) {
            JTextComponent component;
            if (ev.isShiftDown() && ev.getKeyCode() == 121 && (component = (JTextComponent)ev.getSource()).isShowing()) {
                try {
                    Rectangle r = component.modelToView(component.getCaretPosition());
                    PopupSupport.this.getPopup(component).show(component, r.x, r.y);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
    }

    private class FocusInterceptor
    implements AWTEventListener {
        private FocusInterceptor() {
        }

        public void eventDispatched(AWTEvent ev) {
            if (ev.getID() == 1004 && ev.getSource() instanceof JTextComponent && Collections.binarySearch(PopupSupport.this._supported, ev.getSource().getClass().getName(), COMPARATOR) > -1) {
                PopupSupport.this.addSupport((JTextComponent)ev.getSource());
            }
        }
    }

    private static final class PartialStringComparator
    implements Comparator {
        private PartialStringComparator() {
        }

        public int compare(Object o1, Object o2) {
            String s2 = (String)o1;
            String s1 = (String)o1;
            if (s2.startsWith(s1)) {
                return 0;
            }
            return s1.compareTo(s2);
        }
    }

    private static final class ListenerSupport {
        JTextComponent component;
        KeyListener keyHandler;
        MouseListener mouseHandler;

        public ListenerSupport(JTextComponent component) {
            this.component = component;
        }

        public ListenerSupport(JTextComponent component, MouseListener mouseListener, KeyListener keyListener) {
            this(component);
            this.mouseHandler = mouseListener;
            this.keyHandler = keyListener;
            this.add();
        }

        public void add() {
            this.component.addMouseListener(this.mouseHandler);
            this.component.addKeyListener(this.keyHandler);
        }

        public boolean equals(Object o) {
            if (o instanceof JTextComponent) {
                return this.component.equals(o);
            }
            if (o instanceof ListenerSupport) {
                return this.component.equals(((ListenerSupport)o).component);
            }
            return false;
        }

        public int hashCode() {
            return this.component.hashCode();
        }

        public void remove() {
            this.component.removeMouseListener(this.mouseHandler);
            this.component.removeKeyListener(this.keyHandler);
        }
    }

    private static final class DeleteAction
    extends TextAction {
        public DeleteAction() {
            super("clear-action");
            this.putValue("Name", ResourceBundleFactory.getBundle(PopupSupport.BUNDLE_NAME).getString("MNU_DELETE"));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent ev) {
            int markPos;
            JTextComponent target = this.getTextComponent(ev);
            if (target == null) {
                return;
            }
            Caret caret = target.getCaret();
            int curPos = caret.getDot();
            if (curPos != (markPos = caret.getMark())) {
                try {
                    int span = markPos - curPos;
                    if (span < 0) {
                        span *= -1;
                        curPos = markPos;
                    }
                    Document document = target.getDocument();
                    document.remove(curPos, span);
                }
                catch (Exception neverOccurs) {}
            } else {
                target.setText(EMPTY_STRING);
            }
        }
    }
}

