/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.util;

public final class Lcs {
    private static final String EMPTY_STRING = "";
    private String _lcs = "";
    private String _s1;
    private String _s2;
    private Cell[][] _table;
    private boolean _done;
    private boolean _init;
    private int _columns;
    private int _rows;

    public Lcs() {
    }

    public Lcs(String string1, String string2) {
        this._s1 = string1;
        this._s2 = string2;
        this.init();
    }

    public static Lcs compute(String s1, String s2) {
        Lcs lcs = new Lcs(s1, s2);
        return lcs;
    }

    public int getLength() {
        if (!this._done) {
            this.compute();
        }
        return this._lcs.length();
    }

    public double getPercentage() {
        return this.getLength() * 200 / (this._s1.length() + this._s2.length());
    }

    public String getString() {
        if (!this._done) {
            this.compute();
        }
        return this._lcs;
    }

    public void compute() {
        if (!this._init) {
            this.init();
        }
        this._lcs = EMPTY_STRING;
        this.recursiveLcs(this._s2, this._rows - 1, this._columns - 1);
        this._table = null;
        this._init = false;
        this._done = true;
    }

    public void init(String s1, String s2) {
        this._s1 = s1;
        this._s2 = s2;
        this.init();
    }

    private void init() {
        int j;
        int i;
        if (this._s1 == null || this._s2 == null) {
            throw new IllegalStateException("both strings must be specified and non-null");
        }
        int temp1 = 0;
        int temp2 = 0;
        this._columns = this._s1.length() + 1;
        this._rows = this._s2.length() + 1;
        this._table = new Cell[this._rows][];
        for (i = 0; i < this._rows; ++i) {
            this._table[i] = new Cell[this._columns];
            for (j = 0; j < this._columns; ++j) {
                this._table[i][j] = new Cell(0, '+');
            }
        }
        for (int l = 1; l < this._rows; ++l) {
            this._table[l][0].changeTotal(0);
            this._table[l][0].changeArrow('+');
        }
        for (int k = 0; k < this._columns; ++k) {
            this._table[0][k].changeTotal(0);
            this._table[0][k].changeArrow('+');
        }
        for (i = 1; i < this._rows; ++i) {
            for (j = 1; j < this._columns; ++j) {
                if (this._s1.charAt(j - 1) == this._s2.charAt(i - 1)) {
                    temp1 = this._table[i - 1][j - 1].total();
                    this._table[i][j].changeTotal(temp1 + 1);
                    this._table[i][j].changeArrow('\\');
                    continue;
                }
                temp1 = this._table[i - 1][j].total();
                if (temp1 >= (temp2 = this._table[i][j - 1].total())) {
                    this._table[i][j].changeTotal(temp1);
                    this._table[i][j].changeArrow('^');
                    continue;
                }
                this._table[i][j].changeTotal(temp2);
                this._table[i][j].changeArrow('<');
            }
        }
        this._init = true;
        this._done = false;
    }

    private String recursiveLcs(String x, int i, int j) {
        if (i == 0 || j == 0) {
            return EMPTY_STRING;
        }
        if (this._table[i][j] != null) {
            if (this._table[i][j].arrow() == '\\') {
                this.recursiveLcs(x, i - 1, j - 1);
                String temp = String.valueOf(x.charAt(i - 1));
                this._lcs = this._lcs.concat(temp);
            } else if (this._table[i][j].arrow() == '^') {
                this.recursiveLcs(x, i - 1, j);
            } else {
                this.recursiveLcs(x, i, j - 1);
            }
        }
        return EMPTY_STRING;
    }

    private static final class Cell {
        public static final char DIRECTIONAL = '\\';
        public static final char LEFT = '<';
        public static final char UNDEFINED = '+';
        public static final char UP = '^';
        private char _arrow;
        private int _total;

        public Cell(int total, char arrow) {
            this._total = total;
            this._arrow = arrow;
        }

        public char arrow() {
            return this._arrow;
        }

        public void changeArrow(char arrow) {
            this._arrow = arrow;
        }

        public void changeTotal(int total) {
            this._total = total;
        }

        public int total() {
            return this._total;
        }
    }
}

