/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.language;

import de.hunsicker.jalopy.language.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

public class ModifierType
implements Comparable,
Type {
    static final int PUBLIC_INT = 1;
    static final int PROTECTED_INT = 2;
    static final int PRIVATE_INT = 16;
    static final int STATIC_INT = 8;
    static final int FINAL_INT = 32;
    static final int TRANSIENT_INT = 64;
    static final int ABSTRACT_INT = 128;
    static final int NATIVE_INT = 256;
    static final int SYNCHRONIZED_INT = 512;
    static final int VOLATILE_INT = 1024;
    static final int STRICTFP_INT = 64;
    private static final String DELIMETER = "|";
    private static String _sortOrder;
    private static List _order;
    public static final ModifierType PUBLIC;
    public static final ModifierType PROTECTED;
    public static final ModifierType PRIVATE;
    public static final ModifierType STATIC;
    public static final ModifierType FINAL;
    public static final ModifierType TRANSIENT;
    public static final ModifierType NATIVE;
    public static final ModifierType ABSTRACT;
    public static final ModifierType SYNCHRONIZED;
    public static final ModifierType VOLATILE;
    public static final ModifierType STRICTFP;
    private final String _name;
    private final int _key;

    private ModifierType(String name, int key) {
        this._name = name;
        this._key = key;
    }

    public String getName() {
        return this._name;
    }

    public static synchronized void setOrder(String str) {
        if (str == null || str.length() == 0) {
            throw new IllegalArgumentException("order == " + str);
        }
        StringTokenizer tokens = new StringTokenizer(str, DELIMETER);
        ArrayList<ModifierType> temp = new ArrayList<ModifierType>(_order.size());
        StringBuffer buf = new StringBuffer(50);
        while (tokens.hasMoreElements()) {
            String token = tokens.nextToken();
            ModifierType type = ModifierType.valueOf(token);
            if (temp.contains(type)) {
                throw new IllegalArgumentException("invalid order string " + temp);
            }
            temp.add(type);
            buf.append(type.toString());
            buf.append(DELIMETER);
        }
        if (_order.size() != temp.size()) {
            throw new IllegalArgumentException("invalid order string " + temp);
        }
        if (!(temp.contains(PUBLIC) && temp.contains(PROTECTED) && temp.contains(PRIVATE) && temp.contains(STATIC) && temp.contains(FINAL) && temp.contains(ABSTRACT) && temp.contains(SYNCHRONIZED) && temp.contains(TRANSIENT) && temp.contains(VOLATILE) && temp.contains(STRICTFP) && temp.contains(NATIVE))) {
            throw new IllegalArgumentException("invalid order string " + temp);
        }
        _order = Collections.unmodifiableList(temp);
        buf.deleteCharAt(buf.length() - 1);
        _sortOrder = buf.toString();
    }

    public static synchronized String getOrder() {
        return _sortOrder;
    }

    public int compareTo(Object other) {
        if (other == this) {
            return 0;
        }
        if (other instanceof ModifierType) {
            int otherIndex;
            int thisIndex = _order.indexOf(this);
            if (thisIndex > (otherIndex = _order.indexOf(other))) {
                return 1;
            }
            if (thisIndex < otherIndex) {
                return -1;
            }
            return 0;
        }
        throw new ClassCastException(other == null ? "null" : other.getClass().getName());
    }

    public String toString() {
        return this._name;
    }

    public static ModifierType valueOf(String name) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("invalid modifier -- " + name);
        }
        if (ModifierType.PUBLIC._name.equals(name = name.trim())) {
            return PUBLIC;
        }
        if (ModifierType.PRIVATE._name.equals(name)) {
            return PRIVATE;
        }
        if (ModifierType.PROTECTED._name.equals(name)) {
            return PROTECTED;
        }
        if (ModifierType.FINAL._name.equals(name)) {
            return FINAL;
        }
        if (ModifierType.STATIC._name.equals(name)) {
            return STATIC;
        }
        if (ModifierType.ABSTRACT._name.equals(name)) {
            return ABSTRACT;
        }
        if (ModifierType.SYNCHRONIZED._name.equals(name)) {
            return SYNCHRONIZED;
        }
        if (ModifierType.TRANSIENT._name.equals(name)) {
            return TRANSIENT;
        }
        if (ModifierType.VOLATILE._name.equals(name)) {
            return VOLATILE;
        }
        if (ModifierType.STRICTFP._name.equals(name)) {
            return STRICTFP;
        }
        if (ModifierType.NATIVE._name.equals(name)) {
            return NATIVE;
        }
        throw new IllegalArgumentException("invalid modifier -- " + name);
    }

    static {
        _order = new ArrayList(7);
        PUBLIC = new ModifierType("public", 1);
        PROTECTED = new ModifierType("protected", 2);
        PRIVATE = new ModifierType("private", 16);
        STATIC = new ModifierType("static", 8);
        FINAL = new ModifierType("final", 32);
        TRANSIENT = new ModifierType("transient", 64);
        NATIVE = new ModifierType("native", 256);
        ABSTRACT = new ModifierType("abstract", 128);
        SYNCHRONIZED = new ModifierType("synchronized", 512);
        VOLATILE = new ModifierType("volatile", 1024);
        STRICTFP = new ModifierType("strictfp", 64);
        _order.add(PUBLIC);
        _order.add(PROTECTED);
        _order.add(PRIVATE);
        _order.add(ABSTRACT);
        _order.add(STATIC);
        _order.add(FINAL);
        _order.add(SYNCHRONIZED);
        _order.add(TRANSIENT);
        _order.add(VOLATILE);
        _order.add(NATIVE);
        _order.add(STRICTFP);
        StringBuffer buf = new StringBuffer(100);
        int size = _order.size();
        for (int i = 0; i < size; ++i) {
            buf.append(((ModifierType)ModifierType._order.get((int)i))._name);
            buf.append(DELIMETER);
        }
        buf.setLength(buf.length() - 1);
        _sortOrder = buf.toString();
    }
}

