/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import de.hunsicker.antlr.CommonHiddenStreamToken;
import de.hunsicker.antlr.collections.AST;
import de.hunsicker.jalopy.language.ExtendedToken;
import de.hunsicker.jalopy.language.JavaNode;
import de.hunsicker.jalopy.language.JavaNodeHelper;
import de.hunsicker.jalopy.language.JavaNodeModifier;
import de.hunsicker.jalopy.language.Node;
import de.hunsicker.jalopy.printer.AbstractPrinter;
import de.hunsicker.jalopy.printer.JavadocPrinter;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.storage.ConventionKeys;
import de.hunsicker.jalopy.storage.Environment;
import java.io.IOException;
import java.util.List;

abstract class BasicDeclarationPrinter
extends AbstractPrinter {
    static final String GENERATED_COMMENT = "<GENERATED_JAVADOC_COMMENT>";
    private static final String DELIMETER = "|";
    private int privacyMask = 7;

    protected BasicDeclarationPrinter() {
    }

    public void print(AST node, NodeWriter out) throws IOException {
        this.printCommentsBefore(node, out);
        this.logIssues(node, out);
    }

    protected void addClassComment(JavaNode node, NodeWriter out) {
        String t = settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_CLASS, "/**| * DOCUMENT ME!| *| * @author $author$| * @version $Revision$| */");
        Node text = new Node(40, out.environment.interpolate(t));
        Node comment = new Node(6, GENERATED_COMMENT);
        comment.setFirstChild(text);
        ExtendedToken token = new ExtendedToken(6, null);
        token.setComment(comment);
        this.addComment(node, token);
    }

    protected void addComment(JavaNode node, NodeWriter out) {
        switch (node.getType()) {
            case 13: {
                if (!this.isEnabled(settings.getInt(ConventionKeys.COMMENT_JAVADOC_METHOD_MASK, 0), node)) break;
                this.addMethodComment(node, out);
                break;
            }
            case 12: {
                if (!this.isEnabled(settings.getInt(ConventionKeys.COMMENT_JAVADOC_CTOR_MASK, 0), node)) break;
                this.addCtorComment(node, out);
                break;
            }
            case 14: {
                if (!this.isEnabled(settings.getInt(ConventionKeys.COMMENT_JAVADOC_VARIABLE_MASK, 0), node)) break;
                this.addVariableComment(node);
                break;
            }
            case 18: {
                if (!this.isEnabled(settings.getInt(ConventionKeys.COMMENT_JAVADOC_CLASS_MASK, 0), node)) break;
                this.addClassComment(node, out);
                break;
            }
            case 19: {
                if (!this.isEnabled(settings.getInt(ConventionKeys.COMMENT_JAVADOC_CLASS_MASK, 0), node)) break;
                this.addInterfaceComment(node);
            }
        }
    }

    protected void addInterfaceComment(JavaNode node) {
        String t = settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_INTERFACE, "/**| * DOCUMENT ME!| *| * @author $author$| * @version $Revision$| */");
        Node text = new Node(40, t);
        Node comment = new Node(6, GENERATED_COMMENT);
        comment.setFirstChild(text);
        ExtendedToken token = new ExtendedToken(6, null);
        token.setComment(comment);
        this.addComment(node, token);
    }

    protected void addMethodComment(JavaNode node, NodeWriter out) {
        AST exceptions;
        AST returnType;
        Node comment = new Node(6, GENERATED_COMMENT);
        StringBuffer buf = new StringBuffer(150);
        String topText = settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_METHOD_TOP, "/**| * DOCUMENT ME!").trim();
        buf.append(topText);
        buf.append(DELIMETER);
        AST parameters = JavaNodeHelper.getFirstChild(node, 24);
        String bottomText = settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_METHOD_BOTTOM, " */");
        String leadingSeparator = bottomText.substring(0, bottomText.indexOf(42) + 1);
        if (parameters.getFirstChild() != null) {
            buf.append(leadingSeparator);
            buf.append(DELIMETER);
            this.addParameters(buf, parameters, settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_METHOD_PARAM, " * @param $paramType$ DOCUMENT ME!"), out.environment);
        }
        if (!"void".equals((returnType = JavaNodeHelper.getFirstChild(node, 17).getFirstChild()).getText())) {
            buf.append(leadingSeparator);
            buf.append(DELIMETER);
            buf.append(settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_METHOD_RETURN, " * @return DOCUMENT ME!"));
            buf.append(DELIMETER);
        }
        if ((exceptions = JavaNodeHelper.getFirstChild(node, 90)) != null && exceptions.getFirstChild() != null) {
            buf.append(leadingSeparator);
            buf.append(DELIMETER);
            List types = JavadocPrinter.getValidTypeNames(node, 90);
            this.addExceptions(buf, types, settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_METHOD_EXCEPTION, " * @throws $exceptionType$ DOCUMENT ME!"), out.environment);
        }
        buf.append(bottomText);
        Node text = new Node(40, buf.toString());
        comment.setFirstChild(text);
        ExtendedToken token = new ExtendedToken(6, null);
        token.setComment(comment);
        this.addComment(node, token);
    }

    void addCommentIfNeeded(JavaNode node, NodeWriter out) {
        block12: {
            boolean hasJavadoc;
            block13: {
                if (out.mode != 1) {
                    return;
                }
                if (out.state.anonymousInnerClass) break block12;
                if (!out.state.innerClass) break block13;
                if (!settings.getBoolean(ConventionKeys.COMMENT_JAVADOC_INNER_CLASS, false)) break block12;
            }
            if (!(hasJavadoc = node.hasJavadocComment()) && node.hasCommentsBefore()) {
                CommonHiddenStreamToken comment = node.getCommentBefore();
                if (comment.getHiddenAfter() == null) {
                    switch (comment.getType()) {
                        case 52: {
                            this.addComment(node, out);
                            break;
                        }
                        case 155: 
                        case 157: {
                            break;
                        }
                    }
                }
            } else if (!hasJavadoc) {
                this.addComment(node, out);
            }
        }
    }

    private boolean isEnabled(int mask, AST node) {
        int value = JavaNodeModifier.valueOf(node) & this.privacyMask;
        return (mask & value) != 0 || value == 0 && (0x10 & mask) != 0;
    }

    private void addComment(JavaNode node, ExtendedToken comment) {
        CommonHiddenStreamToken c = node.getCommentBefore();
        if (c == null) {
            node.setHiddenBefore(comment);
        } else {
            while (c != null) {
                if (c.getHiddenAfter() == null) {
                    c.setHiddenAfter(comment);
                    break;
                }
                c = c.getHiddenAfter();
            }
        }
    }

    private void addCtorComment(JavaNode node, NodeWriter out) {
        AST exceptions;
        Node comment = new Node(6, GENERATED_COMMENT);
        String topText = settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_CTOR_TOP, "/**| * Creates a new $objectType$ object.").trim();
        StringBuffer buf = new StringBuffer();
        out.environment.set(Environment.Variable.TYPE_OBJECT.getName(), JavaNodeHelper.getFirstChild(node, 68).getText());
        buf.append(out.environment.interpolate(topText));
        out.environment.unset(Environment.Variable.TYPE_OBJECT.getName());
        buf.append(DELIMETER);
        AST parameters = JavaNodeHelper.getFirstChild(node, 24);
        String bottomText = settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_CTOR_BOTTOM, " */");
        String leadingSeparator = bottomText.substring(0, bottomText.indexOf(42) + 1);
        if (parameters.getFirstChild() != null) {
            buf.append(leadingSeparator);
            buf.append(DELIMETER);
            this.addParameters(buf, parameters, settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_CTOR_PARAM, " * @param $paramType$ DOCUMENT ME!"), out.environment);
        }
        if ((exceptions = JavaNodeHelper.getFirstChild(node, 90)) != null && exceptions.getFirstChild() != null) {
            buf.append(leadingSeparator);
            buf.append(DELIMETER);
            List types = JavadocPrinter.getValidTypeNames(node, 90);
            this.addExceptions(buf, types, settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_CTOR_EXCEPTION, " * @throws $exceptionType$ DOCUMENT ME!"), out.environment);
        }
        buf.append(bottomText);
        Node text = new Node(40, buf.toString());
        comment.setFirstChild(text);
        ExtendedToken token = new ExtendedToken(6, null);
        token.setComment(comment);
        this.addComment(node, token);
    }

    private void addExceptions(StringBuffer buf, List types, String text, Environment environment) {
        int size = types.size();
        for (int i = 0; i < size; ++i) {
            String type = (String)types.get(i);
            environment.set(Environment.Variable.TYPE_EXCEPTION.getName(), type);
            buf.append(environment.interpolate(text));
            buf.append(DELIMETER);
            environment.unset(Environment.Variable.TYPE_EXCEPTION.getName());
        }
    }

    private void addParameters(StringBuffer buf, AST node, String text, Environment environment) {
        for (AST child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            switch (child.getType()) {
                case 25: {
                    String type = JavaNodeHelper.getFirstChild(child, 68).getText();
                    environment.set(Environment.Variable.TYPE_PARAM.getName(), type);
                    buf.append(environment.interpolate(text));
                    buf.append(DELIMETER);
                    environment.unset(Environment.Variable.TYPE_PARAM.getName());
                }
            }
        }
    }

    private void addVariableComment(JavaNode node) {
        String t = settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_VARIABLE, "/**| * DOCUMENT ME!| */");
        Node text = new Node(40, t);
        Node comment = new Node(6, GENERATED_COMMENT);
        comment.setFirstChild(text);
        ExtendedToken token = new ExtendedToken(6, null);
        token.setComment(comment);
        this.addComment(node, token);
    }
}

