/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import de.hunsicker.antlr.collections.AST;
import de.hunsicker.jalopy.language.JavaNode;
import de.hunsicker.jalopy.language.JavaNodeHelper;
import de.hunsicker.jalopy.printer.AbstractPrinter;
import de.hunsicker.jalopy.printer.Marker;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.ParenthesesScope;
import de.hunsicker.jalopy.printer.Printer;
import de.hunsicker.jalopy.printer.PrinterFactory;
import de.hunsicker.jalopy.printer.PrinterHelper;
import de.hunsicker.jalopy.printer.TestNodeWriter;
import de.hunsicker.jalopy.storage.ConventionKeys;
import java.io.IOException;

final class ParametersPrinter
extends AbstractPrinter {
    static final int OFFSET_NONE = -1;
    private static final int FIRST_PARAM = 0;
    private static final Printer INSTANCE = new ParametersPrinter();
    private static final int MODE_ALWAYS = 1;
    private static final int MODE_AS_NEEDED = 2;

    public static final Printer getInstance() {
        return INSTANCE;
    }

    public void print(AST node, NodeWriter out) throws IOException {
        int line = out.line;
        boolean wrapped = false;
        Marker marker = out.state.markers.add();
        switch (node.getType()) {
            case 24: {
                boolean newlineAfter = settings.getBoolean(ConventionKeys.LINE_WRAP_AFTER_PARAMS_METHOD_DEF, false);
                if (out.mode == 1) {
                    boolean align = settings.getBoolean(ConventionKeys.ALIGN_PARAMS_METHOD_DEF, false);
                    if (align) {
                        if (newlineAfter) {
                            this.setAlignOffset(node, out);
                        } else {
                            AST expr = node.getFirstChild();
                            if (expr != null) {
                                TestNodeWriter tester = out.testers.get();
                                PrinterFactory.create(expr).print(expr, tester);
                                int lineLength = settings.getInt(ConventionKeys.LINE_LENGTH, 80);
                                if (out.column + tester.length > lineLength) {
                                    this.setAlignOffset(node, out);
                                }
                                out.testers.release(tester);
                            }
                        }
                    }
                }
                wrapped = out.state.parametersWrapped = this.printImpl(node, newlineAfter ? 1 : 2, 24, out);
                out.state.paramOffset = -1;
                break;
            }
            case 38: {
                wrapped = this.printImpl(node, 2, 38, out);
                break;
            }
            default: {
                throw new IllegalArgumentException("unexpected node type -- " + node);
            }
        }
        if (out.line > line) {
            wrapped = true;
        }
        if (wrapped) {
            if (settings.getBoolean(ConventionKeys.LINE_WRAP_BEFORE_RIGHT_PAREN, false)) {
                if (!out.newline) {
                    out.printNewline();
                }
                if (settings.getBoolean(ConventionKeys.INDENT_DEEP, false)) {
                    this.printIndentation(-1, out);
                } else {
                    this.printIndentation(out);
                }
            }
        }
        out.state.markers.remove(marker);
    }

    private void setAlignOffset(AST node, NodeWriter out) throws IOException {
        int result = 0;
        TestNodeWriter tester = out.testers.get();
        block3: for (AST param = node.getFirstChild(); param != null; param = param.getNextSibling()) {
            switch (param.getType()) {
                case 82: {
                    continue block3;
                }
                default: {
                    AST modifier = param.getFirstChild();
                    PrinterFactory.create(modifier).print(modifier, tester);
                    AST type = modifier.getNextSibling();
                    PrinterFactory.create(type).print(type, tester);
                    int length = tester.length + 1;
                    if (length > result) {
                        result = length;
                    }
                    tester.reset();
                }
            }
        }
        out.testers.release(tester);
        out.state.paramOffset = out.column + result;
    }

    private boolean isConcat(AST node) {
        AST child = node.getFirstChild();
        if (child != null) {
            switch (child.getType()) {
                case 135: {
                    return true;
                }
            }
            return this.isConcat(child);
        }
        return false;
    }

    private AST getFirstStringConcat(AST node) {
        AST expr = node.getFirstChild();
        switch (expr.getType()) {
            case 135: {
                AST first = null;
                block9: for (AST next = expr.getFirstChild(); next != null; next = next.getFirstChild()) {
                    switch (next.getType()) {
                        case 135: {
                            continue block9;
                        }
                        default: {
                            first = next;
                            break block9;
                        }
                    }
                }
                switch (first.getType()) {
                    case 149: {
                        return first;
                    }
                }
            }
        }
        return null;
    }

    private AST getLastChild(AST node) {
        AST result = null;
        switch (node.getType()) {
            case 32: {
                for (AST child = result = node.getFirstChild(); child != null; child = child.getFirstChild()) {
                    result = child;
                }
                return result;
            }
            case 25: {
                for (AST child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    result = child;
                }
                return result;
            }
        }
        throw new IllegalArgumentException("invalid type -- " + node);
    }

    private boolean isSingleLiteral(AST node) {
        if (node.getNextSibling() == null && node.getType() != 135) {
            switch (node.getFirstChild().getType()) {
                case 149: {
                    return true;
                }
            }
        }
        return false;
    }

    private void adjustAlignmentOffset(int column, NodeWriter out) {
        if (out.state.paramOffset != -1) {
            out.state.paramOffset = out.state.paramOffset - column + out.column;
        }
    }

    private boolean containsMethodCall(AST node) {
        block6: for (AST child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            switch (child.getType()) {
                case 82: {
                    continue block6;
                }
                default: {
                    switch (child.getFirstChild().getType()) {
                        case 31: 
                        case 146: {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean printImpl(AST node, int action, int type, NodeWriter out) throws IOException {
        JavaNode parameter = (JavaNode)node.getFirstChild();
        if (parameter == null) {
            return false;
        }
        boolean wrapLines = settings.getBoolean(ConventionKeys.LINE_WRAP, true) && out.mode == 1;
        int lineLength = settings.getInt(ConventionKeys.LINE_LENGTH, 80);
        boolean indentDeep = settings.getBoolean(ConventionKeys.INDENT_DEEP, false);
        int deepIndentSize = settings.getInt(ConventionKeys.INDENT_SIZE_DEEP, 55);
        boolean alignMethodCall = settings.getBoolean(ConventionKeys.LINE_WRAP_AFTER_PARAMS_METHOD_CALL, false);
        boolean alignMethodCallIfNested = settings.getBoolean(ConventionKeys.LINE_WRAP_AFTER_PARAMS_METHOD_CALL_IF_NESTED, false);
        boolean spaceAfterComma = settings.getBoolean(ConventionKeys.SPACE_AFTER_COMMA, true);
        boolean preferWrapAfterLeftParen = settings.getBoolean(ConventionKeys.LINE_WRAP_AFTER_LEFT_PAREN, false);
        boolean wrapIfFirst = settings.getBoolean(ConventionKeys.LINE_WRAP_PARAMS_EXCEED, false);
        boolean result = false;
        int paramIndex = 0;
        boolean restoreAction = false;
        int userAction = action;
        boolean firstWrapped = false;
        if (out.mode == 1) {
            out.state.paramList = true;
            ++out.state.paramLevel;
            out.state.parenScope.addFirst(new ParenthesesScope(out.state.paramLevel));
        }
        while (parameter != null) {
            JavaNode next = (JavaNode)parameter.getNextSibling();
            switch (parameter.getType()) {
                case 82: {
                    if (parameter.hasCommentsAfter()) {
                        out.print(",", 82);
                        this.printCommentsAfter(parameter, false, action != 1, out);
                        break;
                    }
                    out.print(",", 82);
                    break;
                }
                default: {
                    if (out.mode == 1) {
                        if (type == 38 && (alignMethodCall || alignMethodCallIfNested && this.containsMethodCall(node))) {
                            if (restoreAction) {
                                action = userAction;
                            }
                            block3 : switch (parameter.getFirstChild().getType()) {
                                case 31: {
                                    userAction = action;
                                    action = 1;
                                    restoreAction = true;
                                    break;
                                }
                                default: {
                                    switch (out.state.markers.count) {
                                        case 0: 
                                        case 1: {
                                            break block3;
                                        }
                                    }
                                    action = 1;
                                }
                            }
                        }
                        switch (action) {
                            case 2: {
                                TestNodeWriter tester;
                                if (out.newline) {
                                    this.printIndentation(out);
                                    if (!preferWrapAfterLeftParen || paramIndex != 0) break;
                                    tester = out.testers.get();
                                    PrinterFactory.create(node).print(node, tester);
                                    if (out.column + tester.length + 1 > lineLength) {
                                        firstWrapped = true;
                                    }
                                    out.testers.release(tester);
                                    break;
                                }
                                if (wrapLines) {
                                    tester = out.testers.get();
                                    if (preferWrapAfterLeftParen && paramIndex == 0) {
                                        PrinterFactory.create(node).print(node, tester);
                                        ++tester.length;
                                    } else {
                                        PrinterFactory.create(parameter).print(parameter, tester);
                                    }
                                    if (!preferWrapAfterLeftParen && next != null) {
                                        tester.length = spaceAfterComma ? (tester.length += 2) : ++tester.length;
                                    }
                                    if (out.column + tester.length > lineLength) {
                                        if (paramIndex == 0) {
                                            if (preferWrapAfterLeftParen) {
                                                firstWrapped = result = this.wrapFirst(type, true, next == null, out);
                                            } else if (!indentDeep && !this.shouldWrapAtLowerLevel(parameter.getFirstChild(), lineLength, deepIndentSize, out)) {
                                                if (type == 24) {
                                                    firstWrapped = result = this.wrapFirst(type, true, next == null, out);
                                                } else if (!JavaNodeHelper.isChained(((JavaNode)node).getPreviousSibling())) {
                                                    if (this.isSingleLiteral(parameter)) {
                                                        firstWrapped = result = this.wrapFirst(type, true, next == null, out);
                                                    } else {
                                                        AST first = this.getFirstStringConcat(parameter);
                                                        if (first != null) {
                                                            tester.reset();
                                                            PrinterFactory.create(first).print(first, tester);
                                                            firstWrapped = out.column + tester.length > lineLength ? (result = this.wrapFirst(type, true, next == null, out)) : (result = this.wrapFirst(type, next == null, out));
                                                        } else {
                                                            firstWrapped = parameter.getFirstChild().getType() == 149 ? (result = this.wrapFirst(type, next == null, true, out)) : (result = this.wrapFirst(type, next == null, out));
                                                        }
                                                    }
                                                }
                                            }
                                        } else {
                                            out.printNewline();
                                            this.printIndentation(out);
                                            result = true;
                                        }
                                    } else if (wrapIfFirst && firstWrapped) {
                                        int length;
                                        int indentLength = out.getIndentLength();
                                        Marker m = out.state.markers.getLast();
                                        int n = length = m.column > indentLength ? m.column - indentLength : m.column;
                                        if (length + indentLength + 1 != out.column) {
                                            out.printNewline();
                                            this.printIndentation(out);
                                            result = true;
                                        } else if (spaceAfterComma) {
                                            out.print(" ", 153);
                                        }
                                    } else if (spaceAfterComma && paramIndex != 0) {
                                        out.print(" ", 153);
                                    }
                                    out.testers.release(tester);
                                    break;
                                }
                                if (!spaceAfterComma || paramIndex == 0) break;
                                out.print(" ", 153);
                                break;
                            }
                            case 1: {
                                TestNodeWriter tester;
                                if (paramIndex != 0) {
                                    if (!out.newline) {
                                        out.printNewline();
                                        result = true;
                                    }
                                    this.printIndentation(out);
                                    break;
                                }
                                if (out.newline) {
                                    this.printIndentation(out);
                                    firstWrapped = true;
                                    break;
                                }
                                if (preferWrapAfterLeftParen || !indentDeep) {
                                    if (next == null) {
                                        tester = out.testers.get();
                                        PrinterFactory.create(parameter).print(parameter, tester);
                                        if (out.column + tester.length + 1 > lineLength) {
                                            result = this.wrapFirst(type, true, next == null, out);
                                            firstWrapped = true;
                                        }
                                        out.testers.release(tester);
                                        break;
                                    }
                                    firstWrapped = result = this.wrapFirst(type, preferWrapAfterLeftParen || !indentDeep, next == null, out);
                                    break;
                                }
                                if (out.column <= deepIndentSize) break;
                                firstWrapped = result = this.wrapFirst(type, preferWrapAfterLeftParen, next == null, out);
                            }
                        }
                    } else if (spaceAfterComma && paramIndex != 0) {
                        out.print(" ", 153);
                    }
                    PrinterFactory.create(parameter).print(parameter, out);
                    ++paramIndex;
                }
            }
            parameter = next;
        }
        if (out.mode == 1) {
            out.state.paramList = false;
            --out.state.paramLevel;
            out.state.parenScope.removeFirst();
        }
        return result;
    }

    private boolean shouldWrapAtLowerLevel(AST node, int lineLength, int deepIndent, NodeWriter out) throws IOException {
        for (AST child = node; child != null; child = child.getNextSibling()) {
            switch (child.getType()) {
                case 38: 
                case 119: 
                case 135: {
                    AST first = child;
                    block18: for (AST next = node.getFirstChild(); next != null; next = next.getFirstChild()) {
                        switch (next.getType()) {
                            case 135: {
                                continue block18;
                            }
                            default: {
                                first = next;
                                break block18;
                            }
                        }
                    }
                    switch (first.getType()) {
                        case 149: {
                            TestNodeWriter tester = out.testers.get();
                            PrinterFactory.create(first).print(first, tester);
                            if (out.column + tester.length > lineLength) {
                                out.testers.release(tester);
                                return false;
                            }
                            out.testers.release(tester);
                        }
                    }
                    return true;
                }
                case 31: {
                    AST name = child.getFirstChild();
                    if (out.column < deepIndent && JavaNodeHelper.isChained(name)) {
                        return true;
                    }
                    String text = JavaNodeHelper.getDottedName(name);
                    if (out.column + text.length() > lineLength) {
                        return false;
                    }
                    AST elist = name.getNextSibling();
                    int paramNum = 0;
                    for (AST param = elist.getFirstChild(); param != null; param = param.getNextSibling()) {
                        ++paramNum;
                    }
                    return paramNum > 0;
                }
                case 146: {
                    AST name = child.getFirstChild();
                    if (out.column + 4 + name.getText().length() > lineLength) {
                        return false;
                    }
                    for (AST c = child.getFirstChild(); c != null; c = c.getNextSibling()) {
                        switch (c.getType()) {
                            case 33: {
                                return false;
                            }
                            case 10: {
                                return true;
                            }
                        }
                    }
                    AST elist = name.getNextSibling();
                    boolean paramNum = false;
                    for (AST param = elist.getFirstChild(); param != null; param = param.getNextSibling()) {
                        if (!paramNum) continue;
                        return true;
                    }
                    return false;
                }
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 136: 
                case 141: {
                    return true;
                }
                case 84: {
                    return this.shouldWrapAtLowerLevel(PrinterHelper.advanceToFirstNonParen(child), deepIndent, lineLength, out);
                }
            }
        }
        return false;
    }

    private boolean wrapFirst(int type, boolean last, NodeWriter out) throws IOException {
        return this.wrapFirst(type, false, last, out);
    }

    private boolean wrapFirst(int type, boolean force, boolean last, NodeWriter out) throws IOException {
        boolean result = false;
        if (!settings.getBoolean(ConventionKeys.INDENT_DEEP, false) || !last) {
            switch (out.state.paramLevel) {
                case 0: {
                    if (!out.state.markers.isMarked()) {
                        throw new IllegalStateException("not inside parentheses and no marker found");
                    }
                }
                case 1: {
                    int length = out.indentSize;
                    if (force || length + out.getIndentLength() < out.column && length > out.column - out.indentSize) {
                        int column = out.column;
                        out.printNewline();
                        this.printIndentation(out);
                        result = true;
                        this.adjustAlignmentOffset(column, out);
                    }
                    out.state.markers.add();
                    break;
                }
                default: {
                    Marker marker = out.state.markers.get(out.state.markers.count - 2);
                    int indentLength = out.getIndentLength();
                    int offset = (marker.column > indentLength ? marker.column - indentLength : marker.column) + out.indentSize;
                    if (offset + indentLength < out.column && (offset + indentLength < out.column - out.indentSize || offset + indentLength > out.column + out.indentSize)) {
                        int column = out.column;
                        out.printNewline();
                        this.printIndentation(out);
                        result = true;
                        this.adjustAlignmentOffset(column, out);
                    }
                    out.state.markers.add();
                    break;
                }
            }
        }
        return result;
    }
}

