/*
 * (c) Copyright: Artenum SARL, 101-103 Boulevard Mac Donald,
 *                75019, Paris, France 2005.
 *                http://www.artenum.com
 *
 * License:
 *
 *  This program is free software; you can redistribute it
 *  and/or modify it under the terms of the Q Public License;
 *  either version 1 of the License.
 *
 *  This program is distributed in the hope that it will be
 *  useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 *  PURPOSE. See the Q Public License for more details.
 *
 *  You should have received a copy of the Q Public License
 *  License along with this program;
 *  if not, write to:
 *    Artenum SARL, 101-103 Boulevard Mac Donald,
 *    75019, PARIS, FRANCE, e-mail: contact@artenum.com
 */

/*
 * Created on 22 aot 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package com.artenum.jyconsole.test;

import com.artenum.gui.tk.GUILogger;

import com.artenum.jyconsole.io.SingleThreadStream;
import com.artenum.jyconsole.python.JInteractiveInterpreter;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JFrame;

/**
 * @author Sebastien Jourdain, jourdain@artenum.com
 */
public class Main {
    public static void main(String[] args) {
        final JInteractiveInterpreter interpreter1 = new JInteractiveInterpreter(false);
        final JInteractiveInterpreter interpreter2 = new JInteractiveInterpreter(false);

        GUILogger logger = new GUILogger();
        interpreter1.addOut(new SingleThreadStream(logger.getStreamedLogged(GUILogger.STYLE_NORMAL), "Writer1"));
        interpreter1.addErr(new SingleThreadStream(logger.getStreamedLogged(GUILogger.STYLE_NORMAL), "Writer1"));
        //
        GUILogger logger2 = new GUILogger();
        interpreter2.addOut(new SingleThreadStream(logger2.getStreamedLogged(GUILogger.STYLE_NORMAL), "Writer2"));
        interpreter2.addErr(new SingleThreadStream(logger2.getStreamedLogged(GUILogger.STYLE_NORMAL), "Writer2"));
        //
        JButton write = new JButton("Write");
        write.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    new Thread(new Runnable() {
                            public void run() {
                                interpreter1.runsource("print \"hello1\"");
                            }
                        }, "Writer1").start();
                    new Thread(new Runnable() {
                            public void run() {
                                interpreter2.runsource("print \"hello2\"");
                            }
                        }, "Writer2").start();
                }
            });

        //
        JFrame f = new JFrame("Test logger");
        f.getContentPane().setLayout(new BorderLayout());
        f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        f.getContentPane().add(logger, BorderLayout.WEST);
        f.getContentPane().add(write, BorderLayout.CENTER);

        f.getContentPane().add(logger2, BorderLayout.EAST);
        f.pack();
        f.setLocationRelativeTo(null);
        f.setVisible(true);
    }
}
